/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.Dispatcher;
import host.anzo.simon.SimonPhantomRef;
import host.anzo.simon.SimonProxy;
import host.anzo.simon.exceptions.SessionException;
import host.anzo.simon.exceptions.SimonException;
import host.anzo.simon.utils.Utils;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimonRefQueue<T extends SimonPhantomRef>
extends ReferenceQueue<T>
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimonRefQueue.class);
    private final List<Reference> refs = new ArrayList<Reference>();
    private static final int REMOVE_TIMEOUT = 5000;
    private final Thread refCleanerThread;
    private final Dispatcher dispatcher;

    SimonRefQueue(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.refCleanerThread = new Thread((Runnable)this, "SimonRefQueue#" + this.hashCode());
        this.refCleanerThread.setDaemon(true);
        this.refCleanerThread.start();
    }

    public synchronized void addRef(SimonProxy simonProxy) {
        if (!this.refCleanerThread.isAlive() || this.refCleanerThread.isInterrupted()) {
            throw new IllegalStateException("refCleanerThread not longer active. Shutdown in progress?");
        }
        SimonPhantomRef<SimonProxy> ref = new SimonPhantomRef<SimonProxy>(simonProxy, this);
        log.debug("Adding ref: {}", ref);
        this.refs.add(ref);
        log.debug("Ref count after add: {}", (Object)this.refs.size());
    }

    @Override
    public void run() {
        while (!this.refCleanerThread.isInterrupted()) {
            try {
                SimonPhantomRef ref = (SimonPhantomRef)this.remove(5000L);
                if (ref == null) continue;
                log.debug("Releasing: {}", (Object)ref);
                this.refs.remove(ref);
                ref.clear();
                log.debug("Ref count after remove: {}", (Object)this.refs.size());
                this.sendRelease(ref);
            }
            catch (InterruptedException ex) {
                this.refCleanerThread.interrupt();
            }
        }
        log.debug(Thread.currentThread().getName() + " terminated");
    }

    synchronized void cleanup() {
        log.debug("Stopping refCleanerThread");
        this.refCleanerThread.interrupt();
        log.debug("Sending release for {} refs", (Object)this.refs.size());
        while (!this.refs.isEmpty()) {
            SimonPhantomRef ref = (SimonPhantomRef)this.refs.remove(0);
            this.sendRelease(ref);
        }
        this.refs.clear();
    }

    private void sendRelease(SimonPhantomRef ref) {
        try {
            if (ref.getSession().isConnected()) {
                this.dispatcher.sendReleaseRef(ref.getSession(), ref.getRefId());
            } else {
                log.debug("Sending release for ref {} not possible due to closed session {}.", (Object)ref, (Object)Utils.longToHexString(ref.getSession().getId()));
            }
        }
        catch (SimonException ex) {
            log.warn("Not able to send a 'release ref' for " + ref, (Throwable)ex);
        }
        catch (SessionException ex) {
            log.warn("Not able to send a 'release ref' for " + ref, (Throwable)ex);
        }
    }
}

