/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.AbstractMessageEncoder;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgError;
import host.anzo.simon.codec.messages.MsgInterfaceLookupReturn;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgInterfaceLookupReturnEncoder<T extends MsgInterfaceLookupReturn>
extends AbstractMessageEncoder<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MsgInterfaceLookupReturnEncoder.class);

    @Override
    protected void encodeBody(IoSession session, T message, IoBuffer out) {
        log.trace("sending interfaces ...");
        String[] interfaces = ((MsgInterfaceLookupReturn)message).getInterfacesString();
        try {
            out.putPrefixedString((CharSequence)((MsgInterfaceLookupReturn)message).getRemoteObjectName(), Charset.forName("UTF-8").newEncoder());
        }
        catch (CharacterCodingException ex) {
            MsgError error = new MsgError();
            error.setEncodeError();
            error.setErrorMessage("Error while encoding interface lookup() return: Not able to write remote object name '" + ((MsgInterfaceLookupReturn)message).getRemoteObjectName() + "' due to CharacterCodingException.");
            error.setRemoteObjectName(((MsgInterfaceLookupReturn)message).getRemoteObjectName());
            error.setInitSequenceId(((AbstractMessage)message).getSequence());
            error.setThrowable(ex);
            this.sendEncodingError(out, session, error);
            return;
        }
        out.putInt(interfaces.length);
        log.trace("interfaces to send: {}", (Object)interfaces.length);
        for (String class1 : interfaces) {
            try {
                log.trace("interface={}", (Object)class1);
                out.putPrefixedString((CharSequence)class1, Charset.forName("UTF-8").newEncoder());
            }
            catch (CharacterCodingException e) {
                MsgError error = new MsgError();
                error.setEncodeError();
                error.setErrorMessage("Error while encoding interface lookup() return: Not able to write interface name '" + class1 + "' due to CharacterCodingException.");
                error.setRemoteObjectName(((MsgInterfaceLookupReturn)message).getRemoteObjectName());
                error.setInitSequenceId(((AbstractMessage)message).getSequence());
                error.setThrowable(e);
                this.sendEncodingError(out, session, error);
                return;
            }
        }
        try {
            log.trace("sending erorMsg: '{}'", (Object)((AbstractMessage)message).getErrorMsg());
            out.putPrefixedString((CharSequence)((AbstractMessage)message).getErrorMsg(), Charset.forName("UTF-8").newEncoder());
        }
        catch (CharacterCodingException e) {
            MsgError error = new MsgError();
            error.setEncodeError();
            error.setErrorMessage("Error while encoding interface lookup() return: Not able to write errorMsg '" + ((AbstractMessage)message).getErrorMsg() + "' due to CharacterCodingException.");
            error.setRemoteObjectName(((MsgInterfaceLookupReturn)message).getRemoteObjectName());
            error.setInitSequenceId(((AbstractMessage)message).getSequence());
            error.setThrowable(e);
            this.sendEncodingError(out, session, error);
            return;
        }
        log.trace("finished");
    }
}

