/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.Dispatcher;
import host.anzo.simon.Statics;
import host.anzo.simon.codec.base.AbstractMessageEncoder;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgInvoke;
import host.anzo.simon.codec.messages.MsgInvokeReturn;
import host.anzo.simon.exceptions.SimonRemoteException;
import host.anzo.simon.utils.Utils;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgInvokeEncoder<T extends MsgInvoke>
extends AbstractMessageEncoder<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MsgInvokeEncoder.class);

    @Override
    protected void encodeBody(IoSession session, T message, IoBuffer out) {
        log.trace("begin. message={}", message);
        try {
            out.putPrefixedString((CharSequence)((MsgInvoke)message).getRemoteObjectName(), Charset.forName("UTF-8").newEncoder());
            out.putLong(Utils.computeMethodHash(((MsgInvoke)message).getMethod()));
            int argsLen = 0;
            if (((MsgInvoke)message).getArguments() != null) {
                argsLen = ((MsgInvoke)message).getArguments().length;
            }
            log.trace("argsLength={}", (Object)argsLen);
            out.putInt(argsLen);
            for (int i = 0; i < argsLen; ++i) {
                log.trace("args[{}]={}", (Object)i, ((MsgInvoke)message).getArguments()[i]);
                out.putObject(((MsgInvoke)message).getArguments()[i]);
            }
        }
        catch (Exception e) {
            String errorMsg = "Failed to transfer invoke command to the server. error=" + e.getMessage();
            log.warn(errorMsg);
            Dispatcher dispatcher = (Dispatcher)session.getAttribute((Object)Statics.SESSION_ATTRIBUTE_DISPATCHER);
            MsgInvokeReturn mir = new MsgInvokeReturn();
            mir.setSequence(((AbstractMessage)message).getSequence());
            mir.setReturnValue(new SimonRemoteException(errorMsg, e));
            try {
                dispatcher.messageReceived(session, mir);
            }
            catch (Exception e1) {
                log.error("Got exception when calling 'dispatcher.messageReceived()'", (Throwable)e1);
            }
        }
        log.trace("end");
    }
}

