/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.utils;

import host.anzo.simon.utils.Utils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ConsoleLogFormatter
extends Formatter {
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String CRLF = "\r\n";

    @Override
    public String format(LogRecord record) {
        StringBuilder output = new StringBuilder();
        output.append(simpleDateFormat.format(new Date(record.getMillis())));
        StringBuilder sb = new StringBuilder();
        java.util.Formatter formatter = new java.util.Formatter(sb, Locale.getDefault());
        formatter.format(" %-7s ", record.getLevel().getName());
        output.append((CharSequence)sb);
        output.append("tid=");
        output.append(record.getThreadID());
        output.append(" ");
        output.append(record.getSourceClassName());
        output.append(".");
        output.append(record.getSourceMethodName());
        output.append(": ");
        output.append(record.getMessage());
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            output.append(CRLF);
            output.append(Utils.getStackTraceAsString(thrown));
        }
        output.append(CRLF);
        return output.toString();
    }
}

