/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.Dispatcher;
import host.anzo.simon.exceptions.RawChannelException;
import host.anzo.simon.exceptions.SimonRemoteException;
import java.nio.ByteBuffer;
import lombok.Generated;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawChannel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RawChannel.class);
    private final Dispatcher dispatcher;
    private final IoSession session;
    private final int channelToken;
    private boolean channelOpen = true;

    protected RawChannel(Dispatcher dispatcher, IoSession session, int channelToken) {
        log.debug("token={}", (Object)channelToken);
        this.dispatcher = dispatcher;
        this.session = session;
        this.channelToken = channelToken;
    }

    public void write(ByteBuffer byteBuffer) throws IllegalStateException, SimonRemoteException, RawChannelException {
        if (!this.channelOpen) {
            throw new IllegalStateException("Instance of RawChannel already closed!");
        }
        log.trace("token={}. channel open. forwarding to dispatcher ...", (Object)this.channelToken);
        this.dispatcher.writeRawData(this.session, this.channelToken, byteBuffer);
        log.trace("token={}. data forwarded", (Object)this.channelToken);
    }

    public boolean isClosed() {
        return !this.channelOpen;
    }

    public void close() throws IllegalStateException, SimonRemoteException, RawChannelException {
        if (!this.channelOpen) {
            throw new IllegalStateException("Instance of RawChannel already closed!");
        }
        this.dispatcher.closeRawChannel(this.session, this.channelToken);
        this.channelOpen = false;
    }
}

