/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.Simon;
import host.anzo.simon.SimonRemoteMarker;
import host.anzo.simon.annotation.SimonRemote;
import host.anzo.simon.utils.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimonRemoteInstance
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimonRemoteInstance.class);
    private static final long serialVersionUID = 1L;
    static final String PREFIX = "SimonRemoteInstance";
    private List<String> interfaceNames = new ArrayList<String>();
    private String id = null;
    private String remoteObjectName = null;
    private long sessionId;

    protected SimonRemoteInstance(IoSession session, Object remoteObject) {
        log.debug("begin");
        this.sessionId = session.getId();
        try {
            this.remoteObjectName = Simon.getSimonProxy(remoteObject).getRemoteObjectName();
        }
        catch (IllegalArgumentException e) {
            this.remoteObjectName = "{SimonRemoteInstance:RemoteObjectNameNotAvailable}";
        }
        String IP = session.getRemoteAddress().toString();
        this.sessionId = session.getId();
        StringBuilder sb = new StringBuilder();
        sb.append(PREFIX);
        sb.append("[");
        sb.append(remoteObject.getClass().getName());
        sb.append("|ip=");
        sb.append(IP);
        sb.append(";sessionID=");
        sb.append(this.sessionId);
        sb.append(";remoteObjectHash=");
        sb.append(Utils.hash(remoteObject));
        sb.append("]");
        this.id = sb.toString();
        log.debug("SimonRemoteInstance created with id={}", (Object)this.id);
        SimonRemoteMarker marker = Utils.getMarker(remoteObject);
        Class<?>[] remoteInterfacesInAnnotation = null;
        boolean isAnnotated = Utils.isRemoteAnnotated(remoteObject);
        if (isAnnotated) {
            SimonRemote annotation = remoteObject.getClass().getAnnotation(SimonRemote.class);
            remoteInterfacesInAnnotation = annotation.value();
            log.trace("SimonRemoteObject is annotated with SimonRemote");
        }
        if (marker != null) {
            log.debug("Provided remote object is a marked object.");
            Utils.putAllInterfaceNames(marker.getObjectToBeMarked(), this.interfaceNames);
            log.debug("Got interfaces: {}", this.interfaceNames);
        } else if (remoteInterfacesInAnnotation != null && remoteInterfacesInAnnotation.length > 0) {
            log.trace("SimonRemoteObject has defined interfaces in it's annotation");
            for (Class<?> interfaceClazz : remoteInterfacesInAnnotation) {
                String clazzName = interfaceClazz.getCanonicalName();
                log.trace("Adding {} to the list of remote interfaces", (Object)clazzName);
                this.interfaceNames.add(clazzName);
            }
        } else {
            log.trace("Need to manually search for remote interfaces ...");
            if (isAnnotated) {
                log.trace("Getting all (sub)interfaces...");
                Utils.putAllInterfaceNames(remoteObject, this.interfaceNames);
            }
        }
        log.debug("end");
    }

    List<String> getInterfaceNames() {
        return this.interfaceNames;
    }

    String getId() {
        return this.id;
    }

    String getRemoteObjectName() {
        return this.remoteObjectName;
    }

    long getSessionID() {
        return this.sessionId;
    }
}

