/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.Dispatcher;
import host.anzo.simon.LookupTableMBean;
import host.anzo.simon.RemoteObjectContainer;
import host.anzo.simon.RemoteRefContainer;
import host.anzo.simon.Simon;
import host.anzo.simon.SimonRemoteInstance;
import host.anzo.simon.SimonUnreferenced;
import host.anzo.simon.exceptions.LookupFailedException;
import host.anzo.simon.utils.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupTable
implements LookupTableMBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LookupTable.class);
    private final HashMap<String, RemoteObjectContainer> bindings = new HashMap();
    private final Map<Long, List<String>> gcRemoteInstances = new HashMap<Long, List<String>>();
    private final Map<Object, Map<Long, Method>> remoteObject_to_hashToMethod_Map = new HashMap<Object, Map<Long, Method>>();
    private final Set<Object> remoteobjectSet = new HashSet<Object>();
    private final Map<Long, Map<String, RemoteRefContainer>> sessionRefCount = new HashMap<Long, Map<String, RemoteRefContainer>>();
    private Dispatcher dispatcher;
    private boolean cleanupDone = false;

    protected LookupTable(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        Simon.registerLookupTable(this);
        String objectNameOfMBean = "host.anzo.simon:type=LookupTable,subType=" + (dispatcher.getServerString() == null ? "server" : "client") + ",instance=LookupTable@" + this.hashCode();
        Utils.registerMBean(this, objectNameOfMBean);
    }

    synchronized void putRemoteBinding(String remoteObjectName, Object remoteObject) {
        log.debug("begin");
        log.debug("remoteObjectName={} object={}", (Object)remoteObjectName, remoteObject);
        this.addRemoteObjectToSet(remoteObject);
        RemoteObjectContainer roc = new RemoteObjectContainer(remoteObject, remoteObjectName, remoteObject.getClass().getInterfaces());
        this.bindings.put(remoteObjectName, roc);
        log.debug("Put {} to remoteObject_to_hashToMethod_Map", remoteObject);
        Map put = this.remoteObject_to_hashToMethod_Map.put(remoteObject, this.computeMethodHashMap(remoteObject.getClass()));
        if (put != null) {
            log.error("remoteobject {} already existed int remoteObject_to_hashToMethod_Map", remoteObject);
        }
        log.debug("end");
    }

    private void addRemoteObjectToSet(Object remoteObject) {
        int hashCode = remoteObject.hashCode();
        this.remoteobjectSet.add(remoteObject);
        log.trace("Adding remote object {} with hash={}", remoteObject, (Object)hashCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCallbackRef(long sessionId, String refId, Object object) {
        log.debug("Adding {}", (Object)refId);
        Map<Long, Map<String, RemoteRefContainer>> map = this.sessionRefCount;
        synchronized (map) {
            Map<String, RemoteRefContainer> sessionMap = this.sessionRefCount.get(sessionId);
            if (sessionMap == null) {
                sessionMap = new HashMap<String, RemoteRefContainer>();
                sessionMap.put(refId, new RemoteRefContainer(object));
                log.debug("Added RefCounter for {}. {}", (Object)refId, (Object)this.toString());
                this.sessionRefCount.put(sessionId, sessionMap);
            } else {
                RemoteRefContainer ref = sessionMap.get(refId);
                if (ref == null) {
                    ref = new RemoteRefContainer(object);
                    sessionMap.put(refId, ref);
                } else {
                    ref.addRef();
                }
                log.debug("RefCount for {} is now: {}", (Object)refId, (Object)ref.getRefCount());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeCallbackRef(long sessionId, String refId) {
        log.debug("Releasing {}", (Object)refId);
        Map<Long, Map<String, RemoteRefContainer>> map = this.sessionRefCount;
        synchronized (map) {
            Map<String, RemoteRefContainer> sessionMap = this.sessionRefCount.get(sessionId);
            if (sessionMap == null) {
                log.debug("Session {} has no refs available. Something went wrong! Ref to release: {}", (Object)Utils.longToHexString(sessionId), (Object)refId);
            } else {
                RemoteRefContainer ref = sessionMap.get(refId);
                if (ref != null) {
                    int oldCount = ref.getRefCount();
                    int newCount = ref.removeRef();
                    log.debug("new count for ref {} is: {}; was: {}", new Object[]{refId, newCount, oldCount});
                    if (newCount == 0) {
                        sessionMap.remove(refId);
                        log.trace("session map now contains {} items", (Object)sessionMap.size());
                        if (sessionMap.isEmpty()) {
                            this.sessionRefCount.remove(sessionId);
                            log.trace("{} sessions have references", (Object)this.sessionRefCount.size());
                        }
                    }
                } else {
                    log.warn("Something went wrong: ref {} not found in sessionmap on session {}", (Object)refId, (Object)Utils.longToHexString(sessionId));
                }
            }
            this.releaseRemoteBinding(refId);
            Map<Long, List<String>> map2 = this.gcRemoteInstances;
            synchronized (map2) {
                List<String> list = this.gcRemoteInstances.get(sessionId);
                if (list != null) {
                    boolean remove = list.remove(refId);
                    log.debug("Removed {} from list of gcRemoteInstance for session {}", (Object)refId, (Object)sessionId);
                }
            }
        }
    }

    synchronized void putRemoteInstance(long sessionId, SimonRemoteInstance simonRemoteInstance, Object remoteObject) {
        List<String> remoteObjectNames;
        log.debug("begin");
        String sriRemoteObjectName = simonRemoteInstance.getId();
        log.debug("sessionId={} sriRemoteObjectName={} remoteObject={}", new Object[]{Utils.longToHexString(sessionId), sriRemoteObjectName, remoteObject});
        this.addCallbackRef(sessionId, sriRemoteObjectName, remoteObject);
        if (!this.gcRemoteInstances.containsKey(sessionId)) {
            log.debug("session '{}' unknown, creating new remote instance list!", (Object)Utils.longToHexString(sessionId));
            remoteObjectNames = new ArrayList<String>();
            this.gcRemoteInstances.put(sessionId, remoteObjectNames);
        } else {
            remoteObjectNames = this.gcRemoteInstances.get(sessionId);
        }
        if (!remoteObjectNames.contains(sriRemoteObjectName)) {
            remoteObjectNames.add(sriRemoteObjectName);
            this.putRemoteBinding(sriRemoteObjectName, remoteObject);
            log.debug("session '{}' now has {} entries.", (Object)Utils.longToHexString(sessionId), (Object)remoteObjectNames.size());
        } else {
            log.debug("sriRemoteObjectName={} already known. Skipping.", (Object)sriRemoteObjectName);
        }
        log.debug("end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteObjectContainer getRemoteObjectContainer(String remoteObjectName) throws LookupFailedException {
        log.debug("begin");
        HashMap<String, RemoteObjectContainer> hashMap = this.bindings;
        synchronized (hashMap) {
            if (!this.bindings.containsKey(remoteObjectName)) {
                log.debug("remote object name=[{}] not found in LookupTable!", (Object)remoteObjectName);
                throw new LookupFailedException("remoteobject with name [" + remoteObjectName + "] not found in lookup table.");
            }
            log.debug("name={} resolves to object='{}'", (Object)remoteObjectName, (Object)this.bindings.get(remoteObjectName));
            log.debug("end");
            return this.bindings.get(remoteObjectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void releaseRemoteBinding(String name) {
        log.debug("begin");
        log.debug("name={}", (Object)name);
        HashMap<String, RemoteObjectContainer> hashMap = this.bindings;
        synchronized (hashMap) {
            RemoteObjectContainer remoteObjectContainer = this.bindings.remove(name);
            if (remoteObjectContainer != null) {
                Object remoteObject = remoteObjectContainer.getRemoteObject();
                log.debug("cleaning up [{}]", remoteObject);
                this.removeRemoteObjectFromSet(remoteObject);
                log.debug("Removing {} from remoteObject_to_hashToMethod_Map", remoteObject);
                Map<Long, Method> remove = this.remoteObject_to_hashToMethod_Map.remove(remoteObject);
                if (remove == null) {
                    log.error("Object {} NOT removed from remoteObject_to_hashToMethod_Map. ROC={}", remoteObject, (Object)remoteObjectContainer);
                }
            } else {
                log.debug("[{}] already removed or not available. nothing to do.", (Object)name);
            }
        }
        log.debug("end");
    }

    private void removeRemoteObjectFromSet(@NotNull Object remoteObject) {
        int hashCode = remoteObject.hashCode();
        log.debug("remoteObject={} hash={} map={}", new Object[]{remoteObject, hashCode, this.remoteobjectSet});
        boolean removed = this.remoteobjectSet.remove(remoteObject);
        if (!removed) {
            log.error("Object NOT removed!");
        }
        log.trace("Removed remote object {} with hash={}; removed={}", new Object[]{remoteObject, hashCode, removed});
    }

    public synchronized Method getMethod(String remoteObjectName, long methodHash) {
        Map<Long, Method> remoteObjectMethods;
        Object remoteObject;
        log.debug("begin");
        RemoteObjectContainer remoteObjectContainer = this.bindings.get(remoteObjectName);
        if (remoteObjectContainer != null && (remoteObject = remoteObjectContainer.getRemoteObject()) != null && (remoteObjectMethods = this.remoteObject_to_hashToMethod_Map.get(remoteObject)) != null) {
            Method method = remoteObjectMethods.get(methodHash);
            log.debug("hash={} resolves to method='{}'", (Object)methodHash, (Object)method);
            log.debug("end");
            return method;
        }
        log.debug("Can't resolve method={} for remoteObjectName={}", (Object)methodHash, (Object)remoteObjectName);
        log.debug("end");
        return null;
    }

    private HashMap<Long, Method> computeMethodHashMap(Class<?> remoteClass) {
        log.debug("begin");
        log.debug("computing for remoteclass='{}'", remoteClass);
        HashMap<Long, Method> map = new HashMap<Long, Method>();
        for (Class<?> cl = remoteClass; cl != null; cl = cl.getSuperclass()) {
            log.debug("examin superclass='{}' for interfaces", cl);
            for (Class<?> intf : cl.getInterfaces()) {
                log.debug("examin superclass' interface='{}'", intf);
                for (Method method : intf.getMethods()) {
                    method.setAccessible(true);
                    long methodHash = Utils.computeMethodHash(method);
                    map.put(methodHash, method);
                    log.debug("computing hash: method='{}' hash={}", (Object)method, (Object)methodHash);
                }
            }
        }
        log.debug("begin");
        return map;
    }

    void cleanup() {
        log.debug("begin");
        Simon.unregisterLookupTable(this);
        for (Long aLong : this.gcRemoteInstances.keySet()) {
            this.unreference(aLong);
        }
        this.sessionRefCount.clear();
        this.bindings.clear();
        this.remoteObject_to_hashToMethod_Map.clear();
        this.sessionRefCount.clear();
        this.cleanupDone = true;
        log.debug("end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unreference(long sessionId) {
        List<String> list;
        String id = Utils.longToHexString(sessionId);
        log.debug("begin. sessionId={} cleanupDone={}", (Object)id, (Object)this.cleanupDone);
        Object object = this.gcRemoteInstances;
        synchronized (object) {
            list = this.gcRemoteInstances.remove(sessionId);
        }
        object = this.sessionRefCount;
        synchronized (object) {
            this.sessionRefCount.remove(sessionId);
        }
        if (list != null) {
            if (log.isDebugEnabled()) {
                log.debug("sessionId={} There are {} remote instances to be unreferenced.", (Object)id, (Object)list.size());
            }
            for (String remoteObjectName : list) {
                if (log.isDebugEnabled()) {
                    log.debug("sessionId={} Unreferencing: {}", (Object)id, (Object)remoteObjectName);
                }
                HashMap<String, RemoteObjectContainer> hashMap = this.bindings;
                synchronized (hashMap) {
                    RemoteObjectContainer container = this.bindings.remove(remoteObjectName);
                    log.debug("sessionId={} RemoteObjectContainer to unreference: {}", (Object)id, (Object)container);
                    if (container != null) {
                        Object remoteInstanceBindingToRemove = container.getRemoteObject();
                        log.debug("sessionId={} simon remote to unreference: {}", (Object)id, remoteInstanceBindingToRemove);
                        this.removeRemoteObjectFromSet(remoteInstanceBindingToRemove);
                        this.remoteObject_to_hashToMethod_Map.remove(remoteInstanceBindingToRemove);
                        if (remoteInstanceBindingToRemove instanceof SimonUnreferenced) {
                            SimonUnreferenced remoteBinding = (SimonUnreferenced)remoteInstanceBindingToRemove;
                            remoteBinding.unreferenced();
                            log.debug("sessionId={} Called the unreferenced() method on {}", (Object)id, remoteInstanceBindingToRemove);
                        }
                    } else {
                        log.debug("Container for {} no longer present?", (Object)remoteObjectName);
                    }
                }
            }
        }
        log.debug("end. sessionId={} ", (Object)id);
    }

    Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    boolean isSimonRemoteRegistered(Object remoteObject) {
        if (remoteObject == null) {
            return false;
        }
        log.trace("searching hash {} in {}", (Object)remoteObject.hashCode(), this.remoteobjectSet);
        return this.remoteobjectSet.contains(remoteObject);
    }

    synchronized RemoteObjectContainer getRemoteObjectContainerByInterface(String interfaceName) throws LookupFailedException {
        RemoteObjectContainer foundContainer = null;
        for (String remoteObjectName : this.bindings.keySet()) {
            RemoteObjectContainer knownContainer = this.bindings.get(remoteObjectName);
            for (Class<?> interfaze : knownContainer.getRemoteObjectInterfaces()) {
                if (!interfaze.getName().equals(interfaceName)) continue;
                if (foundContainer == null) {
                    foundContainer = knownContainer;
                    continue;
                }
                if (foundContainer.getRemoteObject() == knownContainer.getRemoteObject()) continue;
                throw new LookupFailedException("No unique '" + interfaceName + "' interface implementation found in bindings.");
            }
        }
        if (foundContainer == null) {
            throw new LookupFailedException("No '" + interfaceName + "' interface implementation found");
        }
        return foundContainer;
    }

    @Override
    public int getNumberOfRemoteRefSessions() {
        log.debug("{}", (Object)this.toString());
        return this.sessionRefCount.size();
    }

    @Override
    public Long[] getRemoteRefSessions() {
        return this.sessionRefCount.keySet().toArray(new Long[0]);
    }

    @Override
    public String[] getRefIdsForSession(long sessionId) {
        return this.sessionRefCount.get(sessionId).keySet().toArray(new String[0]);
    }

    @Override
    public int getRemoteRefCount(long sessionId, String refId) {
        return this.sessionRefCount.get(sessionId).get(refId).getRefCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalRefCount() {
        int i = 0;
        Map<Long, Map<String, RemoteRefContainer>> map = this.sessionRefCount;
        synchronized (map) {
            for (Long sessionId : this.sessionRefCount.keySet()) {
                Map<String, RemoteRefContainer> refMap = this.sessionRefCount.get(sessionId);
                Collection<RemoteRefContainer> values = refMap.values();
                for (RemoteRefContainer remoteRef : values) {
                    i += remoteRef.getRefCount();
                }
            }
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCallbackRefList() {
        ArrayList<String> list = new ArrayList<String>();
        Map<Long, Map<String, RemoteRefContainer>> map = this.sessionRefCount;
        synchronized (map) {
            for (Long sessionId : this.sessionRefCount.keySet()) {
                Map<String, RemoteRefContainer> refMap = this.sessionRefCount.get(sessionId);
                Collection<RemoteRefContainer> values = refMap.values();
                for (RemoteRefContainer remoteRef : values) {
                    list.add("Session: " + Utils.longToHexString(sessionId) + " -> " + remoteRef.toString());
                }
            }
        }
        return list;
    }
}

