/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.SearchProgressListener;
import host.anzo.simon.SimonPublication;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;

public class PublicationSearcher
extends Thread {
    private static final int groupPort = 4753;
    private InetAddress groupAddress = InetAddress.getByName("239.1.2.3");
    private long searchTime = 2000L;
    private final List<SimonPublication> foundPublications;
    private boolean shutdown = false;
    private int searchProgress = 0;
    private List<SearchProgressListener> listeners = new ArrayList<SearchProgressListener>();

    protected PublicationSearcher(SearchProgressListener listener, int searchTime) throws IOException {
        this.setName("Simon.PublishClient");
        this.foundPublications = new ArrayList<SimonPublication>();
        this.addSearchProgressListener(listener);
        this.searchTime = searchTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DatagramSocket socket = new DatagramSocket(4752);
            byte[] requestData = "[SIMON|FindServer]".getBytes();
            DatagramPacket searchPacket = new DatagramPacket(requestData, requestData.length, this.groupAddress, 4753);
            socket.send(searchPacket);
            socket.setSoTimeout(100);
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() < startTime + this.searchTime && !this.shutdown) {
                try {
                    byte[] buf = new byte[256];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    socket.receive(packet);
                    String received = new String(packet.getData(), 0, packet.getLength());
                    List<SimonPublication> list = this.foundPublications;
                    synchronized (list) {
                        this.foundPublications.add(new SimonPublication(received));
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    // empty catch block
                }
                this.searchProgress = (int)(100.0 / (double)this.searchTime * (double)(System.currentTimeMillis() - startTime));
                if (this.searchProgress > 100) {
                    this.searchProgress = 100;
                }
                this.updateListeners();
            }
            if (this.searchProgress != 100) {
                this.searchProgress = 100;
                this.updateListeners();
            }
            this.listeners.clear();
            socket.close();
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void signalShutdown() {
        this.shutdown = true;
    }

    public void shutdown() {
        this.signalShutdown();
        while (this.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SimonPublication> getNewPublications() {
        ArrayList<SimonPublication> result;
        List<SimonPublication> list = this.foundPublications;
        synchronized (list) {
            result = new ArrayList<SimonPublication>(this.foundPublications);
        }
        this.foundPublications.clear();
        return result;
    }

    public int getSearchProgress() {
        return this.searchProgress;
    }

    private void addSearchProgressListener(SearchProgressListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListeners() {
        int numberOfObjects = 0;
        List<SimonPublication> list = this.foundPublications;
        synchronized (list) {
            numberOfObjects = this.foundPublications.size();
        }
        for (SearchProgressListener listener : this.listeners) {
            listener.update(this.searchProgress, numberOfObjects);
        }
    }

    public boolean isSearching() {
        return this.isAlive();
    }
}

