/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.Dispatcher;
import host.anzo.simon.ProcessMessageThread;
import host.anzo.simon.RawChannelDataListener;
import host.anzo.simon.RemoteObjectContainer;
import host.anzo.simon.Simon;
import host.anzo.simon.SimonEndpointReference;
import host.anzo.simon.SimonProxy;
import host.anzo.simon.SimonRemoteInstance;
import host.anzo.simon.SimonRemoteMarker;
import host.anzo.simon.SimonVoid;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgCloseRawChannel;
import host.anzo.simon.codec.messages.MsgCloseRawChannelReturn;
import host.anzo.simon.codec.messages.MsgEquals;
import host.anzo.simon.codec.messages.MsgEqualsReturn;
import host.anzo.simon.codec.messages.MsgError;
import host.anzo.simon.codec.messages.MsgHashCode;
import host.anzo.simon.codec.messages.MsgHashCodeReturn;
import host.anzo.simon.codec.messages.MsgInterfaceLookup;
import host.anzo.simon.codec.messages.MsgInterfaceLookupReturn;
import host.anzo.simon.codec.messages.MsgInvoke;
import host.anzo.simon.codec.messages.MsgInvokeReturn;
import host.anzo.simon.codec.messages.MsgNameLookup;
import host.anzo.simon.codec.messages.MsgNameLookupReturn;
import host.anzo.simon.codec.messages.MsgOpenRawChannel;
import host.anzo.simon.codec.messages.MsgOpenRawChannelReturn;
import host.anzo.simon.codec.messages.MsgRawChannelData;
import host.anzo.simon.codec.messages.MsgRawChannelDataReturn;
import host.anzo.simon.codec.messages.MsgReleaseRef;
import host.anzo.simon.codec.messages.MsgToString;
import host.anzo.simon.codec.messages.MsgToStringReturn;
import host.anzo.simon.exceptions.LookupFailedException;
import host.anzo.simon.exceptions.RawChannelException;
import host.anzo.simon.exceptions.SessionException;
import host.anzo.simon.exceptions.SimonException;
import host.anzo.simon.exceptions.SimonRemoteException;
import host.anzo.simon.utils.SimonClassLoaderHelper;
import host.anzo.simon.utils.Utils;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;
import java.util.List;
import lombok.Generated;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessMessageRunnable
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessMessageRunnable.class);
    private final AbstractMessage abstractMessage;
    private final IoSession session;
    private final Dispatcher dispatcher;

    protected ProcessMessageRunnable(Dispatcher dispatcher, IoSession session, AbstractMessage abstractMessage) {
        this.dispatcher = dispatcher;
        this.session = session;
        this.abstractMessage = abstractMessage;
    }

    @Override
    public void run() {
        log.debug("ProcessMessageRunnable: {} on sessionId {}", (Object)this.abstractMessage, (Object)Utils.longToHexString(this.session.getId()));
        ProcessMessageThread currentThread = (ProcessMessageThread)Thread.currentThread();
        currentThread.setSessionId(this.session.getId());
        byte msgType = this.abstractMessage.getMsgType();
        switch (msgType) {
            case 0: {
                this.processNameLookup();
                break;
            }
            case 18: {
                this.processInterfaceLookup();
                break;
            }
            case 1: {
                this.processNameLookupReturn();
                break;
            }
            case 19: {
                this.processInterfaceLookupReturn();
                break;
            }
            case 2: {
                this.processInvoke();
                break;
            }
            case 3: {
                this.processInvokeReturn();
                break;
            }
            case 4: {
                this.processToString();
                break;
            }
            case 5: {
                this.processToStringReturn();
                break;
            }
            case 6: {
                this.processEquals();
                break;
            }
            case 7: {
                this.processEqualsReturn();
                break;
            }
            case 8: {
                this.processHashCode();
                break;
            }
            case 9: {
                this.processHashCodeReturn();
                break;
            }
            case 10: {
                this.processOpenRawChannel();
                break;
            }
            case 11: {
                this.processOpenRawChannelReturn();
                break;
            }
            case 12: {
                this.processCloseRawChannel();
                break;
            }
            case 13: {
                this.processCloseRawChannelReturn();
                break;
            }
            case 14: {
                this.processRawChannelData();
                break;
            }
            case 15: {
                this.processRawChannelDataReturn();
                break;
            }
            case 16: {
                this.processPing();
                break;
            }
            case 17: {
                this.processPong();
                break;
            }
            case 20: {
                this.processError();
                break;
            }
            case 21: {
                this.processReleaseRef();
                break;
            }
            default: {
                log.error("ProcessMessageRunnable: msgType={} not supported! terminating...", (Object)msgType);
                System.exit(1);
            }
        }
    }

    private void processRawChannelDataReturn() {
        log.debug("begin");
        log.debug("processing MsgRawChannelDataReturn...");
        MsgRawChannelDataReturn msg = (MsgRawChannelDataReturn)this.abstractMessage;
        this.dispatcher.putResultToQueue(this.session, msg.getSequence(), msg);
        log.debug("put result to queue={}", (Object)msg);
        log.debug("end");
    }

    private void processPing() {
        log.debug("begin");
        log.debug("processing MsgPing...");
        log.debug("replying pong");
        try {
            this.dispatcher.sendPong(this.session);
        }
        catch (SessionException e) {
            log.warn("could not reply pong for seqId {}. Error was: {}", (Object)this.abstractMessage.getSequence(), (Object)e.getMessage());
        }
        log.debug("end");
    }

    private void processPong() {
        log.debug("begin");
        log.debug("processing MsgPong...");
        this.dispatcher.getPingWatchdog().notifyPongReceived(this.session);
        log.debug("end");
    }

    private void processOpenRawChannel() {
        log.debug("begin");
        log.debug("processing MsgOpenRawChannel...");
        MsgOpenRawChannel msg = (MsgOpenRawChannel)this.abstractMessage;
        MsgOpenRawChannelReturn returnMsg = new MsgOpenRawChannelReturn();
        returnMsg.setSequence(msg.getSequence());
        returnMsg.setReturnValue(this.dispatcher.isRawChannelDataListenerRegistered(msg.getChannelToken()));
        this.session.write((Object)returnMsg);
        log.debug("end");
    }

    private void processOpenRawChannelReturn() {
        log.debug("begin");
        log.debug("processing MsgOpenRawChannelReturn...");
        MsgOpenRawChannelReturn msg = (MsgOpenRawChannelReturn)this.abstractMessage;
        this.dispatcher.putResultToQueue(this.session, msg.getSequence(), msg);
        log.debug("put result to queue={}", (Object)msg);
        log.debug("end");
    }

    private void processCloseRawChannel() {
        MsgCloseRawChannelReturn returnMsg = new MsgCloseRawChannelReturn();
        try {
            log.debug("begin");
            log.debug("processing MsgCloseRawChannel...");
            MsgCloseRawChannel msg = (MsgCloseRawChannel)this.abstractMessage;
            this.dispatcher.unprepareRawChannel(msg.getChannelToken());
            returnMsg.setSequence(msg.getSequence());
            returnMsg.setReturnValue(true);
        }
        catch (RawChannelException ex) {
            log.warn("Error occured during RawChannelDataListener#close()", (Throwable)ex);
            returnMsg.setErrorMsg(ex.getMessage());
        }
        finally {
            this.session.write((Object)returnMsg);
            log.debug("end");
        }
    }

    private void processCloseRawChannelReturn() {
        log.debug("begin");
        log.debug("processing MsgCloseRawChannelReturn...");
        MsgCloseRawChannelReturn msg = (MsgCloseRawChannelReturn)this.abstractMessage;
        this.dispatcher.putResultToQueue(this.session, msg.getSequence(), msg);
        log.debug("put result to queue={}", (Object)msg);
        log.debug("end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRawChannelData() {
        MsgRawChannelDataReturn returnMsg = new MsgRawChannelDataReturn();
        try {
            log.debug("begin");
            log.debug("processing MsgRawChannelData...");
            MsgRawChannelData msg = (MsgRawChannelData)this.abstractMessage;
            RawChannelDataListener rawChannelDataListener = this.dispatcher.getRawChannelDataListener(msg.getChannelToken());
            if (rawChannelDataListener != null) {
                log.debug("writing data to {} for token {}.", (Object)rawChannelDataListener, (Object)msg.getChannelToken());
                ByteBuffer data = msg.getData();
                data.flip();
                rawChannelDataListener.write(data);
                log.debug("data forwarded to listener for token {}", (Object)msg.getChannelToken());
                returnMsg.setSequence(msg.getSequence());
            } else {
                log.error("trying to forward data to a not registered or already closed listener: token={} data={}", (Object)msg.getChannelToken(), (Object)msg.getData());
            }
        }
        catch (RawChannelException ex) {
            log.warn("Error occured during RawChannelDataListener#write()", (Throwable)ex);
            returnMsg.setErrorMsg(ex.getMessage());
        }
        finally {
            this.session.write((Object)returnMsg);
            log.debug("end");
        }
    }

    private void processNameLookup() {
        log.debug("begin");
        log.debug("processing MsgLookup...");
        MsgNameLookup msg = (MsgNameLookup)this.abstractMessage;
        String remoteObjectName = msg.getRemoteObjectName();
        log.debug("Sending result for remoteObjectName={}", (Object)remoteObjectName);
        MsgNameLookupReturn ret = new MsgNameLookupReturn();
        ret.setSequence(msg.getSequence());
        try {
            String[] interfaceNames;
            Object remoteObject = this.dispatcher.getLookupTable().getRemoteObjectContainer(remoteObjectName).getRemoteObject();
            SimonRemoteMarker marker = Utils.getMarker(remoteObject);
            if (marker != null) {
                RemoteObjectContainer container = this.dispatcher.getLookupTable().getRemoteObjectContainer(remoteObjectName);
                Class<?>[] interfaces = null;
                interfaces = container.getRemoteObjectInterfaces();
                interfaceNames = new String[interfaces.length];
                for (int i = 0; i < interfaceNames.length; ++i) {
                    interfaceNames[i] = interfaces[i].getName();
                }
            } else {
                Class<?>[] interfaces = null;
                interfaces = Utils.findAllRemoteInterfaces(this.dispatcher.getLookupTable().getRemoteObjectContainer(remoteObjectName).getRemoteObject().getClass());
                interfaceNames = new String[interfaces.length];
                for (int i = 0; i < interfaceNames.length; ++i) {
                    interfaceNames[i] = interfaces[i].getName();
                }
            }
            ret.setInterfaces(interfaceNames);
        }
        catch (LookupFailedException e) {
            log.debug("Lookup for remote object '{}' failed: {}", (Object)remoteObjectName, (Object)e.getMessage());
            ret.setErrorMsg("Error: " + e.getClass() + "->" + e.getMessage() + "\n" + Utils.getStackTraceAsString(e));
        }
        this.session.write((Object)ret);
        log.debug("end");
    }

    private void processInterfaceLookup() {
        log.debug("begin");
        log.debug("processing MsgInterfaceLookup...");
        MsgInterfaceLookup msg = (MsgInterfaceLookup)this.abstractMessage;
        String canonicalInterfaceName = msg.getCanonicalInterfaceName();
        log.debug("Sending result for interfaceName={}", (Object)canonicalInterfaceName);
        MsgInterfaceLookupReturn ret = new MsgInterfaceLookupReturn();
        ret.setSequence(msg.getSequence());
        try {
            RemoteObjectContainer container = this.dispatcher.getLookupTable().getRemoteObjectContainerByInterface(canonicalInterfaceName);
            Class<?>[] interfaces = container.getRemoteObjectInterfaces();
            String[] interfaceNames = new String[interfaces.length];
            for (int i = 0; i < interfaceNames.length; ++i) {
                interfaceNames[i] = interfaces[i].getCanonicalName();
            }
            ret.setInterfaces(interfaceNames);
            ret.setRemoteObjectName(container.getRemoteObjectName());
        }
        catch (LookupFailedException e) {
            log.debug("Lookup for remote object '{}' failed: {}", (Object)canonicalInterfaceName, (Object)e.getMessage());
            ret.setErrorMsg("Error: " + e.getClass() + "->" + e.getMessage() + "\n" + Utils.getStackTraceAsString(e));
        }
        this.session.write((Object)ret);
        log.debug("end");
    }

    private void processNameLookupReturn() {
        log.debug("begin");
        log.debug("processing MsgNameLookupReturn...");
        MsgNameLookupReturn msg = (MsgNameLookupReturn)this.abstractMessage;
        log.debug("Forward result to waiting monitor");
        this.dispatcher.putResultToQueue(this.session, msg.getSequence(), msg);
        log.debug("end");
    }

    private void processInterfaceLookupReturn() {
        log.debug("begin");
        log.debug("processing MsgInterfaceLookupReturn...");
        MsgInterfaceLookupReturn msg = (MsgInterfaceLookupReturn)this.abstractMessage;
        log.debug("Forward result to waiting monitor");
        this.dispatcher.putResultToQueue(this.session, msg.getSequence(), msg);
        log.debug("end");
    }

    private void processInvoke() {
        log.debug("begin");
        log.debug("processing MsgInvoke...");
        Object result = null;
        MsgInvoke msg = (MsgInvoke)this.abstractMessage;
        if (msg.hasError()) {
            result = new SimonRemoteException("Received MsgInvoke had errors. Cannot process invocation. error msg: " + msg.getErrorMsg());
            MsgInvokeReturn returnMsg = new MsgInvokeReturn();
            returnMsg.setSequence(msg.getSequence());
            returnMsg.setReturnValue(result);
            log.debug("Sending result={}", (Object)returnMsg);
            this.session.write((Object)returnMsg);
            log.debug("end");
            return;
        }
        Method method = msg.getMethod();
        Object[] arguments = msg.getArguments();
        String remoteObjectName = msg.getRemoteObjectName();
        try {
            if (arguments != null) {
                try {
                    for (int i = 0; i < arguments.length; ++i) {
                        Object object = arguments[i];
                        if (object instanceof SimonEndpointReference) {
                            SimonEndpointReference ser = (SimonEndpointReference)object;
                            log.debug("SimonEndpointReference in args found: {}", (Object)ser);
                            arguments[i] = this.dispatcher.getLookupTable().getRemoteObjectContainer(ser.getRemoteObjectName()).getRemoteObject();
                            log.debug("Original object for SimonEndpointReference injected: " + arguments[i]);
                        }
                        if (!((object = arguments[i]) instanceof SimonRemoteInstance)) continue;
                        SimonRemoteInstance simonCallback = (SimonRemoteInstance)object;
                        log.debug("SimonCallback in args found. id={}", (Object)simonCallback.getId());
                        List<String> interfaceNames = simonCallback.getInterfaceNames();
                        Class[] listenerInterfaces = new Class[interfaceNames.size()];
                        for (int j = 0; j < interfaceNames.size(); ++j) {
                            listenerInterfaces[j] = Class.forName(interfaceNames.get(j), true, this.dispatcher.getClassLoader());
                        }
                        SimonProxy simonProxy = new SimonProxy(this.dispatcher, this.session, simonCallback.getId(), listenerInterfaces, false);
                        arguments[i] = Proxy.newProxyInstance(SimonClassLoaderHelper.getClassLoader(this.getClass()), listenerInterfaces, (InvocationHandler)simonProxy);
                        log.debug("proxy object for SimonCallback injected");
                    }
                }
                catch (ClassNotFoundException ex) {
                    throw new ClassNotFoundException("Callback interface class(es) not found with classloader [" + this.dispatcher.getClassLoader() + "].", ex);
                }
            }
            log.debug("ron={} method={} args={}", new Object[]{remoteObjectName, method, arguments});
            Object remoteObject = this.dispatcher.getLookupTable().getRemoteObjectContainer(remoteObjectName).getRemoteObject();
            try {
                result = method.invoke(remoteObject, arguments);
            }
            catch (IllegalArgumentException ex) {
                log.error("IllegalArgumentException while invoking remote method. Arguments obviously do not match the methods parameter types. Errormsg: " + ex.getMessage());
                log.error("***** Analysis of arguments and paramtypes ... ron={} method={} ", (Object)remoteObjectName, (Object)method.getName());
                if (arguments != null && arguments.length != 0) {
                    for (int i = 0; i < arguments.length; ++i) {
                        log.error("***** arguments[" + i + "]: " + (arguments[i] == null ? "null" : arguments[i].getClass().getCanonicalName()) + " toString: " + (arguments[i] == null ? "null" : arguments[i].toString()));
                    }
                } else {
                    log.error("***** no arguments available.");
                }
                Class<?>[] paramType = method.getParameterTypes();
                if (paramType != null && paramType.length != 0) {
                    for (int i = 0; i < paramType.length; ++i) {
                        log.error("***** paramType[" + i + "]: " + (paramType[i] == null ? "null" : paramType[i].getCanonicalName()));
                    }
                } else {
                    log.error("***** no paramtypes available.");
                }
                for (Method m : remoteObject.getClass().getMethods()) {
                    log.error("***** remoteObject '{}' has method: {}", (Object)remoteObjectName, (Object)m);
                }
                log.error("***** method signature: {}", (Object)method.toString());
                log.error("***** generic method signature: {}", (Object)method.toGenericString());
                log.error("***** Error stacktrace:\n{}", (Object)Utils.getStackTraceAsString(ex));
                log.error("***** Analysis of arguments and paramtypes ... *DONE*");
                throw ex;
            }
            if (Utils.isSimonProxy(result)) {
                SimonProxy sp = Simon.getSimonProxy(result);
                SimonEndpointReference ser = new SimonEndpointReference(sp);
                log.debug("Result of method is SimonProxy/Local Endpoint. Sending: {}", (Object)ser);
                result = ser;
            }
            if (this.dispatcher.getLookupTable().isSimonRemoteRegistered(result)) {
                throw new SimonException("Result '" + result + "' of method '" + method + "' is a registered remote object. Endpoints can not be transferred.");
            }
            if (method.getReturnType() == Void.TYPE) {
                result = new SimonVoid();
            }
            if (Utils.isValidRemote(result)) {
                log.debug("Result of method '{}' is SimonRemote: {}", (Object)method, result);
                SimonRemoteInstance sri = new SimonRemoteInstance(this.session, result);
                this.dispatcher.getLookupTable().putRemoteInstance(this.session.getId(), sri, result);
                result = sri;
            }
        }
        catch (IllegalArgumentException e) {
            result = e;
        }
        catch (InvocationTargetException e) {
            result = e.getTargetException() instanceof UndeclaredThrowableException ? Utils.getRootCause(e.getTargetException()) : e.getTargetException();
        }
        catch (Exception e) {
            SimonRemoteException sre = new SimonRemoteException("Errow while invoking '" + remoteObjectName + "#" + method + "' due to underlying exception: " + e.getClass());
            sre.initCause(e);
            result = sre;
        }
        if (result != null && !(result instanceof Serializable)) {
            log.warn("Result '{}' is not serializable", result);
            result = new SimonRemoteException("Result of method '" + method + "' must be serializable and therefore implement 'java.io.Serializable' or 'host.anzo.simon.SimonRemote'");
        }
        MsgInvokeReturn returnMsg = new MsgInvokeReturn();
        returnMsg.setSequence(msg.getSequence());
        returnMsg.setReturnValue(result);
        log.debug("Sending result={}", (Object)returnMsg);
        this.session.write((Object)returnMsg);
        log.debug("end");
    }

    private void processInvokeReturn() {
        log.debug("begin");
        log.debug("processing MsgInvokeReturn...");
        MsgInvokeReturn msg = (MsgInvokeReturn)this.abstractMessage;
        log.debug("put result to queue={}", (Object)msg);
        this.dispatcher.putResultToQueue(this.session, msg.getSequence(), msg);
        log.debug("end");
    }

    private void processToString() {
        log.debug("begin");
        log.debug("processing MsgToString...");
        MsgToString msg = (MsgToString)this.abstractMessage;
        String remoteObjectName = msg.getRemoteObjectName();
        String returnValue = null;
        try {
            returnValue = this.dispatcher.getLookupTable().getRemoteObjectContainer(remoteObjectName).getRemoteObject().toString();
        }
        catch (LookupFailedException e) {
            e.printStackTrace();
        }
        MsgToStringReturn returnMsg = new MsgToStringReturn();
        returnMsg.setSequence(msg.getSequence());
        returnMsg.setReturnValue(returnValue);
        this.session.write((Object)returnMsg);
        log.debug("end");
    }

    private void processToStringReturn() {
        log.debug("begin");
        log.debug("processing MsgToStringReturn...");
        MsgToStringReturn msg = (MsgToStringReturn)this.abstractMessage;
        this.dispatcher.putResultToQueue(this.session, msg.getSequence(), msg);
        log.debug("put result to queue={}", (Object)msg);
        log.debug("end");
    }

    private void processEquals() {
        log.debug("begin");
        log.debug("processing MsgEquals...");
        MsgEquals msg = (MsgEquals)this.abstractMessage;
        String remoteObjectName = msg.getRemoteObjectName();
        Object objectToCompareWith = msg.getObjectToCompareWith();
        boolean equalsResult = false;
        try {
            if (objectToCompareWith instanceof SimonRemoteInstance) {
                SimonRemoteInstance sri = (SimonRemoteInstance)objectToCompareWith;
                log.debug("Got a SimonRemoteInstance(ron='{}') to compare with, looking for real object...", (Object)sri.getRemoteObjectName());
                objectToCompareWith = this.dispatcher.getLookupTable().getRemoteObjectContainer(sri.getRemoteObjectName()).getRemoteObject();
            }
            Object tthis = this.dispatcher.getLookupTable().getRemoteObjectContainer(remoteObjectName).getRemoteObject();
            equalsResult = objectToCompareWith == null ? false : tthis.equals(objectToCompareWith);
            log.debug("this='{}' objectToCompareWith='{}' equalsResult={}", new Object[]{tthis.toString(), objectToCompareWith == null ? "NULL" : objectToCompareWith.toString(), equalsResult});
        }
        catch (LookupFailedException e) {
            e.printStackTrace();
        }
        MsgEqualsReturn returnMsg = new MsgEqualsReturn();
        returnMsg.setSequence(msg.getSequence());
        returnMsg.setEqualsResult(equalsResult);
        this.session.write((Object)returnMsg);
        log.debug("end");
    }

    private void processEqualsReturn() {
        log.debug("begin");
        log.debug("processing MsgEqualsReturn...");
        MsgEqualsReturn msg = (MsgEqualsReturn)this.abstractMessage;
        this.dispatcher.putResultToQueue(this.session, msg.getSequence(), msg);
        log.debug("put result to queue={}", (Object)msg);
        log.debug("end");
    }

    private void processHashCode() {
        log.debug("begin");
        log.debug("processing MsgHashCode...");
        MsgHashCode msg = (MsgHashCode)this.abstractMessage;
        String remoteObjectName = msg.getRemoteObjectName();
        MsgHashCodeReturn returnMsg = new MsgHashCodeReturn();
        returnMsg.setSequence(msg.getSequence());
        int returnValue = -1;
        try {
            returnValue = this.dispatcher.getLookupTable().getRemoteObjectContainer(remoteObjectName).getRemoteObject().hashCode();
        }
        catch (LookupFailedException e) {
            returnMsg.setErrorMsg("Failed looking up the remote object for getting the hash code. Error: " + e.getMessage() + "\n" + Utils.getStackTraceAsString(e));
        }
        returnMsg.setReturnValue(returnValue);
        this.session.write((Object)returnMsg);
        log.debug("end");
    }

    private void processHashCodeReturn() {
        log.debug("begin");
        log.debug("processing MsgHashCodeReturn...");
        MsgHashCodeReturn msg = (MsgHashCodeReturn)this.abstractMessage;
        this.dispatcher.putResultToQueue(this.session, msg.getSequence(), msg);
        log.debug("put result to queue={}", (Object)msg);
        log.debug("end");
    }

    private void processError() {
        log.debug("begin");
        log.debug("processing MsgError...");
        MsgError msg = (MsgError)this.abstractMessage;
        String remoteObjectName = msg.getRemoteObjectName();
        String errorMessage = msg.getErrorMessage();
        Throwable throwable = msg.getThrowable();
        boolean isDecodeError = msg.isDecodeError();
        Object exceptionMessage = "";
        exceptionMessage = isDecodeError ? (remoteObjectName != null && remoteObjectName.length() > 0 ? "An error occured while reading a message for remote object '" + remoteObjectName + "'. Error message: " + errorMessage : "An error occured while reading a message. Error message: " + errorMessage) : (remoteObjectName != null && remoteObjectName.length() > 0 ? "An error occured on remote while writing a message to remote object '" + remoteObjectName + "'. Error message: " + errorMessage : "An error occured on remote while writing a message. Error message: " + errorMessage);
        SimonException se = new SimonException((String)exceptionMessage);
        se.initCause(throwable);
        CloseFuture closeFuture = this.session.closeNow();
        closeFuture.awaitUninterruptibly();
        log.debug("end");
        throw se;
    }

    private void processReleaseRef() {
        log.debug("begin");
        log.debug("processing MsgReleaseRef...");
        MsgReleaseRef msg = (MsgReleaseRef)this.abstractMessage;
        log.debug("Removing ref for {} on session {}", (Object)msg.getRefId(), (Object)this.session.getId());
        this.dispatcher.getLookupTable().removeCallbackRef(this.session.getId(), msg.getRefId());
        log.debug("end");
    }
}

