/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.AbstractMessageEncoder;
import host.anzo.simon.codec.messages.MsgError;
import host.anzo.simon.utils.Utils;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgErrorEncoder<T extends MsgError>
extends AbstractMessageEncoder<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MsgErrorEncoder.class);

    @Override
    protected void encodeBody(IoSession session, T message, IoBuffer out) {
        Throwable throwable;
        String errorMsg;
        log.trace("begin. message=" + message);
        String remoteObjectName = ((MsgError)message).getRemoteObjectName();
        if (remoteObjectName == null) {
            remoteObjectName = "<NoRemoteObjectNameAvailable>";
        }
        if ((errorMsg = ((MsgError)message).getErrorMessage()) == null) {
            errorMsg = "<NoErrorMsgAvailable>";
        }
        if ((throwable = ((MsgError)message).getThrowable()) == null) {
            throwable = new Throwable("NoThrowableAvailable");
        }
        int initSequenceId = ((MsgError)message).getInitSequenceId();
        boolean isDecodeError = ((MsgError)message).isDecodeError();
        try {
            out.putPrefixedString((CharSequence)remoteObjectName, Charset.forName("UTF-8").newEncoder());
            out.putPrefixedString((CharSequence)errorMsg, Charset.forName("UTF-8").newEncoder());
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        out.putObject((Object)throwable);
        out.putInt(initSequenceId);
        out.put(Utils.booleanToByte(isDecodeError));
        log.trace("end");
    }
}

