/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.RawChannel;
import host.anzo.simon.exceptions.RawChannelException;
import host.anzo.simon.exceptions.SimonRemoteException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class RawChannelOutputStream
extends OutputStream {
    private final RawChannel rawChannel;

    public RawChannelOutputStream(RawChannel rawChannel) {
        this.rawChannel = rawChannel;
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.rawChannel.write(ByteBuffer.wrap(new byte[]{(byte)b}));
        }
        catch (SimonRemoteException ex) {
            throw new IOException(ex);
        }
        catch (RawChannelException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.rawChannel.write(ByteBuffer.wrap(b));
        }
        catch (SimonRemoteException ex) {
            throw new IOException(ex);
        }
        catch (RawChannelException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.rawChannel.write(ByteBuffer.wrap(b, off, len));
        }
        catch (SimonRemoteException ex) {
            throw new IOException(ex);
        }
        catch (RawChannelException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            this.rawChannel.close();
        }
        catch (SimonRemoteException ex) {
            throw new IOException(ex);
        }
        catch (RawChannelException ex) {
            throw new IOException(ex);
        }
    }

    public boolean isClosed() {
        return this.rawChannel.isClosed();
    }
}

