/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.Dispatcher;
import host.anzo.simon.InterfaceLookup;
import host.anzo.simon.Lookup;
import host.anzo.simon.LookupTable;
import host.anzo.simon.NameLookup;
import host.anzo.simon.NamedThreadPoolFactory;
import host.anzo.simon.ProcessMessageThread;
import host.anzo.simon.PublicationSearcher;
import host.anzo.simon.PublishService;
import host.anzo.simon.RawChannel;
import host.anzo.simon.RawChannelDataListener;
import host.anzo.simon.Registry;
import host.anzo.simon.RemoteStatistics;
import host.anzo.simon.SearchProgressListener;
import host.anzo.simon.SimonProxy;
import host.anzo.simon.SimonPublication;
import host.anzo.simon.SimonRemoteMarker;
import host.anzo.simon.SimonRemotePublish;
import host.anzo.simon.SimonRemoteStatistics;
import host.anzo.simon.Statics;
import host.anzo.simon.codec.base.SimonProtocolCodecFactory;
import host.anzo.simon.exceptions.EstablishConnectionFailed;
import host.anzo.simon.exceptions.IllegalRemoteObjectException;
import host.anzo.simon.exceptions.LookupFailedException;
import host.anzo.simon.exceptions.SimonException;
import host.anzo.simon.exceptions.SimonRemoteException;
import host.anzo.simon.io.AcceptAllBufferAllocator;
import host.anzo.simon.ssl.SslContextFactory;
import host.anzo.simon.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.LogManager;
import lombok.Generated;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.buffer.IoBufferAllocator;
import org.apache.mina.core.session.IdleStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Simon {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Simon.class);
    public static final int DEFAULT_PORT = 4753;
    private static final Map<Method, Integer> customInvokeTimeoutMap = new HashMap<Method, Integer>();
    private static int poolSize;
    private static final List<SimonPublication> publishments;
    private static PublishService publishService;
    private static PublicationSearcher publicationSearcher;
    protected static final String SIMON_STD_PROTOCOL_CODEC_FACTORY;
    private static String protocolFactoryClassName;
    private static final List<LookupTable> lookupTableList;

    public static Registry createRegistry(int port) throws UnknownHostException, IOException {
        return Simon.createRegistry(InetAddress.getByName("0.0.0.0"), port);
    }

    public static Registry createRegistry() throws UnknownHostException, IOException {
        return Simon.createRegistry(InetAddress.getByName("0.0.0.0"), 4753);
    }

    public static Registry createRegistry(InetAddress address, int port) throws IOException, IllegalArgumentException {
        log.debug("begin");
        Registry registry = new Registry(address, port, Simon.getThreadPool(), protocolFactoryClassName);
        log.debug("end");
        return registry;
    }

    public static Registry createRegistry(InetAddress address) throws IOException, IllegalArgumentException {
        log.debug("begin");
        Registry registry = new Registry(address, 4753, Simon.getThreadPool(), protocolFactoryClassName);
        log.debug("end");
        return registry;
    }

    public static Registry createRegistry(SslContextFactory sslContextFactory, InetAddress address, int port) throws IOException, IllegalArgumentException {
        log.debug("begin");
        Registry registry = new Registry(address, port, Simon.getThreadPool(), protocolFactoryClassName, sslContextFactory);
        log.debug("end");
        return registry;
    }

    public static Registry createRegistry(SslContextFactory sslContextFactory, InetAddress address) throws IOException, IllegalArgumentException {
        log.debug("begin");
        Registry registry = new Registry(address, 4753, Simon.getThreadPool(), protocolFactoryClassName, sslContextFactory);
        log.debug("end");
        return registry;
    }

    public static Lookup createInterfaceLookup(String host, int port) throws UnknownHostException {
        return new InterfaceLookup(host, port);
    }

    public static InterfaceLookup createInterfaceLookup(InetAddress address, int port) {
        return new InterfaceLookup(address, port);
    }

    public static InterfaceLookup createInterfaceLookup(String host) throws UnknownHostException {
        return new InterfaceLookup(host, 4753);
    }

    public static Lookup createInterfaceLookup(InetAddress address) {
        return new InterfaceLookup(address, 4753);
    }

    public static Lookup createNameLookup(String host, int port) throws UnknownHostException {
        return new NameLookup(host, port);
    }

    public static Lookup createNameLookup(InetAddress address, int port) {
        return new NameLookup(address, port);
    }

    public static Lookup createNameLookup(String host) throws UnknownHostException {
        return new NameLookup(host, 4753);
    }

    public static Lookup createNameLookup(InetAddress address) {
        return new NameLookup(address, 4753);
    }

    public static InetSocketAddress getRemoteInetSocketAddress(Object proxyObject) {
        return (InetSocketAddress)Simon.getSimonProxy(proxyObject).getRemoteSocketAddress();
    }

    public static InetSocketAddress getLocalInetSocketAddress(Object proxyObject) {
        return (InetSocketAddress)Simon.getSimonProxy(proxyObject).getLocalSocketAddress();
    }

    protected static SimonProxy getSimonProxy(Object o) throws IllegalArgumentException {
        if (o instanceof Proxy) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(o);
            log.trace("Got invocation handler ...");
            if (invocationHandler instanceof SimonProxy) {
                log.trace("Yeeha. It's a SimonProxy ...");
                return (SimonProxy)invocationHandler;
            }
            throw new IllegalArgumentException("the proxys invocationhandler is not an instance of SimonProxy. Given object was: " + o);
        }
        throw new IllegalArgumentException("the argument is not a releaseable remote object. Given object was: " + o);
    }

    protected static ExecutorService getThreadPool() {
        if (poolSize == -1) {
            return Executors.newCachedThreadPool(new NamedThreadPoolFactory("Simon.Dispatcher.WorkerPool"));
        }
        if (poolSize == 1) {
            return Executors.newSingleThreadExecutor(new NamedThreadPoolFactory("Simon.Dispatcher.WorkerPool"));
        }
        return Executors.newFixedThreadPool(poolSize, new NamedThreadPoolFactory("Simon.Dispatcher.WorkerPool"));
    }

    public static void setWorkerThreadPoolSize(int size) {
        poolSize = size;
    }

    @Deprecated
    public static void setDgcInterval(int milliseconds) {
        Statics.DEFAULT_IDLE_TIME = milliseconds / 1000;
    }

    @Deprecated
    public static int getDgcInterval() {
        return Statics.DEFAULT_IDLE_TIME * 1000;
    }

    public static void setDefaultConnectTimeout(int millis) {
        log.debug("setting default connect timeout to {} ms.", (Object)millis);
        Statics.DEFAULT_CONNECT_TIMEOUT = millis;
    }

    public static int getDefaultConnectTimeout() {
        return Statics.DEFAULT_CONNECT_TIMEOUT;
    }

    public static void setDefaultKeepAliveInterval(int seconds) {
        log.debug("setting default keep alive interval to {} sec.", (Object)seconds);
        Statics.DEFAULT_IDLE_TIME = seconds;
    }

    public static int getKeepAliveInterval() {
        return Statics.DEFAULT_IDLE_TIME;
    }

    public static void setDefaultKeepAliveTimeout(int seconds) {
        log.debug("setting default keep alive timeout to {} sec.", (Object)seconds);
        Statics.DEFAULT_WRITE_TIMEOUT = seconds;
    }

    public static int getDefaultKeepAliveTimeout() {
        return Statics.DEFAULT_WRITE_TIMEOUT;
    }

    public static void setKeepAliveInterval(Object remoteObject, int seconds) {
        log.debug("setting keep alive interval on {} to {} sec.", remoteObject, (Object)seconds);
        Simon.getSimonProxy(remoteObject).getIoSession().getConfig().setIdleTime(IdleStatus.BOTH_IDLE, seconds);
    }

    public static int getKeepAliveInterval(Object remoteObject) {
        return Simon.getSimonProxy(remoteObject).getIoSession().getConfig().getIdleTime(IdleStatus.BOTH_IDLE);
    }

    public static void setKeepAliveTimeout(Object remoteObject, int seconds) {
        log.debug("setting keep alive timeout on {} to {} sec.", remoteObject, (Object)seconds);
        Simon.getSimonProxy(remoteObject).getIoSession().getConfig().setWriteTimeout(seconds);
    }

    public static int getKeepAliveTimeout(Object remoteObject) throws IllegalArgumentException {
        return Simon.getSimonProxy(remoteObject).getIoSession().getConfig().getWriteTimeout();
    }

    protected static void publish(SimonPublication simonPublication) throws IOException {
        if (publishments.isEmpty()) {
            publishService = new PublishService(publishments);
            publishService.start();
        }
        publishments.add(simonPublication);
    }

    protected static void publishRemote(SimonPublication simonPublication, InetSocketAddress remoteRegistry) throws IOException {
        InterfaceLookup remotePublishLookup = Simon.createInterfaceLookup(remoteRegistry.getAddress(), remoteRegistry.getPort());
        try {
            SimonRemotePublish simonRemotePublish = (SimonRemotePublish)remotePublishLookup.lookup(SimonRemotePublish.class.getCanonicalName());
            simonRemotePublish.publish(simonPublication);
            remotePublishLookup.release(simonRemotePublish);
        }
        catch (LookupFailedException lookupFailedException) {
        }
        catch (EstablishConnectionFailed establishConnectionFailed) {
            // empty catch block
        }
    }

    protected static boolean unpublish(SimonPublication simonPublication) {
        boolean result = publishments.remove(simonPublication);
        if (publishments.isEmpty() && publishService != null && publishService.isAlive()) {
            publishService.shutdown();
        }
        return result;
    }

    public static PublicationSearcher searchRemoteObjects(SearchProgressListener listener, int searchTime) {
        if (publicationSearcher == null || !publicationSearcher.isSearching()) {
            try {
                publicationSearcher = new PublicationSearcher(listener, searchTime);
                publicationSearcher.start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("another search is currently in progress ...");
        }
        return publicationSearcher;
    }

    public static List<SimonPublication> searchRemoteObjects(int searchTime) {
        if (publicationSearcher == null || !publicationSearcher.isSearching()) {
            try {
                publicationSearcher = new PublicationSearcher(null, searchTime);
                publicationSearcher.run();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            return publicationSearcher.getNewPublications();
        }
        throw new IllegalStateException("another search is currently in progress ...");
    }

    public static void setProtocolCodecFactory(String protocolFactoryClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, ClassCastException {
        Utils.getProtocolFactoryInstance(protocolFactoryClassName);
        Simon.protocolFactoryClassName = protocolFactoryClassName;
    }

    public static String getProtocolCodecFactory() {
        return protocolFactoryClassName;
    }

    public static SimonRemoteStatistics getStatistics(Object remoteObject) {
        SimonProxy simonProxy = Simon.getSimonProxy(remoteObject);
        return new RemoteStatistics(simonProxy.getIoSession());
    }

    public static RawChannel openRawChannel(int channelToken, Object simonRemote) throws SimonRemoteException {
        log.debug("begin. token={}", (Object)channelToken);
        SimonProxy simonProxy = Simon.getSimonProxy(simonRemote);
        log.trace("simon proxy detail string for given simonRemote: {}", (Object)simonProxy.getDetailString());
        Dispatcher dispatcher = simonProxy.getDispatcher();
        log.trace("dispatcher for given simonRemote: {}", (Object)dispatcher);
        RawChannel rawChannel = dispatcher.openRawChannel(simonProxy.getIoSession(), channelToken);
        log.debug("raw channel for token {} is {}", (Object)channelToken, (Object)rawChannel);
        log.debug("end.");
        return rawChannel;
    }

    public static int prepareRawChannel(RawChannelDataListener listener, Object simonRemote) throws SimonException {
        log.debug("preparing raw channel for listener {}", (Object)listener);
        Dispatcher dispatcher = Simon.getDispatcher(simonRemote);
        if (dispatcher != null) {
            return dispatcher.prepareRawChannel(listener);
        }
        throw new IllegalArgumentException("Given SimonRemote is not found in any lookuptable: " + simonRemote.getClass());
    }

    protected static synchronized void registerLookupTable(LookupTable lookupTable) {
        lookupTableList.add(lookupTable);
        log.trace("added {} to list of lookuptables. current size: {}", (Object)lookupTable, (Object)lookupTableList.size());
    }

    protected static synchronized void unregisterLookupTable(LookupTable lookupTable) {
        lookupTableList.remove(lookupTable);
        log.trace("removed {} from list of lookuptables. current size: {}", (Object)lookupTable, (Object)lookupTableList.size());
    }

    private static Dispatcher getDispatcher(Object remoteObject) {
        for (LookupTable lookupTable : lookupTableList) {
            log.debug("searching in LookupTable {} for remote object {}", (Object)lookupTable, remoteObject);
            if (!lookupTable.isSimonRemoteRegistered(remoteObject)) continue;
            return lookupTable.getDispatcher();
        }
        return null;
    }

    public static Object markAsRemote(Object o) {
        Class<?>[] interfaces = o.getClass().getInterfaces();
        if (interfaces.length == 0) {
            throw new IllegalRemoteObjectException("There need to be at least one interface to mark the given object as simon remote");
        }
        SimonRemoteMarker srm = new SimonRemoteMarker(o);
        Object newProxyInstance = Proxy.newProxyInstance(Simon.class.getClassLoader(), interfaces, (InvocationHandler)srm);
        return newProxyInstance;
    }

    public static boolean denoteSameRemoteObjekt(Object a, Object b) {
        if (Utils.isSimonProxy(a)) {
            if (Utils.isSimonProxy(b)) {
                SimonProxy proxyA = Simon.getSimonProxy(a);
                SimonProxy proxyB = Simon.getSimonProxy(b);
                if (proxyA.getRemoteObjectName().equals(proxyB.getRemoteObjectName()) && proxyA.getIoSession().equals(proxyB.getIoSession())) {
                    return true;
                }
            } else {
                log.debug("Object 'b' is not a SimonProxy instance");
            }
        } else {
            log.debug("Object 'a' is not a SimonProxy instance");
        }
        return false;
    }

    public static long getSessionId() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ProcessMessageThread) {
            ProcessMessageThread thread = (ProcessMessageThread)currentThread;
            return thread.getSessionId();
        }
        throw new IllegalStateException("Method must be invoked within a remote-call-implementation!");
    }

    public static void setCustomInvokeTimeout(Method method, int timeout) {
        if (timeout > 0) {
            customInvokeTimeoutMap.put(method, timeout);
        } else {
            customInvokeTimeoutMap.remove(method);
        }
    }

    static int getCustomInvokeTimeout(Method method) {
        Integer customTimeout = customInvokeTimeoutMap.get(method);
        if (customTimeout == null || customTimeout <= 0) {
            return 0;
        }
        return customTimeout;
    }

    static {
        IoBuffer.setAllocator((IoBufferAllocator)new AcceptAllBufferAllocator());
        String property = System.getProperty("host.anzo.simon.debug", "false");
        boolean debugEnabled = Boolean.parseBoolean(property);
        if (debugEnabled) {
            System.out.println("ENABLING SIMON DEBUG LOG");
            try {
                File f = new File("host.anzo.simon.debuglogging.properties");
                if (!f.exists()) {
                    System.out.println("SIMON debug logging properties does not exist. Creating default '" + f.getAbsolutePath() + "' ...");
                    FileWriter fw = new FileWriter(f);
                    fw.write("handlers= java.util.logging.FileHandler, java.util.logging.ConsoleHandler\n");
                    fw.write(".level= ALL\n");
                    fw.write("java.util.logging.FileHandler.pattern = host.anzo.simon_debug.log\n");
                    fw.write("java.util.logging.FileHandler.limit = 500000\n");
                    fw.write("java.util.logging.FileHandler.count = 1\n");
                    fw.write("java.util.logging.FileHandler.formatter = host.anzo.simon.utils.ConsoleLogFormatter\n");
                    fw.write("java.util.logging.ConsoleHandler.level = ALL\n");
                    fw.write("java.util.logging.ConsoleHandler.formatter = host.anzo.simon.utils.ConsoleLogFormatter\n");
                    fw.write("host.anzo.simon.level = ALL\n");
                    fw.write("org.apache.mina.filter.logging.LoggingFilter = INFO\n");
                    fw.close();
                } else {
                    System.out.println("Using existing debug logging properties: " + f.getAbsolutePath());
                }
                FileInputStream is = new FileInputStream(f);
                LogManager.getLogManager().readConfiguration(is);
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(Simon.class.getName()).log(Level.SEVERE, null, ex);
            }
            System.out.println("ENABLING SIMON DEBUG LOG *DONE*");
        }
        poolSize = -1;
        publishments = new ArrayList<SimonPublication>();
        protocolFactoryClassName = SIMON_STD_PROTOCOL_CODEC_FACTORY = SimonProtocolCodecFactory.class.getName();
        lookupTableList = new ArrayList<LookupTable>();
    }
}

