/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.AbstractMessageDecoder;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgEquals;
import host.anzo.simon.codec.messages.MsgError;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgEqualsDecoder
extends AbstractMessageDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MsgEqualsDecoder.class);

    public MsgEqualsDecoder() {
        super((byte)6);
    }

    @Override
    protected AbstractMessage decodeBody(IoSession session, IoBuffer in) {
        MsgEquals message = new MsgEquals();
        String remoteObjectName = null;
        try {
            remoteObjectName = in.getPrefixedString(Charset.forName("UTF-8").newDecoder());
            Object objectToCompareWith = in.getObject();
            message.setRemoteObjectName(remoteObjectName);
            message.setObjectToCompareWith(objectToCompareWith);
        }
        catch (CharacterCodingException e) {
            MsgError error = new MsgError();
            error.setErrorMessage("Error while decoding equals() request: Not able to read remote object name due to CharacterCodingException.");
            error.setRemoteObjectName(remoteObjectName);
            error.setThrowable(e);
            return error;
        }
        catch (ClassNotFoundException e) {
            MsgError error = new MsgError();
            error.setErrorMessage("Error while decoding equals() request: Not able to read object due to ClassNotFoundException.");
            error.setRemoteObjectName(remoteObjectName);
            error.setThrowable(e);
            return error;
        }
        log.debug("message={}", (Object)message);
        return message;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }
}

