/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.AbstractMessageDecoder;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgError;
import host.anzo.simon.utils.Utils;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgErrorDecoder
extends AbstractMessageDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MsgErrorDecoder.class);

    public MsgErrorDecoder() {
        super((byte)20);
    }

    @Override
    protected AbstractMessage decodeBody(IoSession session, IoBuffer in) {
        MsgError message = new MsgError();
        String remoteObjectName = null;
        String errorMsg = null;
        Throwable throwable = null;
        int initSequenceId = -1;
        boolean isDecoderError = true;
        try {
            remoteObjectName = in.getPrefixedString(Charset.forName("UTF-8").newDecoder());
            errorMsg = in.getPrefixedString(Charset.forName("UTF-8").newDecoder());
            throwable = (Throwable)in.getObject();
            initSequenceId = in.getInt();
            isDecoderError = Utils.byteToBoolean(in.get());
        }
        catch (CharacterCodingException characterCodingException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        message.setRemoteObjectName(remoteObjectName);
        message.setErrorMessage(errorMsg);
        message.setThrowable(throwable);
        message.setInitSequenceId(initSequenceId);
        if (isDecoderError) {
            message.setDecodeError();
        } else {
            message.setEncodeError();
        }
        log.trace("message={}", (Object)message);
        return message;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }
}

