/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.AbstractMessageDecoder;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgError;
import host.anzo.simon.codec.messages.MsgNameLookupReturn;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgNameLookupReturnDecoder
extends AbstractMessageDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MsgNameLookupReturnDecoder.class);

    public MsgNameLookupReturnDecoder() {
        super((byte)1);
    }

    @Override
    protected AbstractMessage decodeBody(IoSession session, IoBuffer in) {
        log.trace("decoding ...");
        MsgNameLookupReturn m = new MsgNameLookupReturn();
        try {
            int arraySize = in.getInt();
            log.trace("trying to read interfaces value. num of interfaces: {}", (Object)arraySize);
            String[] interfaces = new String[arraySize];
            for (int i = 0; i < arraySize; ++i) {
                String iface = in.getPrefixedString(Charset.forName("UTF-8").newDecoder());
                log.trace("Loading interface: [{}]", (Object)iface);
                interfaces[i] = iface;
                log.trace("got interface=[{}]", (Object)iface);
            }
            m.setErrorMsg(in.getPrefixedString(Charset.forName("UTF-8").newDecoder()));
            m.setInterfaces(interfaces);
        }
        catch (CharacterCodingException e) {
            MsgError error = new MsgError();
            error.setErrorMessage("Error while decoding name lookup return: Not able to read interface names due to CharacterCodingException");
            error.setRemoteObjectName(null);
            error.setThrowable(e);
            return error;
        }
        log.trace("finished");
        return m;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }
}

