/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.AbstractMessageEncoder;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgError;
import host.anzo.simon.codec.messages.MsgToStringReturn;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgToStringReturnEncoder<T extends MsgToStringReturn>
extends AbstractMessageEncoder<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MsgToStringReturnEncoder.class);

    @Override
    protected void encodeBody(IoSession session, T message, IoBuffer out) {
        log.trace("begin. message={}", message);
        try {
            out.putPrefixedString((CharSequence)((MsgToStringReturn)message).getReturnValue(), Charset.forName("UTF-8").newEncoder());
        }
        catch (Exception e) {
            MsgError error = new MsgError();
            error.setEncodeError();
            error.setErrorMessage("Error while encoding toString() request: Not able to write result'" + ((MsgToStringReturn)message).getReturnValue() + "' due to CharacterCodingException.");
            error.setRemoteObjectName(null);
            error.setInitSequenceId(((AbstractMessage)message).getSequence());
            error.setThrowable(e);
            this.sendEncodingError(out, session, error);
        }
        log.trace("end");
    }
}

