/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.filetransmit;

import host.anzo.simon.RawChannel;
import host.anzo.simon.Simon;
import host.anzo.simon.filetransmit.FileReceiver;
import host.anzo.simon.filetransmit.FileSenderProgressListener;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultFileSender.class);
    private int txBLockSize = 8192;
    private AtomicInteger sendId = new AtomicInteger(0);
    private FileReceiver fileReceiver;
    private ExecutorService sendPool;
    public List<FileSenderProgressListener> listeners = Collections.synchronizedList(new ArrayList());

    public void close() {
        this.sendPool.shutdown();
    }

    public boolean closeAndWait(int timeout) throws InterruptedException {
        this.sendPool.shutdown();
        return this.sendPool.awaitTermination(30000L, TimeUnit.MILLISECONDS);
    }

    public DefaultFileSender(FileReceiver fileReceiver) {
        this.fileReceiver = fileReceiver;
        this.sendPool = Executors.newFixedThreadPool(1);
    }

    public DefaultFileSender(FileReceiver fileReceiver, int txThreads) {
        this.fileReceiver = fileReceiver;
        this.sendPool = Executors.newFixedThreadPool(txThreads);
    }

    public void setTxBlockSize(int blockSize) {
        this.txBLockSize = blockSize;
    }

    public int getTxBLockSize() {
        return this.txBLockSize;
    }

    public int sendFile(File f) {
        int id = this.sendId.getAndIncrement();
        if (id == Integer.MAX_VALUE) {
            this.sendId.set(0);
            id = 0;
        }
        for (FileSenderProgressListener listener : this.getListenersCopy()) {
            listener.started(id, f, f.length());
        }
        this.sendPool.execute(new SendTask(f, id, false));
        return id;
    }

    public int sendFile(File f, boolean overwriteExisting) {
        int id = this.sendId.getAndIncrement();
        for (FileSenderProgressListener listener : this.listeners) {
            listener.started(id, f, f.length());
        }
        this.sendPool.execute(new SendTask(f, id, overwriteExisting));
        return id;
    }

    public void addProgressListener(FileSenderProgressListener progressListener) {
        this.listeners.add(progressListener);
    }

    public void removeProgressListener(FileSenderProgressListener progressListener) {
        this.listeners.remove(progressListener);
    }

    private List<FileSenderProgressListener> getListenersCopy() {
        return new ArrayList<FileSenderProgressListener>(this.listeners);
    }

    private class SendTask
    implements Runnable {
        private final File f;
        private int id;
        private final boolean overwriteExisting;

        private SendTask(File f, int id, boolean overwriteExisting) {
            this.f = f;
            this.id = id;
            this.overwriteExisting = overwriteExisting;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long bytesSent = 0L;
            RawChannel rawChannel = null;
            try {
                int token = DefaultFileSender.this.fileReceiver.requestChannelToken(this.f.getName(), this.f.length(), this.overwriteExisting);
                log.debug("FileReceiver provided token {} for file {}", (Object)token, (Object)this.f.getName());
                rawChannel = Simon.openRawChannel(token, DefaultFileSender.this.fileReceiver);
                FileChannel fc = new FileInputStream(this.f).getChannel();
                ByteBuffer data = ByteBuffer.allocate(DefaultFileSender.this.getTxBLockSize());
                while (fc.read(data) != -1) {
                    log.trace("ID={} Sending chunk ...", (Object)this.id);
                    rawChannel.write(data);
                    bytesSent += (long)data.limit();
                    for (FileSenderProgressListener listener : DefaultFileSender.this.getListenersCopy()) {
                        listener.inProgress(this.id, this.f, bytesSent, this.f.length());
                    }
                    data.clear();
                }
                for (FileSenderProgressListener listener : DefaultFileSender.this.getListenersCopy()) {
                    listener.completed(this.id, this.f);
                }
                if (rawChannel != null) {
                    rawChannel.close();
                }
            }
            catch (Exception ex) {
                for (FileSenderProgressListener listener : DefaultFileSender.this.getListenersCopy()) {
                    listener.aborted(this.id, this.f, ex);
                }
            }
            log.debug("ID={} Sending done", (Object)this.id);
        }
    }
}

