/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.ClientToServerConnection;
import host.anzo.simon.ClosedListener;
import host.anzo.simon.Dispatcher;
import host.anzo.simon.Lookup;
import host.anzo.simon.Monitor;
import host.anzo.simon.Simon;
import host.anzo.simon.SimonProxy;
import host.anzo.simon.SimonProxyConfig;
import host.anzo.simon.Statics;
import host.anzo.simon.codec.SimonProxyFilter;
import host.anzo.simon.codec.base.SimonProtocolCodecFactory;
import host.anzo.simon.exceptions.EstablishConnectionFailed;
import host.anzo.simon.ssl.SslContextFactory;
import host.anzo.simon.utils.FilterEntry;
import host.anzo.simon.utils.Utils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLookup
implements Lookup {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractLookup.class);
    static final Map<String, ClientToServerConnection> serverDispatcherRelation = new HashMap<String, ClientToServerConnection>();
    static final Monitor monitorCompleteShutdown = new Monitor();
    protected InetAddress sourceAddress;

    AbstractLookup() {
    }

    @Override
    public void setSourceAddress(InetAddress sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    @Override
    public boolean release(Object remoteObject) {
        boolean result;
        log.debug("begin");
        if (remoteObject == null) {
            throw new IllegalArgumentException("the argument is not a releasable remote object. Given object is null");
        }
        SimonProxy proxy = Simon.getSimonProxy(remoteObject);
        if (!proxy.isRegularLookup()) {
            throw new IllegalArgumentException("Provided proxy is callback object and is not manually releasable. Please release your lookup'ed object(s) instead or wait for GC to release it.");
        }
        log.debug("releasing proxy {}", (Object)proxy.getDetailString());
        Dispatcher dispatcher = proxy.getDispatcher();
        if (dispatcher != null) {
            List<ClosedListener> removeClosedListenerList = dispatcher.removeClosedListenerList(proxy.getRemoteObjectName());
            proxy.release();
            if (removeClosedListenerList != null) {
                for (ClosedListener closedListener : removeClosedListenerList) {
                    closedListener.closed();
                }
                removeClosedListenerList.clear();
            }
            result = AbstractLookup.releaseDispatcher(dispatcher);
        } else {
            result = false;
        }
        log.debug("end");
        return result;
    }

    @Override
    public List<ClosedListener> getClosedListeners(Object remoteObject) {
        SimonProxy simonProxy = Simon.getSimonProxy(remoteObject);
        Dispatcher dispatcher = simonProxy.getDispatcher();
        return new ArrayList<ClosedListener>(dispatcher.getClosedListenerList(simonProxy.getRemoteObjectName()));
    }

    @Override
    public void addClosedListener(Object remoteObject, ClosedListener closedListener) {
        SimonProxy simonProxy = Simon.getSimonProxy(remoteObject);
        Dispatcher dispatcher = simonProxy.getDispatcher();
        dispatcher.addClosedListener(closedListener, simonProxy.getRemoteObjectName());
    }

    @Override
    public boolean removeClosedListener(Object remoteObject, ClosedListener closedListener) {
        SimonProxy simonProxy = Simon.getSimonProxy(remoteObject);
        Dispatcher dispatcher = simonProxy.getDispatcher();
        return dispatcher.removeClosedListener(closedListener, simonProxy.getRemoteObjectName());
    }

    String createServerString(@NotNull InetAddress host, int port) {
        return (String)(this.sourceAddress != null ? this.sourceAddress.getHostAddress() + "@" : "") + host.getHostAddress() + ":" + port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SessionDispatcherContainer buildSessionDispatcherContainer(String remoteObjectName, InetAddress serverAddress, int serverPort, SslContextFactory sslContextFactory, SimonProxyConfig proxyConfig) throws EstablishConnectionFailed {
        Dispatcher dispatcher = null;
        IoSession session = null;
        String serverString = this.createServerString(serverAddress, serverPort);
        log.debug("check if serverstring '{}' is already in the serverDispatcherRelation list", (Object)serverString);
        Map<String, ClientToServerConnection> map = serverDispatcherRelation;
        synchronized (map) {
            if (serverDispatcherRelation.containsKey(serverString)) {
                ClientToServerConnection ctsc = serverDispatcherRelation.remove(serverString);
                ctsc.addRef();
                serverDispatcherRelation.put(serverString, ctsc);
                dispatcher = ctsc.getDispatcher();
                session = ctsc.getSession();
                log.debug("Got ClientToServerConnection from list");
            } else {
                Object connectionTarget;
                log.debug("No ClientToServerConnection in list. Creating new one.");
                dispatcher = new Dispatcher(serverString, this.getClassLoader(), Simon.getThreadPool());
                ExecutorService filterchainWorkerPool = null;
                NioSocketConnector connector = new NioSocketConnector();
                connector.setHandler((IoHandler)dispatcher);
                DefaultIoFilterChainBuilder filterChain = connector.getFilterChain();
                ArrayList<FilterEntry> filters = new ArrayList<FilterEntry>();
                if (sslContextFactory != null) {
                    SSLContext context = sslContextFactory.getSslContext();
                    if (context != null) {
                        SslFilter sslFilter = new SslFilter(context);
                        filters.add(new FilterEntry(sslFilter.getClass().getName(), (IoFilter)sslFilter));
                        log.debug("SSL ON");
                    } else {
                        log.warn("SSLContext retrieved from SslContextFactory was 'null', so starting WITHOUT SSL!");
                    }
                }
                if (log.isTraceEnabled()) {
                    filters.add(new FilterEntry(LoggingFilter.class.getName(), (IoFilter)new LoggingFilter()));
                }
                SimonProtocolCodecFactory protocolFactory = null;
                try {
                    protocolFactory = Utils.getProtocolFactoryInstance(Simon.getProtocolCodecFactory());
                }
                catch (ClassNotFoundException e) {
                    log.error("ClassNotFoundException while preparing ProtocolFactory: {}", (Object)e.getMessage());
                    throw new IllegalArgumentException(e);
                }
                catch (InstantiationException e) {
                    log.error("InstantiationException while preparing ProtocolFactory: {}", (Object)e.getMessage());
                    throw new IllegalArgumentException(e);
                }
                catch (IllegalAccessException e) {
                    log.error("IllegalAccessException while preparing ProtocolFactory: {}", (Object)e.getMessage());
                    throw new IllegalArgumentException(e);
                }
                protocolFactory.setup(false);
                filters.add(new FilterEntry(((Object)((Object)protocolFactory)).getClass().getName(), (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)protocolFactory)));
                if (proxyConfig != null) {
                    connectionTarget = proxyConfig.toString();
                    filterChain.addLast(SimonProxyFilter.class.getName(), (IoFilter)new SimonProxyFilter(serverAddress.getHostName(), serverPort, proxyConfig, filters));
                    log.trace("prepared for proxy connection. chain is now: {}", (Object)filterChain);
                } else {
                    connectionTarget = "Connection[" + serverAddress + ":" + serverPort + "]";
                    for (FilterEntry relation : filters) {
                        filterChain.addLast(relation.name, relation.filter);
                    }
                }
                log.debug("Using: {}", connectionTarget);
                ConnectFuture future = null;
                try {
                    InetSocketAddress remote = proxyConfig == null ? new InetSocketAddress(serverAddress, serverPort) : new InetSocketAddress(proxyConfig.getProxyHost(), proxyConfig.getProxyPort());
                    future = this.sourceAddress != null ? connector.connect((SocketAddress)remote, (SocketAddress)new InetSocketAddress(this.sourceAddress, 0)) : connector.connect((SocketAddress)remote);
                    boolean finished = future.awaitUninterruptibly((long)Statics.DEFAULT_CONNECT_TIMEOUT);
                    if (!finished) {
                        log.debug("Connect timed out after {} ms", (Object)Statics.DEFAULT_CONNECT_TIMEOUT);
                    }
                }
                catch (Exception e) {
                    if (session != null) {
                        log.trace("session != null. closing it...");
                        session.closeNow();
                    }
                    connector.dispose();
                    dispatcher.shutdown();
                    if (filterchainWorkerPool != null) {
                        filterchainWorkerPool.shutdown();
                    }
                    throw new EstablishConnectionFailed("Exception occured while connection/getting session for " + (String)connectionTarget + ".", e);
                }
                if (!future.isConnected()) {
                    connector.dispose();
                    dispatcher.shutdown();
                    if (filterchainWorkerPool != null) {
                        filterchainWorkerPool.shutdown();
                    }
                    throw new EstablishConnectionFailed("Could not establish connection to " + (String)connectionTarget + ". Maybe host or network is down?");
                }
                session = future.getSession();
                log.trace("connected with {}. remoteObjectName={}", connectionTarget, (Object)remoteObjectName);
                session.getConfig().setIdleTime(IdleStatus.BOTH_IDLE, Statics.DEFAULT_IDLE_TIME);
                session.getConfig().setWriteTimeout(Statics.DEFAULT_WRITE_TIMEOUT);
                ClientToServerConnection ctsc = new ClientToServerConnection(serverString, dispatcher, session, (IoConnector)connector, filterchainWorkerPool);
                ctsc.addRef();
                serverDispatcherRelation.put(serverString, ctsc);
                monitorCompleteShutdown.reset();
            }
        }
        return new SessionDispatcherContainer(session, dispatcher);
    }

    public void awaitCompleteShutdown(long timeout) {
        monitorCompleteShutdown.waitForSignal(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean releaseDispatcher(Dispatcher dispatcher) {
        boolean result = false;
        Map<String, ClientToServerConnection> map = serverDispatcherRelation;
        synchronized (map) {
            String serverString = dispatcher.getServerString();
            if (serverDispatcherRelation.containsKey(serverString)) {
                final ClientToServerConnection ctsc = serverDispatcherRelation.remove(serverString);
                int refCount = ctsc.delRef();
                log.trace("removed serverString '{}' from serverDispatcherRelation. new refcount is {}", (Object)serverString, (Object)refCount);
                if (refCount == 0) {
                    log.debug("refCount reached 0. shutting down session and all related stuff.");
                    ctsc.getDispatcher().shutdown();
                    ctsc.getDispatcher().setReleased();
                    CloseFuture closeFuture = ctsc.getSession().closeOnFlush();
                    closeFuture.addListener((IoFutureListener)new IoFutureListener<IoFuture>(){

                        public void operationComplete(IoFuture future) {
                            if (ctsc.getFilterchainWorkerPool() != null) {
                                ctsc.getFilterchainWorkerPool().shutdown();
                            }
                            ctsc.getConnector().dispose();
                            if (serverDispatcherRelation.isEmpty()) {
                                log.debug("serverDispatcherRelation map is empty. Signalling complete network connection shutdown now.");
                                monitorCompleteShutdown.signal();
                            }
                        }
                    });
                    result = true;
                } else {
                    log.debug("refCount={}. put back the ClientToServerConnection.", (Object)refCount);
                    serverDispatcherRelation.put(serverString, ctsc);
                }
            } else {
                log.debug("no ServerDispatcherRelation found for {}. Maybe remote object is already released?", (Object)serverString);
            }
        }
        return result;
    }

    record SessionDispatcherContainer(IoSession session, Dispatcher dispatcher) {
    }
}

