/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.AbstractLookup;
import host.anzo.simon.ClosedListener;
import host.anzo.simon.LookupTable;
import host.anzo.simon.PingWatchdog;
import host.anzo.simon.ProcessMessageRunnable;
import host.anzo.simon.RawChannel;
import host.anzo.simon.RawChannelDataListener;
import host.anzo.simon.SequenceMonitor;
import host.anzo.simon.Simon;
import host.anzo.simon.SimonEndpointReference;
import host.anzo.simon.SimonPhantomRef;
import host.anzo.simon.SimonProxy;
import host.anzo.simon.SimonRefQueue;
import host.anzo.simon.SimonRemoteInstance;
import host.anzo.simon.SimonSessionListener;
import host.anzo.simon.Statics;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgCloseRawChannel;
import host.anzo.simon.codec.messages.MsgCloseRawChannelReturn;
import host.anzo.simon.codec.messages.MsgEquals;
import host.anzo.simon.codec.messages.MsgEqualsReturn;
import host.anzo.simon.codec.messages.MsgHashCode;
import host.anzo.simon.codec.messages.MsgHashCodeReturn;
import host.anzo.simon.codec.messages.MsgInterfaceLookup;
import host.anzo.simon.codec.messages.MsgInterfaceLookupReturn;
import host.anzo.simon.codec.messages.MsgInvoke;
import host.anzo.simon.codec.messages.MsgInvokeReturn;
import host.anzo.simon.codec.messages.MsgNameLookup;
import host.anzo.simon.codec.messages.MsgNameLookupReturn;
import host.anzo.simon.codec.messages.MsgOpenRawChannel;
import host.anzo.simon.codec.messages.MsgOpenRawChannelReturn;
import host.anzo.simon.codec.messages.MsgPing;
import host.anzo.simon.codec.messages.MsgPong;
import host.anzo.simon.codec.messages.MsgRawChannelData;
import host.anzo.simon.codec.messages.MsgRawChannelDataReturn;
import host.anzo.simon.codec.messages.MsgReleaseRef;
import host.anzo.simon.codec.messages.MsgToString;
import host.anzo.simon.codec.messages.MsgToStringReturn;
import host.anzo.simon.exceptions.InvokeTimeoutException;
import host.anzo.simon.exceptions.LookupFailedException;
import host.anzo.simon.exceptions.RawChannelException;
import host.anzo.simon.exceptions.SessionException;
import host.anzo.simon.exceptions.SimonException;
import host.anzo.simon.exceptions.SimonRemoteException;
import host.anzo.simon.utils.Utils;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.FilterEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dispatcher
implements IoHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Dispatcher.class);
    private final LookupTable lookupTable;
    private final AtomicInteger sequenceIdCounter = new AtomicInteger(0);
    private final Map<Integer, Object> requestMonitorAndResultMap = Collections.synchronizedMap(new HashMap());
    private final Map<IoSession, List<Integer>> sessionHasRequestPlaced = Collections.synchronizedMap(new HashMap());
    private ExecutorService messageProcessorPool = null;
    private boolean shutdownInProgress;
    private boolean isRunning;
    private final String serverString;
    private final HashMap<Integer, RawChannelDataListener> rawChannelMap = new HashMap();
    private final ArrayList<Integer> tokenList = new ArrayList();
    private final PingWatchdog pingWatchdog;
    private int pingTimeOut = Statics.DEFAULT_WRITE_TIMEOUT;
    private final Map<String, List<ClosedListener>> remoteObjectClosedListenersList = Collections.synchronizedMap(new HashMap());
    private final ClassLoader classLoader;
    private boolean released = false;
    private final SimonRefQueue<SimonPhantomRef<?>> simonRefQueue;
    private final AtomicReference<SimonSessionListener> sessionListenerRef = new AtomicReference<Object>(null);

    public void setSessionListener(SimonSessionListener listener) {
        this.sessionListenerRef.set(listener);
        log.debug("SimonSessionListener {} registered for Dispatcher {}", (Object)listener, (Object)this);
    }

    protected int getPingTimeout() {
        return this.pingTimeOut;
    }

    protected void setPingTimeOut(int pingTimeOut) {
        this.pingTimeOut = pingTimeOut;
    }

    protected List<ClosedListener> removeClosedListenerList(String remoteObjectName) {
        return this.remoteObjectClosedListenersList.remove(remoteObjectName);
    }

    protected void addClosedListener(ClosedListener listener, String remoteObjectName) {
        if (!this.remoteObjectClosedListenersList.containsKey(remoteObjectName)) {
            List<ClosedListener> closedListeners = Collections.synchronizedList(new ArrayList());
            closedListeners.add(listener);
            this.remoteObjectClosedListenersList.put(remoteObjectName, closedListeners);
        } else {
            this.remoteObjectClosedListenersList.get(remoteObjectName).add(listener);
        }
    }

    protected boolean removeClosedListener(ClosedListener listener, String remoteObjectName) {
        if (this.remoteObjectClosedListenersList.containsKey(remoteObjectName)) {
            boolean result = this.remoteObjectClosedListenersList.get(remoteObjectName).remove(listener);
            if (this.remoteObjectClosedListenersList.get(remoteObjectName).isEmpty()) {
                this.remoteObjectClosedListenersList.remove(remoteObjectName);
            }
            return result;
        }
        return false;
    }

    public Dispatcher(String serverString, ClassLoader classLoader, ExecutorService threadPool) {
        log.debug("begin");
        this.isRunning = true;
        this.simonRefQueue = new SimonRefQueue(this);
        this.serverString = serverString;
        this.lookupTable = new LookupTable(this);
        this.messageProcessorPool = threadPool;
        this.pingWatchdog = new PingWatchdog(this);
        this.classLoader = classLoader;
        log.debug("end");
    }

    protected MsgNameLookupReturn invokeNameLookup(IoSession session, String remoteObjectName) throws LookupFailedException, SimonRemoteException {
        this.checkForInvalidState(session, "Simon.lookup({...}, " + remoteObjectName + ")");
        int sequenceId = this.generateSequenceId();
        log.debug("begin sequenceId={} session={}", (Object)sequenceId, (Object)session);
        SequenceMonitor monitor = this.createMonitor(session, sequenceId);
        MsgNameLookup msgNameLookup = new MsgNameLookup();
        msgNameLookup.setSequence(sequenceId);
        msgNameLookup.setRemoteObjectName(remoteObjectName);
        session.write((Object)msgNameLookup);
        log.debug("data send. waiting for answer for sequenceId={}", (Object)sequenceId);
        this.waitForResult(session, monitor);
        MsgNameLookupReturn result = (MsgNameLookupReturn)this.getRequestResult(sequenceId);
        log.debug("got answer for sequenceId={}", (Object)sequenceId);
        log.trace("end sequenceId={}", (Object)sequenceId);
        return result;
    }

    protected MsgInterfaceLookupReturn invokeInterfaceLookup(IoSession session, String canonicalInterfaceName) throws LookupFailedException, SimonRemoteException {
        this.checkForInvalidState(session, "Simon.lookup({...}, " + canonicalInterfaceName + ")");
        int sequenceId = this.generateSequenceId();
        log.debug("begin sequenceId={} session={}", (Object)sequenceId, (Object)session);
        SequenceMonitor monitor = this.createMonitor(session, sequenceId);
        MsgInterfaceLookup msgInterfaceLookup = new MsgInterfaceLookup();
        msgInterfaceLookup.setSequence(sequenceId);
        msgInterfaceLookup.setCanonicalInterfaceName(canonicalInterfaceName);
        session.write((Object)msgInterfaceLookup);
        log.debug("data send. waiting for answer for sequenceId={}", (Object)sequenceId);
        this.waitForResult(session, monitor);
        MsgInterfaceLookupReturn result = (MsgInterfaceLookupReturn)this.getRequestResult(sequenceId);
        log.debug("got answer for sequenceId={}", (Object)sequenceId);
        log.trace("end sequenceId={}", (Object)sequenceId);
        return result;
    }

    protected Object invokeMethod(IoSession session, String remoteObjectName, Method method, Object[] args) throws SimonRemoteException {
        this.checkForInvalidState(session, method.toString());
        int sequenceId = this.generateSequenceId();
        log.debug("begin sequenceId={} session={}", (Object)sequenceId, (Object)session);
        SequenceMonitor monitor = this.createMonitor(session, sequenceId);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (Utils.isSimonProxy(args[i])) {
                    SimonProxy sp = Simon.getSimonProxy(args[i]);
                    SimonEndpointReference ser = new SimonEndpointReference(sp);
                    log.debug("Argument {} is a SimonProxy/Local Endpoint. Sending: {}", (Object)i, (Object)ser);
                    args[i] = ser;
                }
                if (!Utils.isValidRemote(args[i])) continue;
                SimonRemoteInstance sri = new SimonRemoteInstance(session, args[i]);
                log.debug("SimonRemoteInstance found! id={}", (Object)sri.getId());
                this.lookupTable.putRemoteInstance(session.getId(), sri, args[i]);
                args[i] = sri;
            }
        }
        MsgInvoke msgInvoke = new MsgInvoke();
        msgInvoke.setSequence(sequenceId);
        msgInvoke.setRemoteObjectName(remoteObjectName);
        msgInvoke.setMethod(method);
        msgInvoke.setArguments(args);
        session.write((Object)msgInvoke);
        log.debug("data send. waiting for answer for sequenceId={}", (Object)sequenceId);
        int customWaitTimeout = Simon.getCustomInvokeTimeout(method);
        if (customWaitTimeout > 0) {
            this.waitForResult(session, monitor, customWaitTimeout);
        } else {
            this.waitForResult(session, monitor);
        }
        MsgInvokeReturn result = (MsgInvokeReturn)this.getRequestResult(sequenceId);
        log.debug("end sequenceId={}", (Object)sequenceId);
        return result.getReturnValue();
    }

    protected String invokeToString(IoSession session, String remoteObjectName) throws SimonRemoteException {
        this.checkForInvalidState(session, "toString()");
        int sequenceId = this.generateSequenceId();
        log.debug("begin sequenceId={} session={}", (Object)sequenceId, (Object)session);
        SequenceMonitor monitor = this.createMonitor(session, sequenceId);
        MsgToString msgInvoke = new MsgToString();
        msgInvoke.setSequence(sequenceId);
        msgInvoke.setRemoteObjectName(remoteObjectName);
        session.write((Object)msgInvoke);
        log.debug("data send. waiting for answer for sequenceId={}", (Object)sequenceId);
        this.waitForResult(session, monitor);
        MsgToStringReturn result = (MsgToStringReturn)this.getRequestResult(sequenceId);
        if (result.hasError()) {
            throw new SimonRemoteException(result.getErrorMsg());
        }
        log.debug("got answer for sequenceId={}", (Object)sequenceId);
        log.debug("end sequenceId={}", (Object)sequenceId);
        return result.getReturnValue();
    }

    protected int invokeHashCode(IoSession session, String remoteObjectName) throws SimonRemoteException {
        this.checkForInvalidState(session, "hashCode()");
        int sequenceId = this.generateSequenceId();
        log.debug("begin sequenceId={} session={}", (Object)sequenceId, (Object)session);
        SequenceMonitor monitor = this.createMonitor(session, sequenceId);
        MsgHashCode msgInvoke = new MsgHashCode();
        msgInvoke.setSequence(sequenceId);
        msgInvoke.setRemoteObjectName(remoteObjectName);
        session.write((Object)msgInvoke);
        log.debug("data send. waiting for answer for sequenceId={}", (Object)sequenceId);
        this.waitForResult(session, monitor);
        MsgHashCodeReturn result = (MsgHashCodeReturn)this.getRequestResult(sequenceId);
        if (result.hasError()) {
            throw new SimonRemoteException(result.getErrorMsg());
        }
        log.debug("got answer for sequenceId={}", (Object)sequenceId);
        log.debug("end sequenceId={}", (Object)sequenceId);
        return result.getReturnValue();
    }

    protected boolean invokeEquals(IoSession session, String remoteObjectName, Object objectToCompareWith) throws SimonRemoteException {
        this.checkForInvalidState(session, "equals()");
        int sequenceId = this.generateSequenceId();
        log.debug("begin sequenceId={} session={}", (Object)sequenceId, (Object)session);
        SequenceMonitor monitor = this.createMonitor(session, sequenceId);
        MsgEquals msgEquals = new MsgEquals();
        msgEquals.setSequence(sequenceId);
        msgEquals.setRemoteObjectName(remoteObjectName);
        msgEquals.setObjectToCompareWith(objectToCompareWith);
        session.write((Object)msgEquals);
        log.debug("data send. waiting for answer for sequenceId={}", (Object)sequenceId);
        this.waitForResult(session, monitor);
        MsgEqualsReturn result = (MsgEqualsReturn)this.getRequestResult(sequenceId);
        if (result.hasError()) {
            throw new SimonRemoteException(result.getErrorMsg());
        }
        log.debug("got answer for sequenceId={}", (Object)sequenceId);
        log.debug("end sequenceId={}", (Object)sequenceId);
        return result.getEqualsResult();
    }

    private void waitForResult(IoSession session, SequenceMonitor monitor) {
        this.waitForResult(session, monitor, 3600000);
    }

    private void waitForResult(IoSession session, SequenceMonitor monitor, int timeout) {
        int sequenceId = monitor.getSequenceId();
        int counter = 0;
        long startWaiting = System.currentTimeMillis();
        long waitLoopCount = (long)timeout / 200L;
        while (!this.isRequestResultPresent(sequenceId)) {
            if ((long)counter++ == waitLoopCount) {
                this.putResultToQueue(session, sequenceId, new InvokeTimeoutException("Waited too long for invocation result."));
            }
            if (monitor.waitForSignal(200L)) {
                return;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("still waiting for result for sequenceId={}. Waiting since {}ms.", (Object)sequenceId, (Object)(System.currentTimeMillis() - startWaiting));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putResultToQueue(IoSession session, int sequenceId, Object o) {
        log.debug("begin");
        log.debug("sequenceId={} msg={}", (Object)sequenceId, o);
        boolean isResultForOutstandingRequest = false;
        Map<IoSession, List<Integer>> map = this.sessionHasRequestPlaced;
        synchronized (map) {
            assert (this.sessionHasRequestPlaced.containsKey(session));
            List<Integer> requestListForSession = this.sessionHasRequestPlaced.get(session);
            if (requestListForSession != null) {
                List<Integer> list = requestListForSession;
                synchronized (list) {
                    if (requestListForSession.contains(sequenceId)) {
                        requestListForSession.remove((Object)sequenceId);
                        if (requestListForSession.isEmpty()) {
                            this.sessionHasRequestPlaced.remove(session);
                        }
                        isResultForOutstandingRequest = true;
                    } else {
                        log.debug("Session {} and sequenceId {} do currently not wait for a result.", (Object)Utils.longToHexString(session.getId()), (Object)sequenceId);
                    }
                }
            } else {
                log.warn("Session {} has no outstanding requests. Result no longer awaited?", (Object)Utils.longToHexString(session.getId()));
            }
        }
        if (isResultForOutstandingRequest) {
            SequenceMonitor monitor = (SequenceMonitor)this.requestMonitorAndResultMap.get(sequenceId);
            this.requestMonitorAndResultMap.put(sequenceId, o);
            monitor.signal();
        } else {
            log.warn("Result '{}' for session {} and sequenceId {} dropped.", new Object[]{o, Utils.longToHexString(session.getId()), sequenceId});
        }
        log.debug("end");
    }

    protected LookupTable getLookupTable() {
        return this.lookupTable;
    }

    public void shutdown() {
        log.debug("begin");
        this.simonRefQueue.cleanup();
        this.shutdownInProgress = true;
        this.messageProcessorPool.shutdown();
        while (!this.messageProcessorPool.isShutdown()) {
            log.debug("waiting for messageProcessorPool to shutdown...");
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.lookupTable.cleanup();
        this.isRunning = false;
        log.debug("shutdown completed");
        log.debug("end");
    }

    public String getServerString() {
        return this.serverString;
    }

    protected boolean isServerDispatcher() {
        return this.serverString == null;
    }

    protected boolean isRunning() {
        return this.isRunning;
    }

    private void checkForInvalidState(IoSession session, String method) throws SessionException {
        if (this.shutdownInProgress && this.isRunning) {
            throw new SessionException("Cannot handle method call \"" + method + "\" while shutdown.");
        }
        if (!this.isRunning) {
            throw new SessionException("Cannot handle method call \"" + method + "\" on already closed Dispatcher for Session " + Utils.longToHexString(session.getId()) + ".");
        }
        if (session.isClosing()) {
            throw new SessionException("Cannot handle method call \"" + method + "\" on already closed Session(" + Utils.longToHexString(session.getId()) + ").");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SequenceMonitor createMonitor(IoSession session, int sequenceId) {
        log.debug("begin");
        SequenceMonitor monitor = new SequenceMonitor(sequenceId);
        Map<IoSession, List<Integer>> map = this.sessionHasRequestPlaced;
        synchronized (map) {
            if (!this.sessionHasRequestPlaced.containsKey(session)) {
                ArrayList<Integer> requestListForSession = new ArrayList<Integer>();
                requestListForSession.add(sequenceId);
                this.sessionHasRequestPlaced.put(session, requestListForSession);
            } else {
                this.sessionHasRequestPlaced.get(session).add(sequenceId);
            }
        }
        this.requestMonitorAndResultMap.put(sequenceId, monitor);
        log.debug("created monitor for sequenceId={}", (Object)sequenceId);
        log.debug("end");
        return monitor;
    }

    private Object getRequestResult(int sequenceId) throws SimonRemoteException {
        log.debug("getting result for sequenceId={}", (Object)sequenceId);
        Object o = this.requestMonitorAndResultMap.remove(sequenceId);
        if (o instanceof SimonRemoteException) {
            log.debug("result is an exception, throwing it ...");
            throw (SimonRemoteException)o;
        }
        return o;
    }

    private boolean isRequestResultPresent(int sequenceId) {
        boolean present = false;
        log.trace("result={}", this.requestMonitorAndResultMap.get(sequenceId));
        if (!(this.requestMonitorAndResultMap.get(sequenceId) instanceof SequenceMonitor)) {
            present = true;
        }
        log.debug("Result for sequenceId={} present: {}", (Object)sequenceId, (Object)present);
        return present;
    }

    private synchronized Integer generateSequenceId() {
        return this.sequenceIdCounter.incrementAndGet() == Integer.MAX_VALUE ? this.sequenceIdCounter.getAndSet(0) : this.sequenceIdCounter.intValue();
    }

    private void interruptWaitingRequests(IoSession session) {
        List<Integer> remove = this.sessionHasRequestPlaced.get(session);
        if (remove != null) {
            ArrayList<Integer> removeCopy = new ArrayList<Integer>(remove);
            for (Integer sequenceId : removeCopy) {
                this.putResultToQueue(session, sequenceId, new SimonRemoteException("session was closed. sessionId=" + Utils.longToHexString(session.getId()) + " sequenceId=" + sequenceId));
            }
        }
    }

    public void exceptionCaught(IoSession session, Throwable throwable) throws Exception {
        log.error("exception Caught. thread={} session={}. Exception:\n {}", new Object[]{Thread.currentThread().getName(), Utils.longToHexString(session.getId()), Utils.getStackTraceAsString(throwable)});
        log.debug("Closing the session now! session={}", (Object)Utils.longToHexString(session.getId()));
        session.closeNow();
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        log.debug("Received message from session {}", (Object)Utils.longToHexString(session.getId()));
        AbstractMessage abstractMessage = (AbstractMessage)message;
        this.messageProcessorPool.execute(new ProcessMessageRunnable(this, session, abstractMessage));
    }

    public void messageSent(IoSession session, Object msg) throws Exception {
        log.debug("Message sent to session session={} msg='{}'", (Object)Utils.longToHexString(session.getId()), msg);
    }

    public void sessionClosed(IoSession session) throws Exception {
        String id = Utils.longToHexString(session.getId());
        log.debug("{} ################################################", (Object)id);
        log.debug("{} ######## session closed", (Object)id);
        SimonSessionListener listener = this.sessionListenerRef.get();
        if (listener != null) {
            try {
                log.debug("Notifying SimonSessionListener about session closure: {}", (Object)session.getId());
                listener.simonSessionClosed(session, this);
            }
            catch (Exception e) {
                log.error("Error in SimonSessionListener during sessionClosed for session {}", (Object)id, (Object)e);
            }
        } else {
            log.trace("No SimonSessionListener registered for session closed event: {}", (Object)id);
        }
        this.lookupTable.unreference(session.getId());
        this.interruptWaitingRequests(session);
        log.debug("{} ######## Removing session attributes ...", (Object)id);
        log.debug("{} ########  -> {}", (Object)id, (Object)Statics.SESSION_ATTRIBUTE_DISPATCHER);
        session.removeAttribute((Object)Statics.SESSION_ATTRIBUTE_DISPATCHER);
        log.debug("{} ########  -> {}", (Object)id, (Object)Statics.SESSION_ATTRIBUTE_LOOKUPTABLE);
        session.removeAttribute((Object)Statics.SESSION_ATTRIBUTE_LOOKUPTABLE);
        log.debug("{} ######## notify closed listeners", (Object)id);
        for (String ron : this.remoteObjectClosedListenersList.keySet()) {
            List<ClosedListener> list = this.remoteObjectClosedListenersList.remove(ron);
            for (ClosedListener closedListener : list) {
                closedListener.closed();
            }
            list.clear();
        }
        if (!this.isReleased()) {
            log.debug("{} ######## Releasing dispatcher {}", (Object)id, (Object)this);
            AbstractLookup.releaseDispatcher(this);
        } else {
            log.debug("{} ######## Dispatcher {} already released. Nothing to do.", (Object)id, (Object)this);
        }
        log.debug("{} ######## Session close *DONE*", (Object)id);
        log.debug("{} ################################################", (Object)id);
    }

    boolean isReleased() {
        return this.released;
    }

    void setReleased() {
        this.released = true;
    }

    public void sessionCreated(IoSession session) throws Exception {
        log.debug("session created. session={}", (Object)session);
        session.setAttribute((Object)Statics.SESSION_ATTRIBUTE_LOOKUPTABLE, (Object)this.lookupTable);
        session.setAttribute((Object)Statics.SESSION_ATTRIBUTE_DISPATCHER, (Object)this);
        SimonSessionListener listener = this.sessionListenerRef.get();
        if (listener != null) {
            listener.simonSessionCreated(session, this);
        }
    }

    public void sessionIdle(IoSession session, IdleStatus idleStatus) throws Exception {
        log.debug("session idle. session={} idleStatus={}", (Object)Utils.longToHexString(session.getId()), (Object)idleStatus);
        if (!(session.isClosing() || idleStatus != IdleStatus.READER_IDLE && idleStatus != IdleStatus.BOTH_IDLE)) {
            log.trace("sending ping to test session {}", (Object)Utils.longToHexString(session.getId()));
            this.sendPing(session);
        }
    }

    private void sendPing(IoSession session) throws SessionException {
        this.checkForInvalidState(session, "sendPing()");
        this.pingWatchdog.waitForPong(session);
        int sequenceId = this.generateSequenceId();
        log.debug("begin sequenceId={} session={}", (Object)sequenceId, (Object)session);
        MsgPing msgPing = new MsgPing();
        msgPing.setSequence(sequenceId);
        session.write((Object)msgPing);
        log.debug("end. data send.");
    }

    public void sendPong(IoSession session) throws SessionException {
        this.checkForInvalidState(session, "sendPong()");
        int sequenceId = this.generateSequenceId();
        log.debug("begin sequenceId={} session={}", (Object)sequenceId, (Object)session);
        MsgPong msgPong = new MsgPong();
        msgPong.setSequence(sequenceId);
        session.write((Object)msgPong);
        log.debug("end. data send.");
    }

    public void sessionOpened(IoSession session) throws Exception {
        log.debug("session opened. session={}", (Object)session);
        SimonSessionListener listener = this.sessionListenerRef.get();
        if (listener != null) {
            listener.simonSessionOpened(session, this);
        }
    }

    protected RawChannel openRawChannel(IoSession session, int channelToken) throws SimonRemoteException {
        this.checkForInvalidState(session, "openRawChannel()");
        int sequenceId = this.generateSequenceId();
        log.debug("begin sequenceId={} session={} token={}", new Object[]{sequenceId, session, channelToken});
        SequenceMonitor monitor = this.createMonitor(session, sequenceId);
        MsgOpenRawChannel msgOpenRawChannel = new MsgOpenRawChannel();
        msgOpenRawChannel.setSequence(sequenceId);
        msgOpenRawChannel.setChannelToken(channelToken);
        session.write((Object)msgOpenRawChannel);
        log.debug("data send. waiting for answer for sequenceId={}", (Object)sequenceId);
        this.waitForResult(session, monitor);
        MsgOpenRawChannelReturn result = (MsgOpenRawChannelReturn)this.getRequestResult(sequenceId);
        log.debug("got answer for sequenceId={}", (Object)sequenceId);
        log.debug("end sequenceId={}", (Object)sequenceId);
        if (result.hasError()) {
            throw new SimonRemoteException(result.getErrorMsg());
        }
        if (result.getReturnValue()) {
            log.debug("Creating RawChannel object with token={}", (Object)channelToken);
            return new RawChannel(this, session, channelToken);
        }
        throw new SimonRemoteException("channel could not be opened. Maybe token was wrong?!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int prepareRawChannel(RawChannelDataListener listener) throws SimonException {
        int channelToken = this.getRawChannelToken();
        HashMap<Integer, RawChannelDataListener> hashMap = this.rawChannelMap;
        synchronized (hashMap) {
            this.rawChannelMap.put(channelToken, listener);
        }
        log.trace("rawChannelMap={}", this.rawChannelMap);
        return channelToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRawChannelDataListenerRegistered(int channelToken) {
        log.trace("searching in map for token={} map={}", (Object)channelToken, this.rawChannelMap);
        HashMap<Integer, RawChannelDataListener> hashMap = this.rawChannelMap;
        synchronized (hashMap) {
            return this.rawChannelMap.containsKey(channelToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RawChannelDataListener getRawChannelDataListener(int channelToken) {
        log.trace("getting listener token={} map={}", (Object)channelToken, this.rawChannelMap);
        HashMap<Integer, RawChannelDataListener> hashMap = this.rawChannelMap;
        synchronized (hashMap) {
            return this.rawChannelMap.get(channelToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRawChannelToken() throws SimonException {
        ArrayList<Integer> arrayList = this.tokenList;
        synchronized (arrayList) {
            for (int i = Integer.MIN_VALUE; i < Integer.MAX_VALUE; ++i) {
                if (this.tokenList.contains(i)) continue;
                this.tokenList.add(i);
                return i;
            }
        }
        throw new SimonException("no more token available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseToken(int channelToken) {
        ArrayList<Integer> arrayList = this.tokenList;
        synchronized (arrayList) {
            this.tokenList.remove((Object)channelToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unprepareRawChannel(int channelToken) throws RawChannelException {
        log.debug("token={}", (Object)channelToken);
        this.releaseToken(channelToken);
        HashMap<Integer, RawChannelDataListener> hashMap = this.rawChannelMap;
        synchronized (hashMap) {
            RawChannelDataListener rawChannelDataListener = this.rawChannelMap.remove(channelToken);
            rawChannelDataListener.close();
        }
    }

    protected void writeRawData(IoSession session, int channelToken, ByteBuffer byteBuffer) throws SimonRemoteException, RawChannelException {
        this.checkForInvalidState(session, "writeRawData()");
        int sequenceId = this.generateSequenceId();
        log.debug("begin sequenceId={} session={}", (Object)sequenceId, (Object)session);
        SequenceMonitor monitor = this.createMonitor(session, sequenceId);
        MsgRawChannelData msgRawChannelData = new MsgRawChannelData();
        msgRawChannelData.setSequence(sequenceId);
        msgRawChannelData.setChannelToken(channelToken);
        msgRawChannelData.setData(byteBuffer);
        session.write((Object)msgRawChannelData);
        log.debug("data send. waiting for answer for sequenceId={}", (Object)sequenceId);
        this.waitForResult(session, monitor);
        MsgRawChannelDataReturn requestResult = (MsgRawChannelDataReturn)this.getRequestResult(sequenceId);
        if (requestResult.hasError()) {
            throw new RawChannelException(requestResult.getErrorMsg());
        }
        log.debug("end. got ack for data send for sequenceId={} and channelToken={}", (Object)sequenceId, (Object)channelToken);
    }

    protected void closeRawChannel(IoSession session, int channelToken) throws SimonRemoteException, RawChannelException {
        this.checkForInvalidState(session, "closeRawChannel()");
        int sequenceId = this.generateSequenceId();
        log.debug("begin sequenceId={} session={} token={}", new Object[]{sequenceId, session, channelToken});
        SequenceMonitor monitor = this.createMonitor(session, sequenceId);
        MsgCloseRawChannel msgCloseRawChannel = new MsgCloseRawChannel();
        msgCloseRawChannel.setSequence(sequenceId);
        msgCloseRawChannel.setChannelToken(channelToken);
        session.write((Object)msgCloseRawChannel);
        log.debug("data send. waiting for answer for sequenceId={}", (Object)sequenceId);
        this.waitForResult(session, monitor);
        MsgCloseRawChannelReturn result = (MsgCloseRawChannelReturn)this.getRequestResult(sequenceId);
        log.debug("got answer for sequenceId={}", (Object)sequenceId);
        log.debug("end sequenceId={}", (Object)sequenceId);
        if (result.hasError()) {
            throw new RawChannelException(result.getErrorMsg());
        }
        if (result.getReturnValue()) {
            return;
        }
        throw new SimonRemoteException("channel could not be closed. Maybe token was wrong?!");
    }

    protected PingWatchdog getPingWatchdog() {
        return this.pingWatchdog;
    }

    protected List<ClosedListener> getClosedListenerList(String remoteObjectName) {
        return this.remoteObjectClosedListenersList.get(remoteObjectName);
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    void sendReleaseRef(IoSession session, String refId) throws SessionException {
        this.checkForInvalidState(session, "sendReleaseRef()");
        log.debug("#######################");
        log.debug("########### ReleaseRef for {}", (Object)refId);
        log.debug("#######################");
        log.debug("begin session={} refId={}", (Object)session, (Object)refId);
        MsgReleaseRef msgReleaseRef = new MsgReleaseRef();
        msgReleaseRef.setRefId(refId);
        msgReleaseRef.setSequence(this.generateSequenceId());
        session.write((Object)msgReleaseRef);
        log.debug("end. data send.");
    }

    SimonRefQueue<SimonPhantomRef<?>> getRefQueue() {
        return this.simonRefQueue;
    }

    public void inputClosed(IoSession is) throws Exception {
        is.closeNow();
    }

    public void event(IoSession session, FilterEvent event) throws Exception {
    }
}

