/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.AbstractLookup;
import host.anzo.simon.Dispatcher;
import host.anzo.simon.Simon;
import host.anzo.simon.SimonProxy;
import host.anzo.simon.SimonProxyConfig;
import host.anzo.simon.codec.messages.MsgNameLookupReturn;
import host.anzo.simon.exceptions.EstablishConnectionFailed;
import host.anzo.simon.exceptions.LookupFailedException;
import host.anzo.simon.ssl.SslContextFactory;
import host.anzo.simon.utils.SimonClassLoaderHelper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import lombok.Generated;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameLookup
extends AbstractLookup {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NameLookup.class);
    private final InetAddress serverAddress;
    private final int serverPort;
    private SslContextFactory sslContextFactory;
    private SimonProxyConfig proxyConfig;
    private ClassLoader classLoader;

    protected NameLookup(String host, int port) throws UnknownHostException {
        this(InetAddress.getByName(host), port);
    }

    protected NameLookup(InetAddress serverAddress, int serverPort) {
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
    }

    @Override
    public Object lookup(String remoteObjectName) throws LookupFailedException, EstablishConnectionFailed {
        Class<?>[] listenerInterfaces;
        IoSession session;
        log.debug("begin");
        if (remoteObjectName == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        if (remoteObjectName.isEmpty()) {
            throw new IllegalArgumentException("Argument is not a valid remote object name");
        }
        AbstractLookup.SessionDispatcherContainer sessionDispatcherContainer = this.buildSessionDispatcherContainer(remoteObjectName, this.serverAddress, this.serverPort, this.sslContextFactory, this.proxyConfig);
        Dispatcher dispatcher = sessionDispatcherContainer.dispatcher();
        MsgNameLookupReturn msg = dispatcher.invokeNameLookup(session = sessionDispatcherContainer.session(), remoteObjectName);
        if (msg.hasError()) {
            log.trace("Lookup failed. Releasing dispatcher.");
            NameLookup.releaseDispatcher(dispatcher);
            throw new LookupFailedException(msg.getErrorMsg());
        }
        try {
            listenerInterfaces = this.classLoader == null ? msg.getInterfaces() : msg.getInterfaces(this.classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new LookupFailedException("Not able to load remote interfaces. Maybe you need to specify a specific classloader via Lookup#setClassLoader()?", ex);
        }
        for (Class<?> class1 : listenerInterfaces) {
            log.debug("iface: {}", (Object)class1.getName());
        }
        SimonProxy handler = new SimonProxy(dispatcher, session, remoteObjectName, listenerInterfaces, true);
        log.trace("proxy created");
        Object proxy = Proxy.newProxyInstance(SimonClassLoaderHelper.getClassLoader(Simon.class, this.classLoader), listenerInterfaces, (InvocationHandler)handler);
        log.debug("end");
        return proxy;
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    @Override
    public void setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    @Override
    public SimonProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    @Override
    public void setProxyConfig(SimonProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public InetAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }
}

