/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.AbstractLookup;
import host.anzo.simon.Dispatcher;
import host.anzo.simon.Simon;
import host.anzo.simon.SimonEndpointReference;
import host.anzo.simon.SimonRemoteInstance;
import host.anzo.simon.SimonVoid;
import host.anzo.simon.exceptions.SimonRemoteException;
import host.anzo.simon.utils.SimonClassLoaderHelper;
import host.anzo.simon.utils.Utils;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimonProxy
implements InvocationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimonProxy.class);
    private String remoteObjectName;
    private Dispatcher dispatcher;
    private final IoSession session;
    Class<?>[] remoteInterfaces;
    private final boolean regularLookup;

    protected SimonProxy(Dispatcher dispatcher, IoSession session, String remoteObjectName, Class<?>[] remoteInterfaces, boolean regularLookup) {
        this.dispatcher = dispatcher;
        this.session = session;
        this.remoteObjectName = remoteObjectName;
        this.remoteInterfaces = remoteInterfaces;
        this.regularLookup = regularLookup;
        if (remoteObjectName.startsWith("SimonRemoteInstance")) {
            dispatcher.getRefQueue().addRef(this);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        log.debug("begin");
        if (this.dispatcher == null) {
            log.debug("Hey, you cannot use an already closed connection ... s&h\u00a7/&*$$");
            log.debug("end");
            throw new SimonRemoteException("Cannot invoke method " + method.getName() + ". Connection to server is already closed.");
        }
        if (log.isTraceEnabled()) {
            log.trace("method={} argsLength={}", (Object)method.getName(), (Object)(args == null ? 0 : args.length));
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    log.trace("args[{}]={}", (Object)i, args[i] instanceof Proxy ? Simon.getSimonProxy(args[i]).getDetailString() : args[i]);
                }
            } else {
                log.trace("args=null");
            }
        }
        try {
            if (method.toString().equalsIgnoreCase("public boolean java.lang.Object.equals(java.lang.Object)")) {
                Object o = args[0];
                log.debug("Checking for SimonProxy as argument ...");
                if (Utils.isSimonProxy(o)) {
                    log.debug("It's a SimonProxy instance");
                    o = new SimonRemoteInstance(this.session, args[0]);
                    log.debug("Given argument is a SimonProxy, created SimonRemoteInstance: {}", (Object)((SimonRemoteInstance)o));
                } else {
                    log.debug("It's a standard object");
                    if (o != null && !(o instanceof Serializable)) {
                        throw new IllegalArgumentException("SIMON remote objects can only compared with objects that are serializable!");
                    }
                }
                return this.remoteEquals(o);
            }
            if (method.toString().equalsIgnoreCase("public native int java.lang.Object.hashCode()")) {
                try {
                    return this.remoteHashCode();
                }
                catch (SimonRemoteException e) {
                    this.shutdownServerConnection(method);
                    throw new SimonRemoteException(e.getMessage());
                }
            }
            if (method.toString().equalsIgnoreCase("public java.lang.String java.lang.Object.toString()")) {
                return this.remoteToString();
            }
        }
        catch (IOException e) {
            throw new SimonRemoteException("Could not process invocation of method '" + method.getName() + "'. Underlying exception: " + e);
        }
        Object result = this.dispatcher.invokeMethod(this.session, this.remoteObjectName, method, args);
        if (result instanceof Throwable) {
            log.debug("return value: {}", result);
            if (result instanceof SimonRemoteException) {
                this.shutdownServerConnection(method);
            } else {
                log.debug("Forwarding exception to application: {}", (Object)((Throwable)result).getMessage());
            }
            throw (Throwable)result;
        }
        if (result instanceof SimonEndpointReference) {
            SimonEndpointReference ser = (SimonEndpointReference)result;
            result = this.dispatcher.getLookupTable().getRemoteObjectContainer(ser.getRemoteObjectName()).getRemoteObject();
            log.debug("Result of method {} is a {}. Injecting original object: {}", new Object[]{method, ser, result});
        } else if (result instanceof SimonRemoteInstance) {
            SimonRemoteInstance simonCallback = (SimonRemoteInstance)result;
            List<String> interfaceNames = simonCallback.getInterfaceNames();
            Class[] listenerInterfaces = new Class[interfaceNames.size()];
            for (int j = 0; j < interfaceNames.size(); ++j) {
                listenerInterfaces[j] = Class.forName(interfaceNames.get(j), true, this.dispatcher.getClassLoader());
            }
            SimonProxy handler = new SimonProxy(this.dispatcher, this.session, simonCallback.getId(), new Class[0], false);
            result = Proxy.newProxyInstance(SimonClassLoaderHelper.getClassLoader(this.getClass()), listenerInterfaces, (InvocationHandler)handler);
        }
        log.debug("end");
        if (result instanceof SimonVoid) {
            return null;
        }
        return result;
    }

    private void shutdownServerConnection(Method method) {
        log.error("Problematic error while invoking '{}#{}'. Shutting down server connection.", (Object)this.remoteObjectName, (Object)method);
        AbstractLookup.releaseDispatcher(this.dispatcher);
        this.dispatcher = null;
    }

    protected SocketAddress getRemoteSocketAddress() {
        return this.session.getRemoteAddress();
    }

    protected SocketAddress getLocalSocketAddress() {
        return this.session.getLocalAddress();
    }

    private String remoteToString() throws SimonRemoteException {
        return "[Proxy=" + this.remoteObjectName + "|invocationHandler=" + super.toString() + "|remote=" + this.dispatcher.invokeToString(this.session, this.remoteObjectName) + "|interfaces=" + Arrays.toString(this.remoteInterfaces) + "|sessionId=" + Utils.longToHexString(this.session.getId()) + "]";
    }

    private int remoteHashCode() throws SimonRemoteException {
        return this.dispatcher.invokeHashCode(this.session, this.remoteObjectName);
    }

    private boolean remoteEquals(Object object) throws IOException {
        return this.dispatcher.invokeEquals(this.session, this.remoteObjectName, object);
    }

    protected Dispatcher release() {
        log.debug("setting remoteobjectname to null and return dispatcher");
        this.remoteObjectName = null;
        return this.dispatcher;
    }

    public String toString() {
        try {
            return this.remoteToString();
        }
        catch (SimonRemoteException e) {
            return "Error occured while invoking " + this.remoteObjectName + "#toString(). Error was: " + e.getMessage();
        }
    }

    protected String getDetailString() {
        log.debug("Getting detail string ...");
        String detail = "[Proxy=" + this.remoteObjectName + "|invocationHandler=" + super.toString() + "|sessionId=" + Utils.longToHexString(this.session.getId()) + "]";
        log.debug("Detail string is: {}", (Object)detail);
        return detail;
    }

    protected String getRemoteObjectName() {
        return this.remoteObjectName;
    }

    protected IoSession getIoSession() {
        return this.session;
    }

    public long getSessionId() {
        return this.session.getId();
    }

    protected Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    protected boolean isRegularLookup() {
        return this.regularLookup;
    }
}

