/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.AbstractMessageEncoder;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgError;
import host.anzo.simon.codec.messages.MsgHashCodeReturn;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgHashCodeReturnEncoder<T extends MsgHashCodeReturn>
extends AbstractMessageEncoder<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MsgHashCodeReturnEncoder.class);

    @Override
    protected void encodeBody(IoSession session, T message, IoBuffer out) {
        log.trace("begin. message={}", message);
        try {
            out.putInt(((MsgHashCodeReturn)message).getReturnValue());
            out.putPrefixedString((CharSequence)((AbstractMessage)message).getErrorMsg(), Charset.forName("UTF-8").newEncoder());
        }
        catch (CharacterCodingException e) {
            MsgError error = new MsgError();
            error.setEncodeError();
            error.setErrorMessage("Error while encoding hashCode() return: Not able to write errorMsg '" + ((AbstractMessage)message).getErrorMsg() + "' due to CharacterCodingException.");
            error.setRemoteObjectName(null);
            error.setInitSequenceId(((AbstractMessage)message).getSequence());
            error.setThrowable(e);
            this.sendEncodingError(out, session, error);
        }
        log.trace("end");
    }
}

