/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.Dispatcher;
import host.anzo.simon.RegistryStatistics;
import host.anzo.simon.Simon;
import host.anzo.simon.SimonPublication;
import host.anzo.simon.SimonRegistryStatistics;
import host.anzo.simon.SimonSessionListener;
import host.anzo.simon.Statics;
import host.anzo.simon.codec.base.SimonProtocolCodecFactory;
import host.anzo.simon.exceptions.LookupFailedException;
import host.anzo.simon.exceptions.NameBindingException;
import host.anzo.simon.ssl.SslContextFactory;
import host.anzo.simon.utils.Utils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Registry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Registry.class);
    private InetAddress address;
    private int port;
    private Dispatcher dispatcher;
    private IoAcceptor acceptor;
    private ExecutorService threadPool;
    private ExecutorService filterchainWorkerPool;
    private String protocolFactoryClassName;
    private SslContextFactory sslContextFactory;
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private boolean started;
    private boolean stopped;

    protected Registry(InetAddress address, int port, ExecutorService threadPool, String protocolFactoryClassName) throws IOException {
        this(address, port, threadPool, protocolFactoryClassName, null);
    }

    protected Registry(InetAddress address, int port, ExecutorService threadPool, String protocolFactoryClassName, SslContextFactory sslContextFactory) throws IOException {
        log.debug("begin");
        this.address = address;
        this.port = port;
        this.threadPool = threadPool;
        this.protocolFactoryClassName = protocolFactoryClassName;
        this.sslContextFactory = sslContextFactory;
        log.debug("end");
    }

    public void start(SimonSessionListener sessionListener) throws IOException {
        if (this.stopped) {
            throw new IllegalStateException("Stopped registry cannot start again.");
        }
        if (this.started) {
            throw new IllegalStateException("Registry already started.");
        }
        try {
            block18: {
                this.started = true;
                log.debug("begin");
                this.dispatcher = new Dispatcher(null, this.classLoader, this.threadPool);
                log.debug("dispatcher created");
                this.dispatcher.setSessionListener(sessionListener);
                this.acceptor = new NioSocketAcceptor();
                if (this.acceptor instanceof NioSocketAcceptor) {
                    NioSocketAcceptor nioSocketAcceptor = (NioSocketAcceptor)this.acceptor;
                    log.debug("setting 'TcpNoDelay' on NioSocketAcceptor");
                    nioSocketAcceptor.getSessionConfig().setTcpNoDelay(true);
                    log.debug("setting 'ReuseAddress' on NioSocketAcceptor");
                    nioSocketAcceptor.setReuseAddress(true);
                    try {
                        ServerSocketChannel channel = ServerSocketChannel.open();
                        channel.configureBlocking(false);
                        ServerSocket socket = channel.socket();
                        int receiveBufferSize = socket.getReceiveBufferSize();
                        try {
                            socket.close();
                            channel.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        log.debug("setting 'ReceiveBufferSize' on NioSocketAcceptor to {}", (Object)receiveBufferSize);
                        nioSocketAcceptor.getSessionConfig().setReceiveBufferSize(receiveBufferSize);
                    }
                    catch (IOException ex) {
                        log.debug("Not able to get readbuffersize from a default NIO socket. Error: {}", (Object)ex.getMessage());
                        if (nioSocketAcceptor.getSessionConfig().getReadBufferSize() != 1024 || !System.getProperty("os.name").equals("Windows 7")) break block18;
                        log.warn("Server may have a drastic performance loss. Please consult 'http://dev.root1.de/issues/show/77' for more details.");
                    }
                }
            }
            if (this.sslContextFactory != null) {
                SSLContext context = this.sslContextFactory.getSslContext();
                if (context != null) {
                    SslFilter sslFilter = new SslFilter(context);
                    this.acceptor.getFilterChain().addLast("sslFilter", (IoFilter)sslFilter);
                    log.debug("SSL ON");
                } else {
                    log.warn("SSLContext retrieved from SslContextFactory was 'null', so starting WITHOUT SSL!");
                }
            }
            if (log.isTraceEnabled()) {
                this.acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
            }
            SimonProtocolCodecFactory protocolFactory = null;
            try {
                protocolFactory = Utils.getProtocolFactoryInstance(this.protocolFactoryClassName);
            }
            catch (ClassNotFoundException e) {
                log.error("ClassNotFoundException while preparing ProtocolFactory", (Throwable)e);
                throw new IllegalArgumentException(e);
            }
            catch (InstantiationException e) {
                log.error("InstantiationException while preparing ProtocolFactory", (Throwable)e);
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                log.error("IllegalAccessException while preparing ProtocolFactory", (Throwable)e);
                throw new IllegalArgumentException(e);
            }
            protocolFactory.setup(true);
            this.acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)protocolFactory));
            this.acceptor.setHandler((IoHandler)this.dispatcher);
            log.trace("Configuring acceptor with default values: write_timeout={}sec dgc_interval={}sec", (Object)Statics.DEFAULT_WRITE_TIMEOUT, (Object)Statics.DEFAULT_IDLE_TIME);
            this.setKeepAliveInterval(Statics.DEFAULT_IDLE_TIME);
            this.setKeepAliveTimeout(Statics.DEFAULT_WRITE_TIMEOUT);
            log.trace("Listening on {} on port {}", (Object)this.address, (Object)this.port);
            this.acceptor.bind((SocketAddress)new InetSocketAddress(this.address, this.port));
            log.debug("acceptor thread created and started");
            log.debug("end");
        }
        catch (RuntimeException e) {
            this.started = false;
            throw e;
        }
        catch (IOException e) {
            this.started = false;
            throw e;
        }
    }

    public void setKeepAliveTimeout(int seconds) {
        this.acceptor.getSessionConfig().setWriteTimeout(seconds);
        this.dispatcher.setPingTimeOut(seconds);
        log.debug("setting KeepAlive timeout to {} sec.", (Object)seconds);
    }

    public void setKeepAliveInterval(int seconds) {
        this.acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, seconds);
        log.debug("setting KeepAlive interval to {} sec.", (Object)seconds);
    }

    public int getKeepAliveTimeout() {
        return this.acceptor.getSessionConfig().getWriteTimeout();
    }

    public int getKeepAliveInterval() {
        return this.acceptor.getSessionConfig().getIdleTime(IdleStatus.BOTH_IDLE);
    }

    public void stop() {
        this.stopped = true;
        log.trace("begin");
        log.trace("Unbind Acceptor ...");
        this.acceptor.unbind();
        log.trace("Shutdown Dispatcher ...");
        this.dispatcher.shutdown();
        log.trace("Dispose Acceptor ...");
        this.acceptor.dispose();
        if (this.filterchainWorkerPool != null) {
            log.trace("Shutdown FilterchainWorkerPool ...");
            this.filterchainWorkerPool.shutdown();
        }
        log.trace("end");
    }

    public void bind(String name, Object remoteObject) throws NameBindingException {
        if (!this.started) {
            throw new IllegalStateException("Registry not yet started.");
        }
        if (this.stopped) {
            throw new IllegalStateException("Registry already stopped.");
        }
        if (!Utils.isValidRemote(remoteObject)) {
            throw new IllegalArgumentException("Provided remote object is not marked with SimonRemote or Remote annotation!");
        }
        try {
            if (this.dispatcher.getLookupTable().getRemoteObjectContainer(name) != null) {
                throw new NameBindingException("a remote object with the name '" + name + "' is already bound to this registry. unbind() first, or alternatively rebind().");
            }
        }
        catch (LookupFailedException lookupFailedException) {
            // empty catch block
        }
        this.dispatcher.getLookupTable().putRemoteBinding(name, remoteObject);
    }

    public void bindAndPublish(String name, Object remoteObject) throws NameBindingException {
        this.bind(name, remoteObject);
        try {
            Simon.publish(new SimonPublication(this.address, this.port, name));
        }
        catch (IOException e) {
            this.unbind(name);
            throw new NameBindingException("can't publish '" + name + "'. object is not bind! error=" + e.getMessage());
        }
    }

    public void bindAndPublishRemote(String name, Object remoteObject, InetSocketAddress remoteRegistry) throws NameBindingException {
        this.bind(name, remoteObject);
        try {
            Simon.publishRemote(new SimonPublication(this.address, this.port, name), remoteRegistry);
        }
        catch (IOException e) {
            this.unbind(name);
            throw new NameBindingException("can't publish '" + name + "'. object is not bind! error=" + e.getMessage());
        }
    }

    public boolean unbind(String name) {
        this.dispatcher.getLookupTable().releaseRemoteBinding(name);
        return Simon.unpublish(new SimonPublication(this.address, this.port, name));
    }

    public boolean unpublish(String name) {
        return Simon.unpublish(new SimonPublication(this.address, this.port, name));
    }

    public void rebind(String name, Object remoteObject) {
        this.unbind(name);
        try {
            this.bind(name, remoteObject);
        }
        catch (NameBindingException e) {
            log.warn("rebind() should never throw an NameBindingException. Contact SIMON author and send him this log.");
        }
    }

    public boolean isRunning() {
        return this.dispatcher != null && this.acceptor != null && (this.dispatcher.isRunning() || this.acceptor.isActive() || this.filterchainWorkerPool != null && !this.filterchainWorkerPool.isTerminated());
    }

    public SimonRegistryStatistics getStatistics() {
        return new RegistryStatistics(this.acceptor.getStatistics());
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

