/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.AbstractMessageDecoder;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgError;
import host.anzo.simon.codec.messages.MsgToString;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgToStringDecoder
extends AbstractMessageDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MsgToStringDecoder.class);

    public MsgToStringDecoder() {
        super((byte)4);
    }

    @Override
    protected AbstractMessage decodeBody(IoSession session, IoBuffer in) {
        MsgToString message = new MsgToString();
        try {
            String remoteObjectName = in.getPrefixedString(Charset.forName("UTF-8").newDecoder());
            message.setRemoteObjectName(remoteObjectName);
        }
        catch (CharacterCodingException e) {
            MsgError error = new MsgError();
            error.setErrorMessage("Error while decoding toString() request: Not able to read remoteObjectName due to CharacterCodingException");
            error.setRemoteObjectName(null);
            error.setThrowable(e);
            return error;
        }
        log.trace("message={}", (Object)message);
        return message;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }
}

