/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.ssl;

import host.anzo.simon.ssl.SslContextFactory;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSslContextFactory
implements SslContextFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSslContextFactory.class);
    private static final String _KEYSTORE_TYPE_ = KeyStore.getDefaultType();
    private SSLContext sslContext;

    public DefaultSslContextFactory(String pathToKeystore, String keystorePass) throws NoSuchAlgorithmException, FileNotFoundException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        if (pathToKeystore == null) {
            throw new IllegalArgumentException("path to keystore cannot be null");
        }
        if (keystorePass == null) {
            throw new IllegalArgumentException("keystorePass cannot be null. Maybe \"\", but not null.");
        }
        this.sslContext = null;
        this.sslContext = SSLContext.getInstance("TLS");
        log.debug("loading key store");
        KeyStore keyStore = DefaultSslContextFactory.getKeyStore(pathToKeystore, keystorePass);
        log.debug("keystore loaded");
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keystorePass.toCharArray());
        log.debug("keymanager factory initialized");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        log.debug("trust manager factory factory initialized");
        this.sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        log.debug("ssl context initialized");
    }

    public DefaultSslContextFactory(InputStream keystoreStream, String keystorePass) throws NoSuchAlgorithmException, FileNotFoundException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        if (keystoreStream == null) {
            throw new IllegalArgumentException("keystoreStream cannot be null");
        }
        if (keystorePass == null) {
            throw new IllegalArgumentException("keystorePass cannot be null. Maybe \"\", but not null.");
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(keystoreStream, keystorePass.toCharArray());
        trustManagerFactory.init(keystore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        this.sslContext = SSLContext.getInstance("TLS");
        log.debug("trust manager factory factory initialized");
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keystore, keystorePass.toCharArray());
        log.debug("keymanager factory initialized");
        this.sslContext.init(kmf.getKeyManagers(), trustManagers, null);
        log.debug("ssl context initialized");
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    private static KeyStore getKeyStore(String aPath, String aPassword) throws FileNotFoundException, KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore store;
        try (FileInputStream fin = new FileInputStream(aPath);){
            store = KeyStore.getInstance(_KEYSTORE_TYPE_);
            store.load(fin, aPassword != null ? aPassword.toCharArray() : null);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("the keystorefile specified by the path '" + aPath + "' was not found.");
        }
        catch (EOFException e) {
            throw new KeyStoreException("An error occured while loading the keystore file. Error was: " + e);
        }
        return store;
    }
}

