/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.client;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.groupadministration.SetChatPhoto;
import org.telegram.telegrambots.meta.api.methods.send.SendAnimation;
import org.telegram.telegrambots.meta.api.methods.send.SendAudio;
import org.telegram.telegrambots.meta.api.methods.send.SendDocument;
import org.telegram.telegrambots.meta.api.methods.send.SendMediaGroup;
import org.telegram.telegrambots.meta.api.methods.send.SendPaidMedia;
import org.telegram.telegrambots.meta.api.methods.send.SendPhoto;
import org.telegram.telegrambots.meta.api.methods.send.SendSticker;
import org.telegram.telegrambots.meta.api.methods.send.SendVideo;
import org.telegram.telegrambots.meta.api.methods.send.SendVideoNote;
import org.telegram.telegrambots.meta.api.methods.send.SendVoice;
import org.telegram.telegrambots.meta.api.methods.stickers.AddStickerToSet;
import org.telegram.telegrambots.meta.api.methods.stickers.CreateNewStickerSet;
import org.telegram.telegrambots.meta.api.methods.stickers.ReplaceStickerInSet;
import org.telegram.telegrambots.meta.api.methods.stickers.SetStickerSetThumbnail;
import org.telegram.telegrambots.meta.api.methods.stickers.UploadStickerFile;
import org.telegram.telegrambots.meta.api.methods.updates.SetWebhook;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.EditMessageMedia;
import org.telegram.telegrambots.meta.api.objects.message.Message;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.TelegramClient;

public abstract class AbstractTelegramClient
implements TelegramClient {
    @Override
    public <T extends Serializable, Method extends BotApiMethod<T>> T execute(Method method) throws TelegramApiException {
        try {
            return (T)((Serializable)this.executeAsync(method).get());
        }
        catch (Exception e) {
            throw this.mapException(e, method.getMethod());
        }
    }

    @Override
    public Message execute(SendDocument sendDocument) throws TelegramApiException {
        try {
            return this.executeAsync(sendDocument).get();
        }
        catch (Exception e) {
            throw this.mapException(e, sendDocument.getMethod());
        }
    }

    @Override
    public Message execute(SendPhoto sendPhoto) throws TelegramApiException {
        try {
            return this.executeAsync(sendPhoto).get();
        }
        catch (Exception e) {
            throw this.mapException(e, sendPhoto.getMethod());
        }
    }

    @Override
    public Boolean execute(SetWebhook setWebhook) throws TelegramApiException {
        try {
            return this.executeAsync(setWebhook).get();
        }
        catch (Exception e) {
            throw this.mapException(e, setWebhook.getMethod());
        }
    }

    @Override
    public Message execute(SendVideo sendVideo) throws TelegramApiException {
        try {
            return this.executeAsync(sendVideo).get();
        }
        catch (Exception e) {
            throw this.mapException(e, sendVideo.getMethod());
        }
    }

    @Override
    public Message execute(SendVideoNote sendVideoNote) throws TelegramApiException {
        try {
            return this.executeAsync(sendVideoNote).get();
        }
        catch (Exception e) {
            throw this.mapException(e, sendVideoNote.getMethod());
        }
    }

    @Override
    public Message execute(SendSticker sendSticker) throws TelegramApiException {
        try {
            return this.executeAsync(sendSticker).get();
        }
        catch (Exception e) {
            throw this.mapException(e, sendSticker.getMethod());
        }
    }

    @Override
    public Message execute(SendAudio sendAudio) throws TelegramApiException {
        try {
            return this.executeAsync(sendAudio).get();
        }
        catch (Exception e) {
            throw this.mapException(e, sendAudio.getMethod());
        }
    }

    @Override
    public Message execute(SendVoice sendVoice) throws TelegramApiException {
        try {
            return this.executeAsync(sendVoice).get();
        }
        catch (Exception e) {
            throw this.mapException(e, sendVoice.getMethod());
        }
    }

    @Override
    public List<Message> execute(SendMediaGroup sendMediaGroup) throws TelegramApiException {
        try {
            return this.executeAsync(sendMediaGroup).get();
        }
        catch (Exception e) {
            throw this.mapException(e, sendMediaGroup.getMethod());
        }
    }

    @Override
    public List<Message> execute(SendPaidMedia sendPaidMedia) throws TelegramApiException {
        try {
            return this.executeAsync(sendPaidMedia).get();
        }
        catch (Exception e) {
            throw this.mapException(e, sendPaidMedia.getMethod());
        }
    }

    @Override
    public Boolean execute(SetChatPhoto setChatPhoto) throws TelegramApiException {
        try {
            return this.executeAsync(setChatPhoto).get();
        }
        catch (Exception e) {
            throw this.mapException(e, setChatPhoto.getMethod());
        }
    }

    @Override
    public Boolean execute(AddStickerToSet addStickerToSet) throws TelegramApiException {
        try {
            return this.executeAsync(addStickerToSet).get();
        }
        catch (Exception e) {
            throw this.mapException(e, addStickerToSet.getMethod());
        }
    }

    @Override
    public Boolean execute(ReplaceStickerInSet replaceStickerInSet) throws TelegramApiException {
        try {
            return this.executeAsync(replaceStickerInSet).get();
        }
        catch (Exception e) {
            throw this.mapException(e, replaceStickerInSet.getMethod());
        }
    }

    @Override
    public Boolean execute(SetStickerSetThumbnail setStickerSetThumbnail) throws TelegramApiException {
        try {
            return this.executeAsync(setStickerSetThumbnail).get();
        }
        catch (Exception e) {
            throw this.mapException(e, setStickerSetThumbnail.getMethod());
        }
    }

    @Override
    public Boolean execute(CreateNewStickerSet createNewStickerSet) throws TelegramApiException {
        try {
            return this.executeAsync(createNewStickerSet).get();
        }
        catch (Exception e) {
            throw this.mapException(e, createNewStickerSet.getMethod());
        }
    }

    @Override
    public org.telegram.telegrambots.meta.api.objects.File execute(UploadStickerFile uploadStickerFile) throws TelegramApiException {
        try {
            return this.executeAsync(uploadStickerFile).get();
        }
        catch (Exception e) {
            throw this.mapException(e, uploadStickerFile.getMethod());
        }
    }

    @Override
    public Serializable execute(EditMessageMedia editMessageMedia) throws TelegramApiException {
        try {
            return this.executeAsync(editMessageMedia).get();
        }
        catch (Exception e) {
            throw this.mapException(e, editMessageMedia.getMethod());
        }
    }

    @Override
    public Message execute(SendAnimation sendAnimation) throws TelegramApiException {
        try {
            return this.executeAsync(sendAnimation).get();
        }
        catch (Exception e) {
            throw this.mapException(e, sendAnimation.getMethod());
        }
    }

    @Override
    public File downloadFile(org.telegram.telegrambots.meta.api.objects.File file) throws TelegramApiException {
        try {
            return this.downloadFileAsync(file).get();
        }
        catch (Exception e) {
            throw this.mapException(e, " download file ");
        }
    }

    @Override
    public InputStream downloadFileAsStream(org.telegram.telegrambots.meta.api.objects.File file) throws TelegramApiException {
        try {
            return this.downloadFileAsStreamAsync(file).get();
        }
        catch (Exception e) {
            throw this.mapException(e, " download file ");
        }
    }

    private TelegramApiException mapException(Exception e, String method) {
        if (e instanceof ExecutionException) {
            if (e.getCause() instanceof TelegramApiException) {
                return (TelegramApiException)e.getCause();
            }
            return new TelegramApiException("Unable to execute " + method + " method", e.getCause());
        }
        return new TelegramApiException("Unable to execute " + method + " method", e);
    }
}

