/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.client.okhttp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

class OkHttpFutureDownloadCallback
extends CompletableFuture<InputStream>
implements Callback {
    OkHttpFutureDownloadCallback() {
    }

    @Override
    public void onFailure(@NonNull Call call, @NonNull IOException exception) {
        if (call == null) {
            throw new NullPointerException("call is marked non-null but is null");
        }
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        this.completeExceptionally(exception);
    }

    @Override
    public void onResponse(@NonNull Call call, @NonNull Response response) {
        if (call == null) {
            throw new NullPointerException("call is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        try (ResponseBody body = response.body();){
            if (body == null) {
                this.completeExceptionally(new TelegramApiException("Telegram api returned empty response"));
            } else {
                this.complete(new ByteArrayInputStream(IOUtils.toByteArray(body.byteStream())));
            }
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
    }
}

