/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ChatInviteLink;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=EditChatSubscriptionInviteLinkBuilderImpl.class)
public class EditChatSubscriptionInviteLink
extends BotApiMethod<ChatInviteLink> {
    public static final String PATH = "editChatSubscriptionInviteLink";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String INVITE_LINK_FIELD = "invite_link";
    private static final String NAME_FIELD = "name";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="invite_link")
    @NonNull
    private String inviteLink;
    @JsonProperty(value="name")
    private String name;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public ChatInviteLink deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, ChatInviteLink.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredChatId(this.chatId, this);
        if (this.name != null && this.name.length() > 32) {
            throw new TelegramApiValidationException("Name must be between 0 and 32 characters", this);
        }
        if (this.inviteLink.isEmpty()) {
            throw new TelegramApiValidationException("InviteLink must not be empty", this);
        }
    }

    @Generated
    protected EditChatSubscriptionInviteLink(EditChatSubscriptionInviteLinkBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.inviteLink = b.inviteLink;
        if (this.inviteLink == null) {
            throw new NullPointerException("inviteLink is marked non-null but is null");
        }
        this.name = b.name;
    }

    @Generated
    public static EditChatSubscriptionInviteLinkBuilder<?, ?> builder() {
        return new EditChatSubscriptionInviteLinkBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditChatSubscriptionInviteLink)) {
            return false;
        }
        EditChatSubscriptionInviteLink other = (EditChatSubscriptionInviteLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$inviteLink = this.getInviteLink();
        String other$inviteLink = other.getInviteLink();
        if (this$inviteLink == null ? other$inviteLink != null : !this$inviteLink.equals(other$inviteLink)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EditChatSubscriptionInviteLink;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $inviteLink = this.getInviteLink();
        result = result * 59 + ($inviteLink == null ? 43 : $inviteLink.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public String getInviteLink() {
        return this.inviteLink;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="invite_link")
    @Generated
    public void setInviteLink(@NonNull String inviteLink) {
        if (inviteLink == null) {
            throw new NullPointerException("inviteLink is marked non-null but is null");
        }
        this.inviteLink = inviteLink;
    }

    @JsonProperty(value="name")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String toString() {
        return "EditChatSubscriptionInviteLink(chatId=" + this.getChatId() + ", inviteLink=" + this.getInviteLink() + ", name=" + this.getName() + ")";
    }

    @Generated
    public EditChatSubscriptionInviteLink(@NonNull String chatId, @NonNull String inviteLink, String name) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (inviteLink == null) {
            throw new NullPointerException("inviteLink is marked non-null but is null");
        }
        this.chatId = chatId;
        this.inviteLink = inviteLink;
        this.name = name;
    }

    @Generated
    public EditChatSubscriptionInviteLink(@NonNull String chatId, @NonNull String inviteLink) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (inviteLink == null) {
            throw new NullPointerException("inviteLink is marked non-null but is null");
        }
        this.chatId = chatId;
        this.inviteLink = inviteLink;
    }

    public static abstract class EditChatSubscriptionInviteLinkBuilder<C extends EditChatSubscriptionInviteLink, B extends EditChatSubscriptionInviteLinkBuilder<C, B>>
    extends BotApiMethod.BotApiMethodBuilder<ChatInviteLink, C, B> {
        @Generated
        private String chatId;
        @Generated
        private String inviteLink;
        @Generated
        private String name;

        public EditChatSubscriptionInviteLinkBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="invite_link")
        @Generated
        public B inviteLink(@NonNull String inviteLink) {
            if (inviteLink == null) {
                throw new NullPointerException("inviteLink is marked non-null but is null");
            }
            this.inviteLink = inviteLink;
            return (B)this.self();
        }

        @JsonProperty(value="name")
        @Generated
        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "EditChatSubscriptionInviteLink.EditChatSubscriptionInviteLinkBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", inviteLink=" + this.inviteLink + ", name=" + this.name + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class EditChatSubscriptionInviteLinkBuilderImpl
    extends EditChatSubscriptionInviteLinkBuilder<EditChatSubscriptionInviteLink, EditChatSubscriptionInviteLinkBuilderImpl> {
        @Generated
        private EditChatSubscriptionInviteLinkBuilderImpl() {
        }

        @Override
        @Generated
        protected EditChatSubscriptionInviteLinkBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public EditChatSubscriptionInviteLink build() {
            return new EditChatSubscriptionInviteLink(this);
        }
    }
}

