/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.invoices;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.payments.LabeledPrice;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=CreateInvoiceLinkBuilderImpl.class)
public class CreateInvoiceLink
extends BotApiMethod<String> {
    public static final String PATH = "createInvoiceLink";
    public static final String TITLE_FIELD = "title";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String PAYLOAD_FIELD = "payload";
    public static final String PROVIDER_TOKEN_FIELD = "provider_token";
    public static final String CURRENCY_FIELD = "currency";
    public static final String PRICES_FIELD = "prices";
    public static final String MAX_TIP_AMOUNT_FIELD = "max_tip_amount";
    public static final String SUGGESTED_TIP_AMOUNTS_FIELD = "suggested_tip_amounts";
    public static final String PROVIDER_DATA_FIELD = "provider_data";
    public static final String PHOTO_URL_FIELD = "photo_url";
    public static final String PHOTO_SIZE_FIELD = "photo_size";
    public static final String PHOTO_WIDTH_FIELD = "photo_width";
    public static final String PHOTO_HEIGHT_FIELD = "photo_height";
    public static final String NEED_NAME_FIELD = "need_name";
    public static final String NEED_PHONE_NUMBER_FIELD = "need_phone_number";
    public static final String NEED_EMAIL_FIELD = "need_email";
    public static final String NEED_SHIPPING_ADDRESS_FIELD = "need_shipping_address";
    public static final String SEND_PHONE_NUMBER_TO_PROVIDER_FIELD = "send_phone_number_to_provider";
    public static final String SEND_EMAIL_TO_PROVIDER_FIELD = "send_email_to_provider";
    public static final String IS_FLEXIBLE_FIELD = "is_flexible";
    public static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    public static final String SUBSCRIPTION_PERIOD_FIELD = "subscription_period";
    @JsonProperty(value="title")
    @NonNull
    private String title;
    @JsonProperty(value="description")
    @NonNull
    private String description;
    @JsonProperty(value="payload")
    @NonNull
    private String payload;
    @JsonProperty(value="provider_token")
    private String providerToken;
    @JsonProperty(value="currency")
    @NonNull
    private String currency;
    @JsonProperty(value="prices")
    @NonNull
    private List<LabeledPrice> prices;
    @JsonProperty(value="photo_url")
    private String photoUrl;
    @JsonProperty(value="photo_size")
    private Integer photoSize;
    @JsonProperty(value="photo_width")
    private Integer photoWidth;
    @JsonProperty(value="photo_height")
    private Integer photoHeight;
    @JsonProperty(value="need_name")
    private Boolean needName;
    @JsonProperty(value="need_phone_number")
    private Boolean needPhoneNumber;
    @JsonProperty(value="need_email")
    private Boolean needEmail;
    @JsonProperty(value="need_shipping_address")
    private Boolean needShippingAddress;
    @JsonProperty(value="is_flexible")
    private Boolean isFlexible;
    @JsonProperty(value="send_phone_number_to_provider")
    private Boolean sendPhoneNumberToProvider;
    @JsonProperty(value="send_email_to_provider")
    private Boolean sendEmailToProvider;
    @JsonProperty(value="provider_data")
    private String providerData;
    @JsonProperty(value="max_tip_amount")
    private Integer maxTipAmount;
    @JsonProperty(value="suggested_tip_amounts")
    private List<Integer> suggestedTipAmounts;
    @JsonProperty(value="business_connection_id")
    private String businessConnectionId;
    @JsonProperty(value="subscription_period")
    private Integer subscriptionPeriod;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (StringUtils.isEmpty(this.title) || this.title.length() > 32) {
            throw new TelegramApiValidationException("Title parameter can't be empty or longer than 32 chars", this);
        }
        if (StringUtils.isEmpty(this.description) || this.description.length() > 255) {
            throw new TelegramApiValidationException("Description parameter can't be empty or longer than 255 chars", this);
        }
        if (StringUtils.isEmpty(this.payload)) {
            throw new TelegramApiValidationException("Payload parameter can't be empty", this);
        }
        if (StringUtils.isEmpty(this.currency)) {
            throw new TelegramApiValidationException("Currency parameter can't be empty", this);
        }
        if (this.prices.isEmpty()) {
            throw new TelegramApiValidationException("Prices parameter can't be empty", this);
        }
        for (LabeledPrice price : this.prices) {
            price.validate();
        }
        if (this.suggestedTipAmounts != null && !this.suggestedTipAmounts.isEmpty() && this.suggestedTipAmounts.size() > 4) {
            throw new TelegramApiValidationException("No more that 4 suggested tips allowed", this);
        }
    }

    @Override
    public String deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, String.class);
    }

    @Generated
    protected CreateInvoiceLink(CreateInvoiceLinkBuilder<?, ?> b) {
        super(b);
        this.title = b.title;
        if (this.title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.description = b.description;
        if (this.description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.payload = b.payload;
        if (this.payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        this.providerToken = b.providerToken;
        this.currency = b.currency;
        if (this.currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        List<Object> prices = switch (b.prices == null ? 0 : b.prices.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.prices.get(0));
            default -> Collections.unmodifiableList(new ArrayList<LabeledPrice>(b.prices));
        };
        this.prices = prices;
        if (prices == null) {
            throw new NullPointerException("prices is marked non-null but is null");
        }
        this.photoUrl = b.photoUrl;
        this.photoSize = b.photoSize;
        this.photoWidth = b.photoWidth;
        this.photoHeight = b.photoHeight;
        this.needName = b.needName;
        this.needPhoneNumber = b.needPhoneNumber;
        this.needEmail = b.needEmail;
        this.needShippingAddress = b.needShippingAddress;
        this.isFlexible = b.isFlexible;
        this.sendPhoneNumberToProvider = b.sendPhoneNumberToProvider;
        this.sendEmailToProvider = b.sendEmailToProvider;
        this.providerData = b.providerData;
        this.maxTipAmount = b.maxTipAmount;
        this.suggestedTipAmounts = switch (b.suggestedTipAmounts == null ? 0 : b.suggestedTipAmounts.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.suggestedTipAmounts.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Integer>(b.suggestedTipAmounts));
        };
        this.businessConnectionId = b.businessConnectionId;
        this.subscriptionPeriod = b.subscriptionPeriod;
    }

    @Generated
    public static CreateInvoiceLinkBuilder<?, ?> builder() {
        return new CreateInvoiceLinkBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateInvoiceLink)) {
            return false;
        }
        CreateInvoiceLink other = (CreateInvoiceLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$photoSize = this.getPhotoSize();
        Integer other$photoSize = other.getPhotoSize();
        if (this$photoSize == null ? other$photoSize != null : !((Object)this$photoSize).equals(other$photoSize)) {
            return false;
        }
        Integer this$photoWidth = this.getPhotoWidth();
        Integer other$photoWidth = other.getPhotoWidth();
        if (this$photoWidth == null ? other$photoWidth != null : !((Object)this$photoWidth).equals(other$photoWidth)) {
            return false;
        }
        Integer this$photoHeight = this.getPhotoHeight();
        Integer other$photoHeight = other.getPhotoHeight();
        if (this$photoHeight == null ? other$photoHeight != null : !((Object)this$photoHeight).equals(other$photoHeight)) {
            return false;
        }
        Boolean this$needName = this.getNeedName();
        Boolean other$needName = other.getNeedName();
        if (this$needName == null ? other$needName != null : !((Object)this$needName).equals(other$needName)) {
            return false;
        }
        Boolean this$needPhoneNumber = this.getNeedPhoneNumber();
        Boolean other$needPhoneNumber = other.getNeedPhoneNumber();
        if (this$needPhoneNumber == null ? other$needPhoneNumber != null : !((Object)this$needPhoneNumber).equals(other$needPhoneNumber)) {
            return false;
        }
        Boolean this$needEmail = this.getNeedEmail();
        Boolean other$needEmail = other.getNeedEmail();
        if (this$needEmail == null ? other$needEmail != null : !((Object)this$needEmail).equals(other$needEmail)) {
            return false;
        }
        Boolean this$needShippingAddress = this.getNeedShippingAddress();
        Boolean other$needShippingAddress = other.getNeedShippingAddress();
        if (this$needShippingAddress == null ? other$needShippingAddress != null : !((Object)this$needShippingAddress).equals(other$needShippingAddress)) {
            return false;
        }
        Boolean this$isFlexible = this.getIsFlexible();
        Boolean other$isFlexible = other.getIsFlexible();
        if (this$isFlexible == null ? other$isFlexible != null : !((Object)this$isFlexible).equals(other$isFlexible)) {
            return false;
        }
        Boolean this$sendPhoneNumberToProvider = this.getSendPhoneNumberToProvider();
        Boolean other$sendPhoneNumberToProvider = other.getSendPhoneNumberToProvider();
        if (this$sendPhoneNumberToProvider == null ? other$sendPhoneNumberToProvider != null : !((Object)this$sendPhoneNumberToProvider).equals(other$sendPhoneNumberToProvider)) {
            return false;
        }
        Boolean this$sendEmailToProvider = this.getSendEmailToProvider();
        Boolean other$sendEmailToProvider = other.getSendEmailToProvider();
        if (this$sendEmailToProvider == null ? other$sendEmailToProvider != null : !((Object)this$sendEmailToProvider).equals(other$sendEmailToProvider)) {
            return false;
        }
        Integer this$maxTipAmount = this.getMaxTipAmount();
        Integer other$maxTipAmount = other.getMaxTipAmount();
        if (this$maxTipAmount == null ? other$maxTipAmount != null : !((Object)this$maxTipAmount).equals(other$maxTipAmount)) {
            return false;
        }
        Integer this$subscriptionPeriod = this.getSubscriptionPeriod();
        Integer other$subscriptionPeriod = other.getSubscriptionPeriod();
        if (this$subscriptionPeriod == null ? other$subscriptionPeriod != null : !((Object)this$subscriptionPeriod).equals(other$subscriptionPeriod)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$payload = this.getPayload();
        String other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        String this$providerToken = this.getProviderToken();
        String other$providerToken = other.getProviderToken();
        if (this$providerToken == null ? other$providerToken != null : !this$providerToken.equals(other$providerToken)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        List<LabeledPrice> this$prices = this.getPrices();
        List<LabeledPrice> other$prices = other.getPrices();
        if (this$prices == null ? other$prices != null : !((Object)this$prices).equals(other$prices)) {
            return false;
        }
        String this$photoUrl = this.getPhotoUrl();
        String other$photoUrl = other.getPhotoUrl();
        if (this$photoUrl == null ? other$photoUrl != null : !this$photoUrl.equals(other$photoUrl)) {
            return false;
        }
        String this$providerData = this.getProviderData();
        String other$providerData = other.getProviderData();
        if (this$providerData == null ? other$providerData != null : !this$providerData.equals(other$providerData)) {
            return false;
        }
        List<Integer> this$suggestedTipAmounts = this.getSuggestedTipAmounts();
        List<Integer> other$suggestedTipAmounts = other.getSuggestedTipAmounts();
        if (this$suggestedTipAmounts == null ? other$suggestedTipAmounts != null : !((Object)this$suggestedTipAmounts).equals(other$suggestedTipAmounts)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        return !(this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateInvoiceLink;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $photoSize = this.getPhotoSize();
        result = result * 59 + ($photoSize == null ? 43 : ((Object)$photoSize).hashCode());
        Integer $photoWidth = this.getPhotoWidth();
        result = result * 59 + ($photoWidth == null ? 43 : ((Object)$photoWidth).hashCode());
        Integer $photoHeight = this.getPhotoHeight();
        result = result * 59 + ($photoHeight == null ? 43 : ((Object)$photoHeight).hashCode());
        Boolean $needName = this.getNeedName();
        result = result * 59 + ($needName == null ? 43 : ((Object)$needName).hashCode());
        Boolean $needPhoneNumber = this.getNeedPhoneNumber();
        result = result * 59 + ($needPhoneNumber == null ? 43 : ((Object)$needPhoneNumber).hashCode());
        Boolean $needEmail = this.getNeedEmail();
        result = result * 59 + ($needEmail == null ? 43 : ((Object)$needEmail).hashCode());
        Boolean $needShippingAddress = this.getNeedShippingAddress();
        result = result * 59 + ($needShippingAddress == null ? 43 : ((Object)$needShippingAddress).hashCode());
        Boolean $isFlexible = this.getIsFlexible();
        result = result * 59 + ($isFlexible == null ? 43 : ((Object)$isFlexible).hashCode());
        Boolean $sendPhoneNumberToProvider = this.getSendPhoneNumberToProvider();
        result = result * 59 + ($sendPhoneNumberToProvider == null ? 43 : ((Object)$sendPhoneNumberToProvider).hashCode());
        Boolean $sendEmailToProvider = this.getSendEmailToProvider();
        result = result * 59 + ($sendEmailToProvider == null ? 43 : ((Object)$sendEmailToProvider).hashCode());
        Integer $maxTipAmount = this.getMaxTipAmount();
        result = result * 59 + ($maxTipAmount == null ? 43 : ((Object)$maxTipAmount).hashCode());
        Integer $subscriptionPeriod = this.getSubscriptionPeriod();
        result = result * 59 + ($subscriptionPeriod == null ? 43 : ((Object)$subscriptionPeriod).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        String $providerToken = this.getProviderToken();
        result = result * 59 + ($providerToken == null ? 43 : $providerToken.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        List<LabeledPrice> $prices = this.getPrices();
        result = result * 59 + ($prices == null ? 43 : ((Object)$prices).hashCode());
        String $photoUrl = this.getPhotoUrl();
        result = result * 59 + ($photoUrl == null ? 43 : $photoUrl.hashCode());
        String $providerData = this.getProviderData();
        result = result * 59 + ($providerData == null ? 43 : $providerData.hashCode());
        List<Integer> $suggestedTipAmounts = this.getSuggestedTipAmounts();
        result = result * 59 + ($suggestedTipAmounts == null ? 43 : ((Object)$suggestedTipAmounts).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getTitle() {
        return this.title;
    }

    @NonNull
    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String getPayload() {
        return this.payload;
    }

    @Generated
    public String getProviderToken() {
        return this.providerToken;
    }

    @NonNull
    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @NonNull
    @Generated
    public List<LabeledPrice> getPrices() {
        return this.prices;
    }

    @Generated
    public String getPhotoUrl() {
        return this.photoUrl;
    }

    @Generated
    public Integer getPhotoSize() {
        return this.photoSize;
    }

    @Generated
    public Integer getPhotoWidth() {
        return this.photoWidth;
    }

    @Generated
    public Integer getPhotoHeight() {
        return this.photoHeight;
    }

    @Generated
    public Boolean getNeedName() {
        return this.needName;
    }

    @Generated
    public Boolean getNeedPhoneNumber() {
        return this.needPhoneNumber;
    }

    @Generated
    public Boolean getNeedEmail() {
        return this.needEmail;
    }

    @Generated
    public Boolean getNeedShippingAddress() {
        return this.needShippingAddress;
    }

    @Generated
    public Boolean getIsFlexible() {
        return this.isFlexible;
    }

    @Generated
    public Boolean getSendPhoneNumberToProvider() {
        return this.sendPhoneNumberToProvider;
    }

    @Generated
    public Boolean getSendEmailToProvider() {
        return this.sendEmailToProvider;
    }

    @Generated
    public String getProviderData() {
        return this.providerData;
    }

    @Generated
    public Integer getMaxTipAmount() {
        return this.maxTipAmount;
    }

    @Generated
    public List<Integer> getSuggestedTipAmounts() {
        return this.suggestedTipAmounts;
    }

    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @Generated
    public Integer getSubscriptionPeriod() {
        return this.subscriptionPeriod;
    }

    @JsonProperty(value="title")
    @Generated
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @JsonProperty(value="description")
    @Generated
    public void setDescription(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = description;
    }

    @JsonProperty(value="payload")
    @Generated
    public void setPayload(@NonNull String payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        this.payload = payload;
    }

    @JsonProperty(value="provider_token")
    @Generated
    public void setProviderToken(String providerToken) {
        this.providerToken = providerToken;
    }

    @JsonProperty(value="currency")
    @Generated
    public void setCurrency(@NonNull String currency) {
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        this.currency = currency;
    }

    @JsonProperty(value="prices")
    @Generated
    public void setPrices(@NonNull List<LabeledPrice> prices) {
        if (prices == null) {
            throw new NullPointerException("prices is marked non-null but is null");
        }
        this.prices = prices;
    }

    @JsonProperty(value="photo_url")
    @Generated
    public void setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
    }

    @JsonProperty(value="photo_size")
    @Generated
    public void setPhotoSize(Integer photoSize) {
        this.photoSize = photoSize;
    }

    @JsonProperty(value="photo_width")
    @Generated
    public void setPhotoWidth(Integer photoWidth) {
        this.photoWidth = photoWidth;
    }

    @JsonProperty(value="photo_height")
    @Generated
    public void setPhotoHeight(Integer photoHeight) {
        this.photoHeight = photoHeight;
    }

    @JsonProperty(value="need_name")
    @Generated
    public void setNeedName(Boolean needName) {
        this.needName = needName;
    }

    @JsonProperty(value="need_phone_number")
    @Generated
    public void setNeedPhoneNumber(Boolean needPhoneNumber) {
        this.needPhoneNumber = needPhoneNumber;
    }

    @JsonProperty(value="need_email")
    @Generated
    public void setNeedEmail(Boolean needEmail) {
        this.needEmail = needEmail;
    }

    @JsonProperty(value="need_shipping_address")
    @Generated
    public void setNeedShippingAddress(Boolean needShippingAddress) {
        this.needShippingAddress = needShippingAddress;
    }

    @JsonProperty(value="is_flexible")
    @Generated
    public void setIsFlexible(Boolean isFlexible) {
        this.isFlexible = isFlexible;
    }

    @JsonProperty(value="send_phone_number_to_provider")
    @Generated
    public void setSendPhoneNumberToProvider(Boolean sendPhoneNumberToProvider) {
        this.sendPhoneNumberToProvider = sendPhoneNumberToProvider;
    }

    @JsonProperty(value="send_email_to_provider")
    @Generated
    public void setSendEmailToProvider(Boolean sendEmailToProvider) {
        this.sendEmailToProvider = sendEmailToProvider;
    }

    @JsonProperty(value="provider_data")
    @Generated
    public void setProviderData(String providerData) {
        this.providerData = providerData;
    }

    @JsonProperty(value="max_tip_amount")
    @Generated
    public void setMaxTipAmount(Integer maxTipAmount) {
        this.maxTipAmount = maxTipAmount;
    }

    @JsonProperty(value="suggested_tip_amounts")
    @Generated
    public void setSuggestedTipAmounts(List<Integer> suggestedTipAmounts) {
        this.suggestedTipAmounts = suggestedTipAmounts;
    }

    @JsonProperty(value="business_connection_id")
    @Generated
    public void setBusinessConnectionId(String businessConnectionId) {
        this.businessConnectionId = businessConnectionId;
    }

    @JsonProperty(value="subscription_period")
    @Generated
    public void setSubscriptionPeriod(Integer subscriptionPeriod) {
        this.subscriptionPeriod = subscriptionPeriod;
    }

    @Generated
    public String toString() {
        return "CreateInvoiceLink(title=" + this.getTitle() + ", description=" + this.getDescription() + ", payload=" + this.getPayload() + ", providerToken=" + this.getProviderToken() + ", currency=" + this.getCurrency() + ", prices=" + this.getPrices() + ", photoUrl=" + this.getPhotoUrl() + ", photoSize=" + this.getPhotoSize() + ", photoWidth=" + this.getPhotoWidth() + ", photoHeight=" + this.getPhotoHeight() + ", needName=" + this.getNeedName() + ", needPhoneNumber=" + this.getNeedPhoneNumber() + ", needEmail=" + this.getNeedEmail() + ", needShippingAddress=" + this.getNeedShippingAddress() + ", isFlexible=" + this.getIsFlexible() + ", sendPhoneNumberToProvider=" + this.getSendPhoneNumberToProvider() + ", sendEmailToProvider=" + this.getSendEmailToProvider() + ", providerData=" + this.getProviderData() + ", maxTipAmount=" + this.getMaxTipAmount() + ", suggestedTipAmounts=" + this.getSuggestedTipAmounts() + ", businessConnectionId=" + this.getBusinessConnectionId() + ", subscriptionPeriod=" + this.getSubscriptionPeriod() + ")";
    }

    @Generated
    public CreateInvoiceLink(@NonNull String title, @NonNull String description, @NonNull String payload, @NonNull String currency, @NonNull List<LabeledPrice> prices) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        if (prices == null) {
            throw new NullPointerException("prices is marked non-null but is null");
        }
        this.title = title;
        this.description = description;
        this.payload = payload;
        this.currency = currency;
        this.prices = prices;
    }

    @Generated
    public CreateInvoiceLink(@NonNull String title, @NonNull String description, @NonNull String payload, String providerToken, @NonNull String currency, @NonNull List<LabeledPrice> prices, String photoUrl, Integer photoSize, Integer photoWidth, Integer photoHeight, Boolean needName, Boolean needPhoneNumber, Boolean needEmail, Boolean needShippingAddress, Boolean isFlexible, Boolean sendPhoneNumberToProvider, Boolean sendEmailToProvider, String providerData, Integer maxTipAmount, List<Integer> suggestedTipAmounts, String businessConnectionId, Integer subscriptionPeriod) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        if (prices == null) {
            throw new NullPointerException("prices is marked non-null but is null");
        }
        this.title = title;
        this.description = description;
        this.payload = payload;
        this.providerToken = providerToken;
        this.currency = currency;
        this.prices = prices;
        this.photoUrl = photoUrl;
        this.photoSize = photoSize;
        this.photoWidth = photoWidth;
        this.photoHeight = photoHeight;
        this.needName = needName;
        this.needPhoneNumber = needPhoneNumber;
        this.needEmail = needEmail;
        this.needShippingAddress = needShippingAddress;
        this.isFlexible = isFlexible;
        this.sendPhoneNumberToProvider = sendPhoneNumberToProvider;
        this.sendEmailToProvider = sendEmailToProvider;
        this.providerData = providerData;
        this.maxTipAmount = maxTipAmount;
        this.suggestedTipAmounts = suggestedTipAmounts;
        this.businessConnectionId = businessConnectionId;
        this.subscriptionPeriod = subscriptionPeriod;
    }

    @Generated
    public static abstract class CreateInvoiceLinkBuilder<C extends CreateInvoiceLink, B extends CreateInvoiceLinkBuilder<C, B>>
    extends BotApiMethod.BotApiMethodBuilder<String, C, B> {
        @Generated
        private String title;
        @Generated
        private String description;
        @Generated
        private String payload;
        @Generated
        private String providerToken;
        @Generated
        private String currency;
        @Generated
        private ArrayList<LabeledPrice> prices;
        @Generated
        private String photoUrl;
        @Generated
        private Integer photoSize;
        @Generated
        private Integer photoWidth;
        @Generated
        private Integer photoHeight;
        @Generated
        private Boolean needName;
        @Generated
        private Boolean needPhoneNumber;
        @Generated
        private Boolean needEmail;
        @Generated
        private Boolean needShippingAddress;
        @Generated
        private Boolean isFlexible;
        @Generated
        private Boolean sendPhoneNumberToProvider;
        @Generated
        private Boolean sendEmailToProvider;
        @Generated
        private String providerData;
        @Generated
        private Integer maxTipAmount;
        @Generated
        private ArrayList<Integer> suggestedTipAmounts;
        @Generated
        private String businessConnectionId;
        @Generated
        private Integer subscriptionPeriod;

        @JsonProperty(value="title")
        @Generated
        public B title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return (B)this.self();
        }

        @JsonProperty(value="description")
        @Generated
        public B description(@NonNull String description) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.description = description;
            return (B)this.self();
        }

        @JsonProperty(value="payload")
        @Generated
        public B payload(@NonNull String payload) {
            if (payload == null) {
                throw new NullPointerException("payload is marked non-null but is null");
            }
            this.payload = payload;
            return (B)this.self();
        }

        @JsonProperty(value="provider_token")
        @Generated
        public B providerToken(String providerToken) {
            this.providerToken = providerToken;
            return (B)this.self();
        }

        @JsonProperty(value="currency")
        @Generated
        public B currency(@NonNull String currency) {
            if (currency == null) {
                throw new NullPointerException("currency is marked non-null but is null");
            }
            this.currency = currency;
            return (B)this.self();
        }

        @Generated
        public B price(LabeledPrice price) {
            if (this.prices == null) {
                this.prices = new ArrayList();
            }
            this.prices.add(price);
            return (B)this.self();
        }

        @JsonProperty(value="prices")
        @Generated
        public B prices(Collection<? extends LabeledPrice> prices) {
            if (prices == null) {
                throw new NullPointerException("prices cannot be null");
            }
            if (this.prices == null) {
                this.prices = new ArrayList();
            }
            this.prices.addAll(prices);
            return (B)this.self();
        }

        @Generated
        public B clearPrices() {
            if (this.prices != null) {
                this.prices.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="photo_url")
        @Generated
        public B photoUrl(String photoUrl) {
            this.photoUrl = photoUrl;
            return (B)this.self();
        }

        @JsonProperty(value="photo_size")
        @Generated
        public B photoSize(Integer photoSize) {
            this.photoSize = photoSize;
            return (B)this.self();
        }

        @JsonProperty(value="photo_width")
        @Generated
        public B photoWidth(Integer photoWidth) {
            this.photoWidth = photoWidth;
            return (B)this.self();
        }

        @JsonProperty(value="photo_height")
        @Generated
        public B photoHeight(Integer photoHeight) {
            this.photoHeight = photoHeight;
            return (B)this.self();
        }

        @JsonProperty(value="need_name")
        @Generated
        public B needName(Boolean needName) {
            this.needName = needName;
            return (B)this.self();
        }

        @JsonProperty(value="need_phone_number")
        @Generated
        public B needPhoneNumber(Boolean needPhoneNumber) {
            this.needPhoneNumber = needPhoneNumber;
            return (B)this.self();
        }

        @JsonProperty(value="need_email")
        @Generated
        public B needEmail(Boolean needEmail) {
            this.needEmail = needEmail;
            return (B)this.self();
        }

        @JsonProperty(value="need_shipping_address")
        @Generated
        public B needShippingAddress(Boolean needShippingAddress) {
            this.needShippingAddress = needShippingAddress;
            return (B)this.self();
        }

        @JsonProperty(value="is_flexible")
        @Generated
        public B isFlexible(Boolean isFlexible) {
            this.isFlexible = isFlexible;
            return (B)this.self();
        }

        @JsonProperty(value="send_phone_number_to_provider")
        @Generated
        public B sendPhoneNumberToProvider(Boolean sendPhoneNumberToProvider) {
            this.sendPhoneNumberToProvider = sendPhoneNumberToProvider;
            return (B)this.self();
        }

        @JsonProperty(value="send_email_to_provider")
        @Generated
        public B sendEmailToProvider(Boolean sendEmailToProvider) {
            this.sendEmailToProvider = sendEmailToProvider;
            return (B)this.self();
        }

        @JsonProperty(value="provider_data")
        @Generated
        public B providerData(String providerData) {
            this.providerData = providerData;
            return (B)this.self();
        }

        @JsonProperty(value="max_tip_amount")
        @Generated
        public B maxTipAmount(Integer maxTipAmount) {
            this.maxTipAmount = maxTipAmount;
            return (B)this.self();
        }

        @Generated
        public B suggestedTipAmount(Integer suggestedTipAmount) {
            if (this.suggestedTipAmounts == null) {
                this.suggestedTipAmounts = new ArrayList();
            }
            this.suggestedTipAmounts.add(suggestedTipAmount);
            return (B)this.self();
        }

        @JsonProperty(value="suggested_tip_amounts")
        @Generated
        public B suggestedTipAmounts(Collection<? extends Integer> suggestedTipAmounts) {
            if (suggestedTipAmounts == null) {
                throw new NullPointerException("suggestedTipAmounts cannot be null");
            }
            if (this.suggestedTipAmounts == null) {
                this.suggestedTipAmounts = new ArrayList();
            }
            this.suggestedTipAmounts.addAll(suggestedTipAmounts);
            return (B)this.self();
        }

        @Generated
        public B clearSuggestedTipAmounts() {
            if (this.suggestedTipAmounts != null) {
                this.suggestedTipAmounts.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="business_connection_id")
        @Generated
        public B businessConnectionId(String businessConnectionId) {
            this.businessConnectionId = businessConnectionId;
            return (B)this.self();
        }

        @JsonProperty(value="subscription_period")
        @Generated
        public B subscriptionPeriod(Integer subscriptionPeriod) {
            this.subscriptionPeriod = subscriptionPeriod;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CreateInvoiceLink.CreateInvoiceLinkBuilder(super=" + super.toString() + ", title=" + this.title + ", description=" + this.description + ", payload=" + this.payload + ", providerToken=" + this.providerToken + ", currency=" + this.currency + ", prices=" + this.prices + ", photoUrl=" + this.photoUrl + ", photoSize=" + this.photoSize + ", photoWidth=" + this.photoWidth + ", photoHeight=" + this.photoHeight + ", needName=" + this.needName + ", needPhoneNumber=" + this.needPhoneNumber + ", needEmail=" + this.needEmail + ", needShippingAddress=" + this.needShippingAddress + ", isFlexible=" + this.isFlexible + ", sendPhoneNumberToProvider=" + this.sendPhoneNumberToProvider + ", sendEmailToProvider=" + this.sendEmailToProvider + ", providerData=" + this.providerData + ", maxTipAmount=" + this.maxTipAmount + ", suggestedTipAmounts=" + this.suggestedTipAmounts + ", businessConnectionId=" + this.businessConnectionId + ", subscriptionPeriod=" + this.subscriptionPeriod + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class CreateInvoiceLinkBuilderImpl
    extends CreateInvoiceLinkBuilder<CreateInvoiceLink, CreateInvoiceLinkBuilderImpl> {
        @Generated
        private CreateInvoiceLinkBuilderImpl() {
        }

        @Override
        @Generated
        protected CreateInvoiceLinkBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CreateInvoiceLink build() {
            return new CreateInvoiceLink(this);
        }
    }
}

