/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.invoices;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodMessage;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.payments.LabeledPrice;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=SendInvoiceBuilderImpl.class)
public class SendInvoice
extends BotApiMethodMessage {
    public static final String PATH = "sendinvoice";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_THREAD_ID_FIELD = "message_thread_id";
    private static final String TITLE_FIELD = "title";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String PAYLOAD_FIELD = "payload";
    private static final String PROVIDER_TOKEN_FIELD = "provider_token";
    private static final String START_PARAMETER_FIELD = "start_parameter";
    private static final String CURRENCY_FIELD = "currency";
    private static final String PRICES_FIELD = "prices";
    private static final String PHOTO_URL_FIELD = "photo_url";
    private static final String PHOTO_SIZE_FIELD = "photo_size";
    private static final String PHOTO_WIDTH_FIELD = "photo_width";
    private static final String PHOTO_HEIGHT_FIELD = "photo_height";
    private static final String NEED_NAME_FIELD = "need_name";
    private static final String NEED_PHONE_NUMBER_FIELD = "need_phone_number";
    private static final String NEED_EMAIL_FIELD = "need_email";
    private static final String NEED_SHIPPING_ADDRESS_FIELD = "need_shipping_address";
    private static final String SEND_PHONE_NUMBER_TO_PROVIDER_FIELD = "send_phone_number_to_provider";
    private static final String SEND_EMAIL_TO_PROVIDER_FIELD = "send_email_to_provider";
    private static final String IS_FLEXIBLE_FIELD = "is_flexible";
    private static final String DISABLE_NOTIFICATION_FIELD = "disable_notification";
    private static final String REPLY_TO_MESSAGE_ID_FIELD = "reply_to_message_id";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String PROVIDER_DATA_FIELD = "provider_data";
    private static final String ALLOW_SENDING_WITHOUT_REPLY_FIELD = "allow_sending_without_reply";
    private static final String MAX_TIP_AMOUNT_FIELD = "max_tip_amount";
    private static final String SUGGESTED_TIP_AMOUNTS_FIELD = "suggested_tip_amounts";
    private static final String PROTECT_CONTENT_FIELD = "protect_content";
    private static final String REPLY_PARAMETERS_FIELD = "reply_parameters";
    private static final String MESSAGE_EFFECT_ID_FIELD = "message_effect_id";
    private static final String ALLOW_PAID_BROADCAST_FIELD = "allow_paid_broadcast";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_thread_id")
    private Integer messageThreadId;
    @JsonProperty(value="title")
    @NonNull
    private String title;
    @JsonProperty(value="description")
    @NonNull
    private String description;
    @JsonProperty(value="payload")
    @NonNull
    private String payload;
    @JsonProperty(value="provider_token")
    private String providerToken;
    @JsonProperty(value="start_parameter")
    private String startParameter;
    @JsonProperty(value="currency")
    @NonNull
    private String currency;
    @JsonProperty(value="prices")
    @NonNull
    private List<LabeledPrice> prices;
    @JsonProperty(value="photo_url")
    private String photoUrl;
    @JsonProperty(value="photo_size")
    private Integer photoSize;
    @JsonProperty(value="photo_width")
    private Integer photoWidth;
    @JsonProperty(value="photo_height")
    private Integer photoHeight;
    @JsonProperty(value="need_name")
    private Boolean needName;
    @JsonProperty(value="need_phone_number")
    private Boolean needPhoneNumber;
    @JsonProperty(value="need_email")
    private Boolean needEmail;
    @JsonProperty(value="need_shipping_address")
    private Boolean needShippingAddress;
    @JsonProperty(value="is_flexible")
    private Boolean isFlexible;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="reply_to_message_id")
    private Integer replyToMessageId;
    @JsonProperty(value="send_phone_number_to_provider")
    private Boolean sendPhoneNumberToProvider;
    @JsonProperty(value="send_email_to_provider")
    private Boolean sendEmailToProvider;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="provider_data")
    private String providerData;
    @JsonProperty(value="allow_sending_without_reply")
    private Boolean allowSendingWithoutReply;
    @JsonProperty(value="max_tip_amount")
    private Integer maxTipAmount;
    @JsonProperty(value="suggested_tip_amounts")
    private List<Integer> suggestedTipAmounts;
    @JsonProperty(value="protect_content")
    private Boolean protectContent;
    @JsonProperty(value="reply_parameters")
    private ReplyParameters replyParameters;
    @JsonProperty(value="message_effect_id")
    private String messageEffectId;
    @JsonProperty(value="allow_paid_broadcast")
    private Boolean allowPaidBroadcast;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredChatId(this.chatId, this);
        if (StringUtils.isEmpty(this.title) || this.title.length() > 32) {
            throw new TelegramApiValidationException("Title parameter can't be empty or longer than 32 chars", this);
        }
        if (StringUtils.isEmpty(this.description) || this.description.length() > 255) {
            throw new TelegramApiValidationException("Description parameter can't be empty or longer than 255 chars", this);
        }
        if (StringUtils.isEmpty(this.payload)) {
            throw new TelegramApiValidationException("Payload parameter can't be empty", this);
        }
        if (StringUtils.isEmpty(this.currency)) {
            throw new TelegramApiValidationException("Currency parameter can't be empty", this);
        }
        if (this.prices.isEmpty()) {
            throw new TelegramApiValidationException("Prices parameter can't be empty", this);
        }
        for (LabeledPrice price : this.prices) {
            price.validate();
        }
        if (this.suggestedTipAmounts != null && !this.suggestedTipAmounts.isEmpty() && this.suggestedTipAmounts.size() > 4) {
            throw new TelegramApiValidationException("No more that 4 suggested tips allowed", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
    }

    @Generated
    protected SendInvoice(SendInvoiceBuilder<?, ?> b) {
        super((BotApiMethodMessage.BotApiMethodMessageBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageThreadId = b.messageThreadId;
        this.title = b.title;
        if (this.title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.description = b.description;
        if (this.description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.payload = b.payload;
        if (this.payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        this.providerToken = b.providerToken;
        this.startParameter = b.startParameter;
        this.currency = b.currency;
        if (this.currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        List<Object> prices = switch (b.prices == null ? 0 : b.prices.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.prices.get(0));
            default -> Collections.unmodifiableList(new ArrayList<LabeledPrice>(b.prices));
        };
        this.prices = prices;
        if (prices == null) {
            throw new NullPointerException("prices is marked non-null but is null");
        }
        this.photoUrl = b.photoUrl;
        this.photoSize = b.photoSize;
        this.photoWidth = b.photoWidth;
        this.photoHeight = b.photoHeight;
        this.needName = b.needName;
        this.needPhoneNumber = b.needPhoneNumber;
        this.needEmail = b.needEmail;
        this.needShippingAddress = b.needShippingAddress;
        this.isFlexible = b.isFlexible;
        this.disableNotification = b.disableNotification;
        this.replyToMessageId = b.replyToMessageId;
        this.sendPhoneNumberToProvider = b.sendPhoneNumberToProvider;
        this.sendEmailToProvider = b.sendEmailToProvider;
        this.replyMarkup = b.replyMarkup;
        this.providerData = b.providerData;
        this.allowSendingWithoutReply = b.allowSendingWithoutReply;
        this.maxTipAmount = b.maxTipAmount;
        this.suggestedTipAmounts = switch (b.suggestedTipAmounts == null ? 0 : b.suggestedTipAmounts.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.suggestedTipAmounts.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Integer>(b.suggestedTipAmounts));
        };
        this.protectContent = b.protectContent;
        this.replyParameters = b.replyParameters;
        this.messageEffectId = b.messageEffectId;
        this.allowPaidBroadcast = b.allowPaidBroadcast;
    }

    @Generated
    public static SendInvoiceBuilder<?, ?> builder() {
        return new SendInvoiceBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendInvoice)) {
            return false;
        }
        SendInvoice other = (SendInvoice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Integer this$photoSize = this.getPhotoSize();
        Integer other$photoSize = other.getPhotoSize();
        if (this$photoSize == null ? other$photoSize != null : !((Object)this$photoSize).equals(other$photoSize)) {
            return false;
        }
        Integer this$photoWidth = this.getPhotoWidth();
        Integer other$photoWidth = other.getPhotoWidth();
        if (this$photoWidth == null ? other$photoWidth != null : !((Object)this$photoWidth).equals(other$photoWidth)) {
            return false;
        }
        Integer this$photoHeight = this.getPhotoHeight();
        Integer other$photoHeight = other.getPhotoHeight();
        if (this$photoHeight == null ? other$photoHeight != null : !((Object)this$photoHeight).equals(other$photoHeight)) {
            return false;
        }
        Boolean this$needName = this.getNeedName();
        Boolean other$needName = other.getNeedName();
        if (this$needName == null ? other$needName != null : !((Object)this$needName).equals(other$needName)) {
            return false;
        }
        Boolean this$needPhoneNumber = this.getNeedPhoneNumber();
        Boolean other$needPhoneNumber = other.getNeedPhoneNumber();
        if (this$needPhoneNumber == null ? other$needPhoneNumber != null : !((Object)this$needPhoneNumber).equals(other$needPhoneNumber)) {
            return false;
        }
        Boolean this$needEmail = this.getNeedEmail();
        Boolean other$needEmail = other.getNeedEmail();
        if (this$needEmail == null ? other$needEmail != null : !((Object)this$needEmail).equals(other$needEmail)) {
            return false;
        }
        Boolean this$needShippingAddress = this.getNeedShippingAddress();
        Boolean other$needShippingAddress = other.getNeedShippingAddress();
        if (this$needShippingAddress == null ? other$needShippingAddress != null : !((Object)this$needShippingAddress).equals(other$needShippingAddress)) {
            return false;
        }
        Boolean this$isFlexible = this.getIsFlexible();
        Boolean other$isFlexible = other.getIsFlexible();
        if (this$isFlexible == null ? other$isFlexible != null : !((Object)this$isFlexible).equals(other$isFlexible)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Boolean this$sendPhoneNumberToProvider = this.getSendPhoneNumberToProvider();
        Boolean other$sendPhoneNumberToProvider = other.getSendPhoneNumberToProvider();
        if (this$sendPhoneNumberToProvider == null ? other$sendPhoneNumberToProvider != null : !((Object)this$sendPhoneNumberToProvider).equals(other$sendPhoneNumberToProvider)) {
            return false;
        }
        Boolean this$sendEmailToProvider = this.getSendEmailToProvider();
        Boolean other$sendEmailToProvider = other.getSendEmailToProvider();
        if (this$sendEmailToProvider == null ? other$sendEmailToProvider != null : !((Object)this$sendEmailToProvider).equals(other$sendEmailToProvider)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Integer this$maxTipAmount = this.getMaxTipAmount();
        Integer other$maxTipAmount = other.getMaxTipAmount();
        if (this$maxTipAmount == null ? other$maxTipAmount != null : !((Object)this$maxTipAmount).equals(other$maxTipAmount)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        Boolean this$allowPaidBroadcast = this.getAllowPaidBroadcast();
        Boolean other$allowPaidBroadcast = other.getAllowPaidBroadcast();
        if (this$allowPaidBroadcast == null ? other$allowPaidBroadcast != null : !((Object)this$allowPaidBroadcast).equals(other$allowPaidBroadcast)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$payload = this.getPayload();
        String other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        String this$providerToken = this.getProviderToken();
        String other$providerToken = other.getProviderToken();
        if (this$providerToken == null ? other$providerToken != null : !this$providerToken.equals(other$providerToken)) {
            return false;
        }
        String this$startParameter = this.getStartParameter();
        String other$startParameter = other.getStartParameter();
        if (this$startParameter == null ? other$startParameter != null : !this$startParameter.equals(other$startParameter)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        List<LabeledPrice> this$prices = this.getPrices();
        List<LabeledPrice> other$prices = other.getPrices();
        if (this$prices == null ? other$prices != null : !((Object)this$prices).equals(other$prices)) {
            return false;
        }
        String this$photoUrl = this.getPhotoUrl();
        String other$photoUrl = other.getPhotoUrl();
        if (this$photoUrl == null ? other$photoUrl != null : !this$photoUrl.equals(other$photoUrl)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        String this$providerData = this.getProviderData();
        String other$providerData = other.getProviderData();
        if (this$providerData == null ? other$providerData != null : !this$providerData.equals(other$providerData)) {
            return false;
        }
        List<Integer> this$suggestedTipAmounts = this.getSuggestedTipAmounts();
        List<Integer> other$suggestedTipAmounts = other.getSuggestedTipAmounts();
        if (this$suggestedTipAmounts == null ? other$suggestedTipAmounts != null : !((Object)this$suggestedTipAmounts).equals(other$suggestedTipAmounts)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        if (this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters)) {
            return false;
        }
        String this$messageEffectId = this.getMessageEffectId();
        String other$messageEffectId = other.getMessageEffectId();
        return !(this$messageEffectId == null ? other$messageEffectId != null : !this$messageEffectId.equals(other$messageEffectId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SendInvoice;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Integer $photoSize = this.getPhotoSize();
        result = result * 59 + ($photoSize == null ? 43 : ((Object)$photoSize).hashCode());
        Integer $photoWidth = this.getPhotoWidth();
        result = result * 59 + ($photoWidth == null ? 43 : ((Object)$photoWidth).hashCode());
        Integer $photoHeight = this.getPhotoHeight();
        result = result * 59 + ($photoHeight == null ? 43 : ((Object)$photoHeight).hashCode());
        Boolean $needName = this.getNeedName();
        result = result * 59 + ($needName == null ? 43 : ((Object)$needName).hashCode());
        Boolean $needPhoneNumber = this.getNeedPhoneNumber();
        result = result * 59 + ($needPhoneNumber == null ? 43 : ((Object)$needPhoneNumber).hashCode());
        Boolean $needEmail = this.getNeedEmail();
        result = result * 59 + ($needEmail == null ? 43 : ((Object)$needEmail).hashCode());
        Boolean $needShippingAddress = this.getNeedShippingAddress();
        result = result * 59 + ($needShippingAddress == null ? 43 : ((Object)$needShippingAddress).hashCode());
        Boolean $isFlexible = this.getIsFlexible();
        result = result * 59 + ($isFlexible == null ? 43 : ((Object)$isFlexible).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Boolean $sendPhoneNumberToProvider = this.getSendPhoneNumberToProvider();
        result = result * 59 + ($sendPhoneNumberToProvider == null ? 43 : ((Object)$sendPhoneNumberToProvider).hashCode());
        Boolean $sendEmailToProvider = this.getSendEmailToProvider();
        result = result * 59 + ($sendEmailToProvider == null ? 43 : ((Object)$sendEmailToProvider).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Integer $maxTipAmount = this.getMaxTipAmount();
        result = result * 59 + ($maxTipAmount == null ? 43 : ((Object)$maxTipAmount).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        Boolean $allowPaidBroadcast = this.getAllowPaidBroadcast();
        result = result * 59 + ($allowPaidBroadcast == null ? 43 : ((Object)$allowPaidBroadcast).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        String $providerToken = this.getProviderToken();
        result = result * 59 + ($providerToken == null ? 43 : $providerToken.hashCode());
        String $startParameter = this.getStartParameter();
        result = result * 59 + ($startParameter == null ? 43 : $startParameter.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        List<LabeledPrice> $prices = this.getPrices();
        result = result * 59 + ($prices == null ? 43 : ((Object)$prices).hashCode());
        String $photoUrl = this.getPhotoUrl();
        result = result * 59 + ($photoUrl == null ? 43 : $photoUrl.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        String $providerData = this.getProviderData();
        result = result * 59 + ($providerData == null ? 43 : $providerData.hashCode());
        List<Integer> $suggestedTipAmounts = this.getSuggestedTipAmounts();
        result = result * 59 + ($suggestedTipAmounts == null ? 43 : ((Object)$suggestedTipAmounts).hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        String $messageEffectId = this.getMessageEffectId();
        result = result * 59 + ($messageEffectId == null ? 43 : $messageEffectId.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @Generated
    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    @Generated
    public String getTitle() {
        return this.title;
    }

    @NonNull
    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String getPayload() {
        return this.payload;
    }

    @Generated
    public String getProviderToken() {
        return this.providerToken;
    }

    @Generated
    public String getStartParameter() {
        return this.startParameter;
    }

    @NonNull
    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @NonNull
    @Generated
    public List<LabeledPrice> getPrices() {
        return this.prices;
    }

    @Generated
    public String getPhotoUrl() {
        return this.photoUrl;
    }

    @Generated
    public Integer getPhotoSize() {
        return this.photoSize;
    }

    @Generated
    public Integer getPhotoWidth() {
        return this.photoWidth;
    }

    @Generated
    public Integer getPhotoHeight() {
        return this.photoHeight;
    }

    @Generated
    public Boolean getNeedName() {
        return this.needName;
    }

    @Generated
    public Boolean getNeedPhoneNumber() {
        return this.needPhoneNumber;
    }

    @Generated
    public Boolean getNeedEmail() {
        return this.needEmail;
    }

    @Generated
    public Boolean getNeedShippingAddress() {
        return this.needShippingAddress;
    }

    @Generated
    public Boolean getIsFlexible() {
        return this.isFlexible;
    }

    @Generated
    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    @Generated
    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    @Generated
    public Boolean getSendPhoneNumberToProvider() {
        return this.sendPhoneNumberToProvider;
    }

    @Generated
    public Boolean getSendEmailToProvider() {
        return this.sendEmailToProvider;
    }

    @Generated
    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Generated
    public String getProviderData() {
        return this.providerData;
    }

    @Generated
    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    @Generated
    public Integer getMaxTipAmount() {
        return this.maxTipAmount;
    }

    @Generated
    public List<Integer> getSuggestedTipAmounts() {
        return this.suggestedTipAmounts;
    }

    @Generated
    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @Generated
    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    @Generated
    public String getMessageEffectId() {
        return this.messageEffectId;
    }

    @Generated
    public Boolean getAllowPaidBroadcast() {
        return this.allowPaidBroadcast;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_thread_id")
    @Generated
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @JsonProperty(value="title")
    @Generated
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @JsonProperty(value="description")
    @Generated
    public void setDescription(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = description;
    }

    @JsonProperty(value="payload")
    @Generated
    public void setPayload(@NonNull String payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        this.payload = payload;
    }

    @JsonProperty(value="provider_token")
    @Generated
    public void setProviderToken(String providerToken) {
        this.providerToken = providerToken;
    }

    @JsonProperty(value="start_parameter")
    @Generated
    public void setStartParameter(String startParameter) {
        this.startParameter = startParameter;
    }

    @JsonProperty(value="currency")
    @Generated
    public void setCurrency(@NonNull String currency) {
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        this.currency = currency;
    }

    @JsonProperty(value="prices")
    @Generated
    public void setPrices(@NonNull List<LabeledPrice> prices) {
        if (prices == null) {
            throw new NullPointerException("prices is marked non-null but is null");
        }
        this.prices = prices;
    }

    @JsonProperty(value="photo_url")
    @Generated
    public void setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
    }

    @JsonProperty(value="photo_size")
    @Generated
    public void setPhotoSize(Integer photoSize) {
        this.photoSize = photoSize;
    }

    @JsonProperty(value="photo_width")
    @Generated
    public void setPhotoWidth(Integer photoWidth) {
        this.photoWidth = photoWidth;
    }

    @JsonProperty(value="photo_height")
    @Generated
    public void setPhotoHeight(Integer photoHeight) {
        this.photoHeight = photoHeight;
    }

    @JsonProperty(value="need_name")
    @Generated
    public void setNeedName(Boolean needName) {
        this.needName = needName;
    }

    @JsonProperty(value="need_phone_number")
    @Generated
    public void setNeedPhoneNumber(Boolean needPhoneNumber) {
        this.needPhoneNumber = needPhoneNumber;
    }

    @JsonProperty(value="need_email")
    @Generated
    public void setNeedEmail(Boolean needEmail) {
        this.needEmail = needEmail;
    }

    @JsonProperty(value="need_shipping_address")
    @Generated
    public void setNeedShippingAddress(Boolean needShippingAddress) {
        this.needShippingAddress = needShippingAddress;
    }

    @JsonProperty(value="is_flexible")
    @Generated
    public void setIsFlexible(Boolean isFlexible) {
        this.isFlexible = isFlexible;
    }

    @JsonProperty(value="disable_notification")
    @Generated
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @JsonProperty(value="reply_to_message_id")
    @Generated
    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    @JsonProperty(value="send_phone_number_to_provider")
    @Generated
    public void setSendPhoneNumberToProvider(Boolean sendPhoneNumberToProvider) {
        this.sendPhoneNumberToProvider = sendPhoneNumberToProvider;
    }

    @JsonProperty(value="send_email_to_provider")
    @Generated
    public void setSendEmailToProvider(Boolean sendEmailToProvider) {
        this.sendEmailToProvider = sendEmailToProvider;
    }

    @JsonProperty(value="reply_markup")
    @Generated
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="provider_data")
    @Generated
    public void setProviderData(String providerData) {
        this.providerData = providerData;
    }

    @JsonProperty(value="allow_sending_without_reply")
    @Generated
    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    @JsonProperty(value="max_tip_amount")
    @Generated
    public void setMaxTipAmount(Integer maxTipAmount) {
        this.maxTipAmount = maxTipAmount;
    }

    @JsonProperty(value="suggested_tip_amounts")
    @Generated
    public void setSuggestedTipAmounts(List<Integer> suggestedTipAmounts) {
        this.suggestedTipAmounts = suggestedTipAmounts;
    }

    @JsonProperty(value="protect_content")
    @Generated
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    @JsonProperty(value="reply_parameters")
    @Generated
    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    @JsonProperty(value="message_effect_id")
    @Generated
    public void setMessageEffectId(String messageEffectId) {
        this.messageEffectId = messageEffectId;
    }

    @JsonProperty(value="allow_paid_broadcast")
    @Generated
    public void setAllowPaidBroadcast(Boolean allowPaidBroadcast) {
        this.allowPaidBroadcast = allowPaidBroadcast;
    }

    @Generated
    public String toString() {
        return "SendInvoice(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", payload=" + this.getPayload() + ", providerToken=" + this.getProviderToken() + ", startParameter=" + this.getStartParameter() + ", currency=" + this.getCurrency() + ", prices=" + this.getPrices() + ", photoUrl=" + this.getPhotoUrl() + ", photoSize=" + this.getPhotoSize() + ", photoWidth=" + this.getPhotoWidth() + ", photoHeight=" + this.getPhotoHeight() + ", needName=" + this.getNeedName() + ", needPhoneNumber=" + this.getNeedPhoneNumber() + ", needEmail=" + this.getNeedEmail() + ", needShippingAddress=" + this.getNeedShippingAddress() + ", isFlexible=" + this.getIsFlexible() + ", disableNotification=" + this.getDisableNotification() + ", replyToMessageId=" + this.getReplyToMessageId() + ", sendPhoneNumberToProvider=" + this.getSendPhoneNumberToProvider() + ", sendEmailToProvider=" + this.getSendEmailToProvider() + ", replyMarkup=" + this.getReplyMarkup() + ", providerData=" + this.getProviderData() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", maxTipAmount=" + this.getMaxTipAmount() + ", suggestedTipAmounts=" + this.getSuggestedTipAmounts() + ", protectContent=" + this.getProtectContent() + ", replyParameters=" + this.getReplyParameters() + ", messageEffectId=" + this.getMessageEffectId() + ", allowPaidBroadcast=" + this.getAllowPaidBroadcast() + ")";
    }

    @Generated
    public SendInvoice(@NonNull String chatId, @NonNull String title, @NonNull String description, @NonNull String payload, @NonNull String currency, @NonNull List<LabeledPrice> prices) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        if (prices == null) {
            throw new NullPointerException("prices is marked non-null but is null");
        }
        this.chatId = chatId;
        this.title = title;
        this.description = description;
        this.payload = payload;
        this.currency = currency;
        this.prices = prices;
    }

    @Generated
    public SendInvoice(@NonNull String chatId, Integer messageThreadId, @NonNull String title, @NonNull String description, @NonNull String payload, String providerToken, String startParameter, @NonNull String currency, @NonNull List<LabeledPrice> prices, String photoUrl, Integer photoSize, Integer photoWidth, Integer photoHeight, Boolean needName, Boolean needPhoneNumber, Boolean needEmail, Boolean needShippingAddress, Boolean isFlexible, Boolean disableNotification, Integer replyToMessageId, Boolean sendPhoneNumberToProvider, Boolean sendEmailToProvider, InlineKeyboardMarkup replyMarkup, String providerData, Boolean allowSendingWithoutReply, Integer maxTipAmount, List<Integer> suggestedTipAmounts, Boolean protectContent, ReplyParameters replyParameters, String messageEffectId, Boolean allowPaidBroadcast) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        if (prices == null) {
            throw new NullPointerException("prices is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.title = title;
        this.description = description;
        this.payload = payload;
        this.providerToken = providerToken;
        this.startParameter = startParameter;
        this.currency = currency;
        this.prices = prices;
        this.photoUrl = photoUrl;
        this.photoSize = photoSize;
        this.photoWidth = photoWidth;
        this.photoHeight = photoHeight;
        this.needName = needName;
        this.needPhoneNumber = needPhoneNumber;
        this.needEmail = needEmail;
        this.needShippingAddress = needShippingAddress;
        this.isFlexible = isFlexible;
        this.disableNotification = disableNotification;
        this.replyToMessageId = replyToMessageId;
        this.sendPhoneNumberToProvider = sendPhoneNumberToProvider;
        this.sendEmailToProvider = sendEmailToProvider;
        this.replyMarkup = replyMarkup;
        this.providerData = providerData;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.maxTipAmount = maxTipAmount;
        this.suggestedTipAmounts = suggestedTipAmounts;
        this.protectContent = protectContent;
        this.replyParameters = replyParameters;
        this.messageEffectId = messageEffectId;
        this.allowPaidBroadcast = allowPaidBroadcast;
    }

    public static abstract class SendInvoiceBuilder<C extends SendInvoice, B extends SendInvoiceBuilder<C, B>>
    extends BotApiMethodMessage.BotApiMethodMessageBuilder<C, B> {
        @Generated
        private String chatId;
        @Generated
        private Integer messageThreadId;
        @Generated
        private String title;
        @Generated
        private String description;
        @Generated
        private String payload;
        @Generated
        private String providerToken;
        @Generated
        private String startParameter;
        @Generated
        private String currency;
        @Generated
        private ArrayList<LabeledPrice> prices;
        @Generated
        private String photoUrl;
        @Generated
        private Integer photoSize;
        @Generated
        private Integer photoWidth;
        @Generated
        private Integer photoHeight;
        @Generated
        private Boolean needName;
        @Generated
        private Boolean needPhoneNumber;
        @Generated
        private Boolean needEmail;
        @Generated
        private Boolean needShippingAddress;
        @Generated
        private Boolean isFlexible;
        @Generated
        private Boolean disableNotification;
        @Generated
        private Integer replyToMessageId;
        @Generated
        private Boolean sendPhoneNumberToProvider;
        @Generated
        private Boolean sendEmailToProvider;
        @Generated
        private InlineKeyboardMarkup replyMarkup;
        @Generated
        private String providerData;
        @Generated
        private Boolean allowSendingWithoutReply;
        @Generated
        private Integer maxTipAmount;
        @Generated
        private ArrayList<Integer> suggestedTipAmounts;
        @Generated
        private Boolean protectContent;
        @Generated
        private ReplyParameters replyParameters;
        @Generated
        private String messageEffectId;
        @Generated
        private Boolean allowPaidBroadcast;

        public SendInvoiceBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_thread_id")
        @Generated
        public B messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return (B)this.self();
        }

        @JsonProperty(value="title")
        @Generated
        public B title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return (B)this.self();
        }

        @JsonProperty(value="description")
        @Generated
        public B description(@NonNull String description) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.description = description;
            return (B)this.self();
        }

        @JsonProperty(value="payload")
        @Generated
        public B payload(@NonNull String payload) {
            if (payload == null) {
                throw new NullPointerException("payload is marked non-null but is null");
            }
            this.payload = payload;
            return (B)this.self();
        }

        @JsonProperty(value="provider_token")
        @Generated
        public B providerToken(String providerToken) {
            this.providerToken = providerToken;
            return (B)this.self();
        }

        @JsonProperty(value="start_parameter")
        @Generated
        public B startParameter(String startParameter) {
            this.startParameter = startParameter;
            return (B)this.self();
        }

        @JsonProperty(value="currency")
        @Generated
        public B currency(@NonNull String currency) {
            if (currency == null) {
                throw new NullPointerException("currency is marked non-null but is null");
            }
            this.currency = currency;
            return (B)this.self();
        }

        @Generated
        public B price(LabeledPrice price) {
            if (this.prices == null) {
                this.prices = new ArrayList();
            }
            this.prices.add(price);
            return (B)this.self();
        }

        @JsonProperty(value="prices")
        @Generated
        public B prices(Collection<? extends LabeledPrice> prices) {
            if (prices == null) {
                throw new NullPointerException("prices cannot be null");
            }
            if (this.prices == null) {
                this.prices = new ArrayList();
            }
            this.prices.addAll(prices);
            return (B)this.self();
        }

        @Generated
        public B clearPrices() {
            if (this.prices != null) {
                this.prices.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="photo_url")
        @Generated
        public B photoUrl(String photoUrl) {
            this.photoUrl = photoUrl;
            return (B)this.self();
        }

        @JsonProperty(value="photo_size")
        @Generated
        public B photoSize(Integer photoSize) {
            this.photoSize = photoSize;
            return (B)this.self();
        }

        @JsonProperty(value="photo_width")
        @Generated
        public B photoWidth(Integer photoWidth) {
            this.photoWidth = photoWidth;
            return (B)this.self();
        }

        @JsonProperty(value="photo_height")
        @Generated
        public B photoHeight(Integer photoHeight) {
            this.photoHeight = photoHeight;
            return (B)this.self();
        }

        @JsonProperty(value="need_name")
        @Generated
        public B needName(Boolean needName) {
            this.needName = needName;
            return (B)this.self();
        }

        @JsonProperty(value="need_phone_number")
        @Generated
        public B needPhoneNumber(Boolean needPhoneNumber) {
            this.needPhoneNumber = needPhoneNumber;
            return (B)this.self();
        }

        @JsonProperty(value="need_email")
        @Generated
        public B needEmail(Boolean needEmail) {
            this.needEmail = needEmail;
            return (B)this.self();
        }

        @JsonProperty(value="need_shipping_address")
        @Generated
        public B needShippingAddress(Boolean needShippingAddress) {
            this.needShippingAddress = needShippingAddress;
            return (B)this.self();
        }

        @JsonProperty(value="is_flexible")
        @Generated
        public B isFlexible(Boolean isFlexible) {
            this.isFlexible = isFlexible;
            return (B)this.self();
        }

        @JsonProperty(value="disable_notification")
        @Generated
        public B disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return (B)this.self();
        }

        @JsonProperty(value="reply_to_message_id")
        @Generated
        public B replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return (B)this.self();
        }

        @JsonProperty(value="send_phone_number_to_provider")
        @Generated
        public B sendPhoneNumberToProvider(Boolean sendPhoneNumberToProvider) {
            this.sendPhoneNumberToProvider = sendPhoneNumberToProvider;
            return (B)this.self();
        }

        @JsonProperty(value="send_email_to_provider")
        @Generated
        public B sendEmailToProvider(Boolean sendEmailToProvider) {
            this.sendEmailToProvider = sendEmailToProvider;
            return (B)this.self();
        }

        @JsonProperty(value="reply_markup")
        @Generated
        public B replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        @JsonProperty(value="provider_data")
        @Generated
        public B providerData(String providerData) {
            this.providerData = providerData;
            return (B)this.self();
        }

        @JsonProperty(value="allow_sending_without_reply")
        @Generated
        public B allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return (B)this.self();
        }

        @JsonProperty(value="max_tip_amount")
        @Generated
        public B maxTipAmount(Integer maxTipAmount) {
            this.maxTipAmount = maxTipAmount;
            return (B)this.self();
        }

        @Generated
        public B suggestedTipAmount(Integer suggestedTipAmount) {
            if (this.suggestedTipAmounts == null) {
                this.suggestedTipAmounts = new ArrayList();
            }
            this.suggestedTipAmounts.add(suggestedTipAmount);
            return (B)this.self();
        }

        @JsonProperty(value="suggested_tip_amounts")
        @Generated
        public B suggestedTipAmounts(Collection<? extends Integer> suggestedTipAmounts) {
            if (suggestedTipAmounts == null) {
                throw new NullPointerException("suggestedTipAmounts cannot be null");
            }
            if (this.suggestedTipAmounts == null) {
                this.suggestedTipAmounts = new ArrayList();
            }
            this.suggestedTipAmounts.addAll(suggestedTipAmounts);
            return (B)this.self();
        }

        @Generated
        public B clearSuggestedTipAmounts() {
            if (this.suggestedTipAmounts != null) {
                this.suggestedTipAmounts.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="protect_content")
        @Generated
        public B protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return (B)this.self();
        }

        @JsonProperty(value="reply_parameters")
        @Generated
        public B replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return (B)this.self();
        }

        @JsonProperty(value="message_effect_id")
        @Generated
        public B messageEffectId(String messageEffectId) {
            this.messageEffectId = messageEffectId;
            return (B)this.self();
        }

        @JsonProperty(value="allow_paid_broadcast")
        @Generated
        public B allowPaidBroadcast(Boolean allowPaidBroadcast) {
            this.allowPaidBroadcast = allowPaidBroadcast;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SendInvoice.SendInvoiceBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", title=" + this.title + ", description=" + this.description + ", payload=" + this.payload + ", providerToken=" + this.providerToken + ", startParameter=" + this.startParameter + ", currency=" + this.currency + ", prices=" + this.prices + ", photoUrl=" + this.photoUrl + ", photoSize=" + this.photoSize + ", photoWidth=" + this.photoWidth + ", photoHeight=" + this.photoHeight + ", needName=" + this.needName + ", needPhoneNumber=" + this.needPhoneNumber + ", needEmail=" + this.needEmail + ", needShippingAddress=" + this.needShippingAddress + ", isFlexible=" + this.isFlexible + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", sendPhoneNumberToProvider=" + this.sendPhoneNumberToProvider + ", sendEmailToProvider=" + this.sendEmailToProvider + ", replyMarkup=" + this.replyMarkup + ", providerData=" + this.providerData + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", maxTipAmount=" + this.maxTipAmount + ", suggestedTipAmounts=" + this.suggestedTipAmounts + ", protectContent=" + this.protectContent + ", replyParameters=" + this.replyParameters + ", messageEffectId=" + this.messageEffectId + ", allowPaidBroadcast=" + this.allowPaidBroadcast + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SendInvoiceBuilderImpl
    extends SendInvoiceBuilder<SendInvoice, SendInvoiceBuilderImpl> {
        @Generated
        private SendInvoiceBuilderImpl() {
        }

        @Override
        @Generated
        protected SendInvoiceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SendInvoice build() {
            return new SendInvoice(this);
        }
    }
}

