/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=SetStickerKeywordsBuilderImpl.class)
public class SetStickerKeywords
extends BotApiMethodBoolean {
    public static final String PATH = "setStickerKeywords";
    public static final String STICKER_FIELD = "sticker";
    public static final String KEYWORDS_FIELD = "keywords";
    @JsonProperty(value="sticker")
    @NonNull
    private String sticker;
    @JsonProperty(value="keywords")
    private List<String> keywords;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.sticker.isEmpty()) {
            throw new TelegramApiValidationException("sticker can't be null", this);
        }
        if (this.keywords != null && this.keywords.size() > 20) {
            throw new TelegramApiValidationException("Keywords list must have between 0 and 20 items", this);
        }
    }

    @Generated
    protected SetStickerKeywords(SetStickerKeywordsBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.sticker = b.sticker;
        if (this.sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.keywords = switch (b.keywords == null ? 0 : b.keywords.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.keywords.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.keywords));
        };
    }

    @Generated
    public static SetStickerKeywordsBuilder<?, ?> builder() {
        return new SetStickerKeywordsBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetStickerKeywords)) {
            return false;
        }
        SetStickerKeywords other = (SetStickerKeywords)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sticker = this.getSticker();
        String other$sticker = other.getSticker();
        if (this$sticker == null ? other$sticker != null : !this$sticker.equals(other$sticker)) {
            return false;
        }
        List<String> this$keywords = this.getKeywords();
        List<String> other$keywords = other.getKeywords();
        return !(this$keywords == null ? other$keywords != null : !((Object)this$keywords).equals(other$keywords));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetStickerKeywords;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sticker = this.getSticker();
        result = result * 59 + ($sticker == null ? 43 : $sticker.hashCode());
        List<String> $keywords = this.getKeywords();
        result = result * 59 + ($keywords == null ? 43 : ((Object)$keywords).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getSticker() {
        return this.sticker;
    }

    @Generated
    public List<String> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="sticker")
    @Generated
    public void setSticker(@NonNull String sticker) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.sticker = sticker;
    }

    @JsonProperty(value="keywords")
    @Generated
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    @Generated
    public String toString() {
        return "SetStickerKeywords(sticker=" + this.getSticker() + ", keywords=" + this.getKeywords() + ")";
    }

    @Generated
    public SetStickerKeywords(@NonNull String sticker) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.sticker = sticker;
    }

    @Generated
    public SetStickerKeywords(@NonNull String sticker, List<String> keywords) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.sticker = sticker;
        this.keywords = keywords;
    }

    @Generated
    public static abstract class SetStickerKeywordsBuilder<C extends SetStickerKeywords, B extends SetStickerKeywordsBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        @Generated
        private String sticker;
        @Generated
        private ArrayList<String> keywords;

        @JsonProperty(value="sticker")
        @Generated
        public B sticker(@NonNull String sticker) {
            if (sticker == null) {
                throw new NullPointerException("sticker is marked non-null but is null");
            }
            this.sticker = sticker;
            return (B)this.self();
        }

        @Generated
        public B keyword(String keyword) {
            if (this.keywords == null) {
                this.keywords = new ArrayList();
            }
            this.keywords.add(keyword);
            return (B)this.self();
        }

        @JsonProperty(value="keywords")
        @Generated
        public B keywords(Collection<? extends String> keywords) {
            if (keywords == null) {
                throw new NullPointerException("keywords cannot be null");
            }
            if (this.keywords == null) {
                this.keywords = new ArrayList();
            }
            this.keywords.addAll(keywords);
            return (B)this.self();
        }

        @Generated
        public B clearKeywords() {
            if (this.keywords != null) {
                this.keywords.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SetStickerKeywords.SetStickerKeywordsBuilder(super=" + super.toString() + ", sticker=" + this.sticker + ", keywords=" + this.keywords + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SetStickerKeywordsBuilderImpl
    extends SetStickerKeywordsBuilder<SetStickerKeywords, SetStickerKeywordsBuilderImpl> {
        @Generated
        private SetStickerKeywordsBuilderImpl() {
        }

        @Override
        @Generated
        protected SetStickerKeywordsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SetStickerKeywords build() {
            return new SetStickerKeywords(this);
        }
    }
}

