/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.File;
import java.io.InputStream;
import lombok.Generated;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.InputFileSerializer;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonSerialize(using=InputFileSerializer.class, as=String.class)
public class InputFile
implements Validable,
BotApiObject {
    private String attachName;
    @JsonIgnore
    private String mediaName;
    @JsonIgnore
    private File newMediaFile;
    @JsonIgnore
    private InputStream newMediaStream;
    @JsonIgnore
    private boolean isNew;

    public InputFile(String attachName) {
        this();
        this.setMedia(attachName);
    }

    public InputFile(File mediaFile) {
        this();
        this.setMedia(mediaFile, mediaFile.getName());
    }

    public InputFile(File mediaFile, String fileName) {
        this();
        this.setMedia(mediaFile, fileName);
    }

    public InputFile(InputStream mediaStream, String fileName) {
        this();
        this.setMedia(mediaStream, fileName);
    }

    public InputFile setMedia(File mediaFile, String fileName) {
        this.newMediaFile = mediaFile;
        this.mediaName = fileName;
        this.attachName = "attach://" + fileName;
        this.isNew = true;
        return this;
    }

    public InputFile setMedia(File mediaFile) {
        this.newMediaFile = mediaFile;
        this.mediaName = mediaFile.getName();
        this.attachName = "attach://" + mediaFile.getName();
        this.isNew = true;
        return this;
    }

    public InputFile setMedia(InputStream mediaStream, String fileName) {
        this.newMediaStream = mediaStream;
        this.mediaName = fileName;
        this.attachName = "attach://" + fileName;
        this.isNew = true;
        return this;
    }

    public InputFile setMedia(String attachName) {
        this.attachName = attachName;
        this.isNew = false;
        return this;
    }

    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.isNew) {
            if (this.mediaName == null || this.mediaName.isEmpty()) {
                throw new TelegramApiValidationException("Media name can't be empty", this);
            }
            if (this.newMediaFile == null && this.newMediaStream == null) {
                throw new TelegramApiValidationException("Media can't be empty", this);
            }
        } else if (this.attachName == null || this.attachName.isEmpty()) {
            throw new TelegramApiValidationException("File_id can't be empty", this);
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputFile)) {
            return false;
        }
        InputFile other = (InputFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNew() != other.isNew()) {
            return false;
        }
        String this$attachName = this.getAttachName();
        String other$attachName = other.getAttachName();
        if (this$attachName == null ? other$attachName != null : !this$attachName.equals(other$attachName)) {
            return false;
        }
        String this$mediaName = this.getMediaName();
        String other$mediaName = other.getMediaName();
        if (this$mediaName == null ? other$mediaName != null : !this$mediaName.equals(other$mediaName)) {
            return false;
        }
        File this$newMediaFile = this.getNewMediaFile();
        File other$newMediaFile = other.getNewMediaFile();
        if (this$newMediaFile == null ? other$newMediaFile != null : !((Object)this$newMediaFile).equals(other$newMediaFile)) {
            return false;
        }
        InputStream this$newMediaStream = this.getNewMediaStream();
        InputStream other$newMediaStream = other.getNewMediaStream();
        return !(this$newMediaStream == null ? other$newMediaStream != null : !this$newMediaStream.equals(other$newMediaStream));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputFile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNew() ? 79 : 97);
        String $attachName = this.getAttachName();
        result = result * 59 + ($attachName == null ? 43 : $attachName.hashCode());
        String $mediaName = this.getMediaName();
        result = result * 59 + ($mediaName == null ? 43 : $mediaName.hashCode());
        File $newMediaFile = this.getNewMediaFile();
        result = result * 59 + ($newMediaFile == null ? 43 : ((Object)$newMediaFile).hashCode());
        InputStream $newMediaStream = this.getNewMediaStream();
        result = result * 59 + ($newMediaStream == null ? 43 : $newMediaStream.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputFile(attachName=" + this.getAttachName() + ", mediaName=" + this.getMediaName() + ", newMediaFile=" + this.getNewMediaFile() + ", newMediaStream=" + this.getNewMediaStream() + ", isNew=" + this.isNew() + ")";
    }

    @Generated
    public InputFile() {
    }

    @Generated
    public InputFile(String attachName, String mediaName, File newMediaFile, InputStream newMediaStream, boolean isNew) {
        this.attachName = attachName;
        this.mediaName = mediaName;
        this.newMediaFile = newMediaFile;
        this.newMediaStream = newMediaStream;
        this.isNew = isNew;
    }

    @Generated
    public String getAttachName() {
        return this.attachName;
    }

    @Generated
    public String getMediaName() {
        return this.mediaName;
    }

    @Generated
    public File getNewMediaFile() {
        return this.newMediaFile;
    }

    @Generated
    public InputStream getNewMediaStream() {
        return this.newMediaStream;
    }
}

