/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InlineQueryResultLocationBuilderImpl.class)
public class InlineQueryResultLocation
implements InlineQueryResult {
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String TITLE_FIELD = "title";
    private static final String LATITUDE_FIELD = "latitude";
    private static final String LONGITUDE_FIELD = "longitude";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String THUMBNAIL_URL_FIELD = "thumbnail_url";
    private static final String THUMBNAIL_WIDTH_FIELD = "thumbnail_width";
    private static final String THUMBNAUK_HEIGHT_FIELD = "thumbnail_height";
    private static final String LIVE_PERIOD_FIELD = "live_period";
    private static final String HORIZONTALACCURACY_FIELD = "horizontal_accuracy";
    private static final String HEADING_FIELD = "heading";
    private static final String PROXIMITYALERTRADIUS_FIELD = "proximity_alert_radius";
    @JsonProperty(value="type")
    private final String type = "location";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="title")
    @NonNull
    private String title;
    @JsonProperty(value="latitude")
    @NonNull
    private Float latitude;
    @JsonProperty(value="longitude")
    @NonNull
    private Float longitude;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="thumbnail_url")
    private String thumbnailUrl;
    @JsonProperty(value="thumbnail_width")
    private Integer thumbnailWidth;
    @JsonProperty(value="thumbnail_height")
    private Integer thumbnailHeight;
    @JsonProperty(value="live_period")
    private Integer livePeriod;
    @JsonProperty(value="horizontal_accuracy")
    private Double horizontalAccuracy;
    @JsonProperty(value="heading")
    private Integer heading;
    @JsonProperty(value="proximity_alert_radius")
    private Integer proximityAlertRadius;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.title.isEmpty()) {
            throw new TelegramApiValidationException("Title parameter can't be empty", this);
        }
        if (this.livePeriod != null && (this.livePeriod < 60 || this.livePeriod > 86400) && this.livePeriod != Integer.MAX_VALUE) {
            throw new TelegramApiValidationException("Live period parameter must be between 60 and 86400 or be 0x7FFFFFFF", this);
        }
        if (this.horizontalAccuracy != null && (this.horizontalAccuracy < 0.0 || this.horizontalAccuracy > 1500.0)) {
            throw new TelegramApiValidationException("Horizontal Accuracy parameter must be between 0 and 1500", this);
        }
        if (this.heading != null && (this.heading < 1 || this.heading > 360)) {
            throw new TelegramApiValidationException("Heading Accuracy parameter must be between 1 and 360", this);
        }
        if (this.proximityAlertRadius != null && (this.proximityAlertRadius < 1 || this.proximityAlertRadius > 100000)) {
            throw new TelegramApiValidationException("Approaching notification distance parameter must be between 1 and 100000", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    @Generated
    protected InlineQueryResultLocation(InlineQueryResultLocationBuilder<?, ?> b) {
        this.id = b.id;
        if (this.id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.title = b.title;
        if (this.title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.latitude = b.latitude;
        if (this.latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        this.longitude = b.longitude;
        if (this.longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.replyMarkup = b.replyMarkup;
        this.inputMessageContent = b.inputMessageContent;
        this.thumbnailUrl = b.thumbnailUrl;
        this.thumbnailWidth = b.thumbnailWidth;
        this.thumbnailHeight = b.thumbnailHeight;
        this.livePeriod = b.livePeriod;
        this.horizontalAccuracy = b.horizontalAccuracy;
        this.heading = b.heading;
        this.proximityAlertRadius = b.proximityAlertRadius;
    }

    @Generated
    public static InlineQueryResultLocationBuilder<?, ?> builder() {
        return new InlineQueryResultLocationBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultLocation)) {
            return false;
        }
        InlineQueryResultLocation other = (InlineQueryResultLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$latitude = this.getLatitude();
        Float other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Float this$longitude = this.getLongitude();
        Float other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Integer this$thumbnailWidth = this.getThumbnailWidth();
        Integer other$thumbnailWidth = other.getThumbnailWidth();
        if (this$thumbnailWidth == null ? other$thumbnailWidth != null : !((Object)this$thumbnailWidth).equals(other$thumbnailWidth)) {
            return false;
        }
        Integer this$thumbnailHeight = this.getThumbnailHeight();
        Integer other$thumbnailHeight = other.getThumbnailHeight();
        if (this$thumbnailHeight == null ? other$thumbnailHeight != null : !((Object)this$thumbnailHeight).equals(other$thumbnailHeight)) {
            return false;
        }
        Integer this$livePeriod = this.getLivePeriod();
        Integer other$livePeriod = other.getLivePeriod();
        if (this$livePeriod == null ? other$livePeriod != null : !((Object)this$livePeriod).equals(other$livePeriod)) {
            return false;
        }
        Double this$horizontalAccuracy = this.getHorizontalAccuracy();
        Double other$horizontalAccuracy = other.getHorizontalAccuracy();
        if (this$horizontalAccuracy == null ? other$horizontalAccuracy != null : !((Object)this$horizontalAccuracy).equals(other$horizontalAccuracy)) {
            return false;
        }
        Integer this$heading = this.getHeading();
        Integer other$heading = other.getHeading();
        if (this$heading == null ? other$heading != null : !((Object)this$heading).equals(other$heading)) {
            return false;
        }
        Integer this$proximityAlertRadius = this.getProximityAlertRadius();
        Integer other$proximityAlertRadius = other.getProximityAlertRadius();
        if (this$proximityAlertRadius == null ? other$proximityAlertRadius != null : !((Object)this$proximityAlertRadius).equals(other$proximityAlertRadius)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        InputMessageContent this$inputMessageContent = this.getInputMessageContent();
        InputMessageContent other$inputMessageContent = other.getInputMessageContent();
        if (this$inputMessageContent == null ? other$inputMessageContent != null : !this$inputMessageContent.equals(other$inputMessageContent)) {
            return false;
        }
        String this$thumbnailUrl = this.getThumbnailUrl();
        String other$thumbnailUrl = other.getThumbnailUrl();
        return !(this$thumbnailUrl == null ? other$thumbnailUrl != null : !this$thumbnailUrl.equals(other$thumbnailUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultLocation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Float $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Integer $thumbnailWidth = this.getThumbnailWidth();
        result = result * 59 + ($thumbnailWidth == null ? 43 : ((Object)$thumbnailWidth).hashCode());
        Integer $thumbnailHeight = this.getThumbnailHeight();
        result = result * 59 + ($thumbnailHeight == null ? 43 : ((Object)$thumbnailHeight).hashCode());
        Integer $livePeriod = this.getLivePeriod();
        result = result * 59 + ($livePeriod == null ? 43 : ((Object)$livePeriod).hashCode());
        Double $horizontalAccuracy = this.getHorizontalAccuracy();
        result = result * 59 + ($horizontalAccuracy == null ? 43 : ((Object)$horizontalAccuracy).hashCode());
        Integer $heading = this.getHeading();
        result = result * 59 + ($heading == null ? 43 : ((Object)$heading).hashCode());
        Integer $proximityAlertRadius = this.getProximityAlertRadius();
        result = result * 59 + ($proximityAlertRadius == null ? 43 : ((Object)$proximityAlertRadius).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        InputMessageContent $inputMessageContent = this.getInputMessageContent();
        result = result * 59 + ($inputMessageContent == null ? 43 : $inputMessageContent.hashCode());
        String $thumbnailUrl = this.getThumbnailUrl();
        result = result * 59 + ($thumbnailUrl == null ? 43 : $thumbnailUrl.hashCode());
        return result;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getTitle() {
        return this.title;
    }

    @NonNull
    @Generated
    public Float getLatitude() {
        return this.latitude;
    }

    @NonNull
    @Generated
    public Float getLongitude() {
        return this.longitude;
    }

    @Generated
    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Generated
    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    @Generated
    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    @Generated
    public Integer getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    @Generated
    public Integer getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    @Generated
    public Integer getLivePeriod() {
        return this.livePeriod;
    }

    @Generated
    public Double getHorizontalAccuracy() {
        return this.horizontalAccuracy;
    }

    @Generated
    public Integer getHeading() {
        return this.heading;
    }

    @Generated
    public Integer getProximityAlertRadius() {
        return this.proximityAlertRadius;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="title")
    @Generated
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @JsonProperty(value="latitude")
    @Generated
    public void setLatitude(@NonNull Float latitude) {
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        this.latitude = latitude;
    }

    @JsonProperty(value="longitude")
    @Generated
    public void setLongitude(@NonNull Float longitude) {
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.longitude = longitude;
    }

    @JsonProperty(value="reply_markup")
    @Generated
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="input_message_content")
    @Generated
    public void setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
    }

    @JsonProperty(value="thumbnail_url")
    @Generated
    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    @JsonProperty(value="thumbnail_width")
    @Generated
    public void setThumbnailWidth(Integer thumbnailWidth) {
        this.thumbnailWidth = thumbnailWidth;
    }

    @JsonProperty(value="thumbnail_height")
    @Generated
    public void setThumbnailHeight(Integer thumbnailHeight) {
        this.thumbnailHeight = thumbnailHeight;
    }

    @JsonProperty(value="live_period")
    @Generated
    public void setLivePeriod(Integer livePeriod) {
        this.livePeriod = livePeriod;
    }

    @JsonProperty(value="horizontal_accuracy")
    @Generated
    public void setHorizontalAccuracy(Double horizontalAccuracy) {
        this.horizontalAccuracy = horizontalAccuracy;
    }

    @JsonProperty(value="heading")
    @Generated
    public void setHeading(Integer heading) {
        this.heading = heading;
    }

    @JsonProperty(value="proximity_alert_radius")
    @Generated
    public void setProximityAlertRadius(Integer proximityAlertRadius) {
        this.proximityAlertRadius = proximityAlertRadius;
    }

    @Generated
    public String toString() {
        return "InlineQueryResultLocation(type=" + this.getType() + ", id=" + this.getId() + ", title=" + this.getTitle() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", replyMarkup=" + this.getReplyMarkup() + ", inputMessageContent=" + this.getInputMessageContent() + ", thumbnailUrl=" + this.getThumbnailUrl() + ", thumbnailWidth=" + this.getThumbnailWidth() + ", thumbnailHeight=" + this.getThumbnailHeight() + ", livePeriod=" + this.getLivePeriod() + ", horizontalAccuracy=" + this.getHorizontalAccuracy() + ", heading=" + this.getHeading() + ", proximityAlertRadius=" + this.getProximityAlertRadius() + ")";
    }

    @Generated
    public InlineQueryResultLocation(@NonNull String id, @NonNull String title, @NonNull Float latitude, @NonNull Float longitude) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.id = id;
        this.title = title;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @Generated
    public InlineQueryResultLocation(@NonNull String id, @NonNull String title, @NonNull Float latitude, @NonNull Float longitude, InlineKeyboardMarkup replyMarkup, InputMessageContent inputMessageContent, String thumbnailUrl, Integer thumbnailWidth, Integer thumbnailHeight, Integer livePeriod, Double horizontalAccuracy, Integer heading, Integer proximityAlertRadius) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.id = id;
        this.title = title;
        this.latitude = latitude;
        this.longitude = longitude;
        this.replyMarkup = replyMarkup;
        this.inputMessageContent = inputMessageContent;
        this.thumbnailUrl = thumbnailUrl;
        this.thumbnailWidth = thumbnailWidth;
        this.thumbnailHeight = thumbnailHeight;
        this.livePeriod = livePeriod;
        this.horizontalAccuracy = horizontalAccuracy;
        this.heading = heading;
        this.proximityAlertRadius = proximityAlertRadius;
    }

    @Generated
    public static abstract class InlineQueryResultLocationBuilder<C extends InlineQueryResultLocation, B extends InlineQueryResultLocationBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String title;
        @Generated
        private Float latitude;
        @Generated
        private Float longitude;
        @Generated
        private InlineKeyboardMarkup replyMarkup;
        @Generated
        private InputMessageContent inputMessageContent;
        @Generated
        private String thumbnailUrl;
        @Generated
        private Integer thumbnailWidth;
        @Generated
        private Integer thumbnailHeight;
        @Generated
        private Integer livePeriod;
        @Generated
        private Double horizontalAccuracy;
        @Generated
        private Integer heading;
        @Generated
        private Integer proximityAlertRadius;

        @JsonProperty(value="id")
        @Generated
        public B id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this.self();
        }

        @JsonProperty(value="title")
        @Generated
        public B title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this.self();
        }

        @JsonProperty(value="latitude")
        @Generated
        public B latitude(@NonNull Float latitude) {
            if (latitude == null) {
                throw new NullPointerException("latitude is marked non-null but is null");
            }
            this.latitude = latitude;
            return this.self();
        }

        @JsonProperty(value="longitude")
        @Generated
        public B longitude(@NonNull Float longitude) {
            if (longitude == null) {
                throw new NullPointerException("longitude is marked non-null but is null");
            }
            this.longitude = longitude;
            return this.self();
        }

        @JsonProperty(value="reply_markup")
        @Generated
        public B replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this.self();
        }

        @JsonProperty(value="input_message_content")
        @Generated
        public B inputMessageContent(InputMessageContent inputMessageContent) {
            this.inputMessageContent = inputMessageContent;
            return this.self();
        }

        @JsonProperty(value="thumbnail_url")
        @Generated
        public B thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this.self();
        }

        @JsonProperty(value="thumbnail_width")
        @Generated
        public B thumbnailWidth(Integer thumbnailWidth) {
            this.thumbnailWidth = thumbnailWidth;
            return this.self();
        }

        @JsonProperty(value="thumbnail_height")
        @Generated
        public B thumbnailHeight(Integer thumbnailHeight) {
            this.thumbnailHeight = thumbnailHeight;
            return this.self();
        }

        @JsonProperty(value="live_period")
        @Generated
        public B livePeriod(Integer livePeriod) {
            this.livePeriod = livePeriod;
            return this.self();
        }

        @JsonProperty(value="horizontal_accuracy")
        @Generated
        public B horizontalAccuracy(Double horizontalAccuracy) {
            this.horizontalAccuracy = horizontalAccuracy;
            return this.self();
        }

        @JsonProperty(value="heading")
        @Generated
        public B heading(Integer heading) {
            this.heading = heading;
            return this.self();
        }

        @JsonProperty(value="proximity_alert_radius")
        @Generated
        public B proximityAlertRadius(Integer proximityAlertRadius) {
            this.proximityAlertRadius = proximityAlertRadius;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "InlineQueryResultLocation.InlineQueryResultLocationBuilder(id=" + this.id + ", title=" + this.title + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", replyMarkup=" + this.replyMarkup + ", inputMessageContent=" + this.inputMessageContent + ", thumbnailUrl=" + this.thumbnailUrl + ", thumbnailWidth=" + this.thumbnailWidth + ", thumbnailHeight=" + this.thumbnailHeight + ", livePeriod=" + this.livePeriod + ", horizontalAccuracy=" + this.horizontalAccuracy + ", heading=" + this.heading + ", proximityAlertRadius=" + this.proximityAlertRadius + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class InlineQueryResultLocationBuilderImpl
    extends InlineQueryResultLocationBuilder<InlineQueryResultLocation, InlineQueryResultLocationBuilderImpl> {
        @Generated
        private InlineQueryResultLocationBuilderImpl() {
        }

        @Override
        @Generated
        protected InlineQueryResultLocationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InlineQueryResultLocation build() {
            return new InlineQueryResultLocation(this);
        }
    }
}

