/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result.cached;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InlineQueryResultCachedAudioBuilderImpl.class)
public class InlineQueryResultCachedAudio
implements InlineQueryResult {
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String AUDIO_FILE_ID_FIELD = "audio_file_id";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String CAPTION_FIELD = "caption";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    @JsonProperty(value="type")
    private final String type = "audio";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="audio_file_id")
    @NonNull
    private String audioFileId;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.audioFileId.isEmpty()) {
            throw new TelegramApiValidationException("AudioFileId parameter can't be empty", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    @Generated
    protected InlineQueryResultCachedAudio(InlineQueryResultCachedAudioBuilder<?, ?> b) {
        this.id = b.id;
        if (this.id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.audioFileId = b.audioFileId;
        if (this.audioFileId == null) {
            throw new NullPointerException("audioFileId is marked non-null but is null");
        }
        this.inputMessageContent = b.inputMessageContent;
        this.replyMarkup = b.replyMarkup;
        this.caption = b.caption;
        this.parseMode = b.parseMode;
        this.captionEntities = switch (b.captionEntities == null ? 0 : b.captionEntities.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.captionEntities.get(0));
            default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(b.captionEntities));
        };
    }

    @Generated
    public static InlineQueryResultCachedAudioBuilder<?, ?> builder() {
        return new InlineQueryResultCachedAudioBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultCachedAudio)) {
            return false;
        }
        InlineQueryResultCachedAudio other = (InlineQueryResultCachedAudio)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$audioFileId = this.getAudioFileId();
        String other$audioFileId = other.getAudioFileId();
        if (this$audioFileId == null ? other$audioFileId != null : !this$audioFileId.equals(other$audioFileId)) {
            return false;
        }
        InputMessageContent this$inputMessageContent = this.getInputMessageContent();
        InputMessageContent other$inputMessageContent = other.getInputMessageContent();
        if (this$inputMessageContent == null ? other$inputMessageContent != null : !this$inputMessageContent.equals(other$inputMessageContent)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        return !(this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultCachedAudio;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $audioFileId = this.getAudioFileId();
        result = result * 59 + ($audioFileId == null ? 43 : $audioFileId.hashCode());
        InputMessageContent $inputMessageContent = this.getInputMessageContent();
        result = result * 59 + ($inputMessageContent == null ? 43 : $inputMessageContent.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        return result;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getAudioFileId() {
        return this.audioFileId;
    }

    @Generated
    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    @Generated
    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Generated
    public String getCaption() {
        return this.caption;
    }

    @Generated
    public String getParseMode() {
        return this.parseMode;
    }

    @Generated
    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="audio_file_id")
    @Generated
    public void setAudioFileId(@NonNull String audioFileId) {
        if (audioFileId == null) {
            throw new NullPointerException("audioFileId is marked non-null but is null");
        }
        this.audioFileId = audioFileId;
    }

    @JsonProperty(value="input_message_content")
    @Generated
    public void setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
    }

    @JsonProperty(value="reply_markup")
    @Generated
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="caption")
    @Generated
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="parse_mode")
    @Generated
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    @Generated
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    @Generated
    public String toString() {
        return "InlineQueryResultCachedAudio(type=" + this.getType() + ", id=" + this.getId() + ", audioFileId=" + this.getAudioFileId() + ", inputMessageContent=" + this.getInputMessageContent() + ", replyMarkup=" + this.getReplyMarkup() + ", caption=" + this.getCaption() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ")";
    }

    @Generated
    public InlineQueryResultCachedAudio(@NonNull String id, @NonNull String audioFileId) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (audioFileId == null) {
            throw new NullPointerException("audioFileId is marked non-null but is null");
        }
        this.id = id;
        this.audioFileId = audioFileId;
    }

    @Generated
    public InlineQueryResultCachedAudio(@NonNull String id, @NonNull String audioFileId, InputMessageContent inputMessageContent, InlineKeyboardMarkup replyMarkup, String caption, String parseMode, List<MessageEntity> captionEntities) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (audioFileId == null) {
            throw new NullPointerException("audioFileId is marked non-null but is null");
        }
        this.id = id;
        this.audioFileId = audioFileId;
        this.inputMessageContent = inputMessageContent;
        this.replyMarkup = replyMarkup;
        this.caption = caption;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
    }

    @Generated
    public static abstract class InlineQueryResultCachedAudioBuilder<C extends InlineQueryResultCachedAudio, B extends InlineQueryResultCachedAudioBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String audioFileId;
        @Generated
        private InputMessageContent inputMessageContent;
        @Generated
        private InlineKeyboardMarkup replyMarkup;
        @Generated
        private String caption;
        @Generated
        private String parseMode;
        @Generated
        private ArrayList<MessageEntity> captionEntities;

        @JsonProperty(value="id")
        @Generated
        public B id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this.self();
        }

        @JsonProperty(value="audio_file_id")
        @Generated
        public B audioFileId(@NonNull String audioFileId) {
            if (audioFileId == null) {
                throw new NullPointerException("audioFileId is marked non-null but is null");
            }
            this.audioFileId = audioFileId;
            return this.self();
        }

        @JsonProperty(value="input_message_content")
        @Generated
        public B inputMessageContent(InputMessageContent inputMessageContent) {
            this.inputMessageContent = inputMessageContent;
            return this.self();
        }

        @JsonProperty(value="reply_markup")
        @Generated
        public B replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this.self();
        }

        @JsonProperty(value="caption")
        @Generated
        public B caption(String caption) {
            this.caption = caption;
            return this.self();
        }

        @JsonProperty(value="parse_mode")
        @Generated
        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this.self();
        }

        @Generated
        public B captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this.self();
        }

        @JsonProperty(value="caption_entities")
        @Generated
        public B captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this.self();
        }

        @Generated
        public B clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "InlineQueryResultCachedAudio.InlineQueryResultCachedAudioBuilder(id=" + this.id + ", audioFileId=" + this.audioFileId + ", inputMessageContent=" + this.inputMessageContent + ", replyMarkup=" + this.replyMarkup + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class InlineQueryResultCachedAudioBuilderImpl
    extends InlineQueryResultCachedAudioBuilder<InlineQueryResultCachedAudio, InlineQueryResultCachedAudioBuilderImpl> {
        @Generated
        private InlineQueryResultCachedAudioBuilderImpl() {
        }

        @Override
        @Generated
        protected InlineQueryResultCachedAudioBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InlineQueryResultCachedAudio build() {
            return new InlineQueryResultCachedAudio(this);
        }
    }
}

