/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.menubutton;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.menubutton.MenuButton;
import org.telegram.telegrambots.meta.api.objects.webapp.WebAppInfo;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=MenuButtonWebAppBuilderImpl.class)
public class MenuButtonWebApp
extends MenuButton {
    private static final String TYPE = "web_app";
    public static final String TEXT_FIELD = "text";
    public static final String WEBAPP_FIELD = "web_app";
    @JsonProperty(value="text")
    @NonNull
    private String text;
    @JsonProperty(value="web_app")
    @NonNull
    private WebAppInfo webAppInfo;

    @Override
    public void validate() throws TelegramApiValidationException {
        super.validate();
        if (this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text can't be empty", this);
        }
        this.webAppInfo.validate();
    }

    @Override
    public String getType() {
        return "web_app";
    }

    @Generated
    protected MenuButtonWebApp(MenuButtonWebAppBuilder<?, ?> b) {
        super(b);
        this.text = b.text;
        if (this.text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.webAppInfo = b.webAppInfo;
        if (this.webAppInfo == null) {
            throw new NullPointerException("webAppInfo is marked non-null but is null");
        }
    }

    @Generated
    public static MenuButtonWebAppBuilder<?, ?> builder() {
        return new MenuButtonWebAppBuilderImpl();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MenuButtonWebApp)) {
            return false;
        }
        MenuButtonWebApp other = (MenuButtonWebApp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        WebAppInfo this$webAppInfo = this.getWebAppInfo();
        WebAppInfo other$webAppInfo = other.getWebAppInfo();
        return !(this$webAppInfo == null ? other$webAppInfo != null : !((Object)this$webAppInfo).equals(other$webAppInfo));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MenuButtonWebApp;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        WebAppInfo $webAppInfo = this.getWebAppInfo();
        result = result * 59 + ($webAppInfo == null ? 43 : ((Object)$webAppInfo).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getText() {
        return this.text;
    }

    @NonNull
    @Generated
    public WebAppInfo getWebAppInfo() {
        return this.webAppInfo;
    }

    @JsonProperty(value="text")
    @Generated
    public void setText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @JsonProperty(value="web_app")
    @Generated
    public void setWebAppInfo(@NonNull WebAppInfo webAppInfo) {
        if (webAppInfo == null) {
            throw new NullPointerException("webAppInfo is marked non-null but is null");
        }
        this.webAppInfo = webAppInfo;
    }

    @Override
    @Generated
    public String toString() {
        return "MenuButtonWebApp(text=" + this.getText() + ", webAppInfo=" + this.getWebAppInfo() + ")";
    }

    @Generated
    public MenuButtonWebApp(@NonNull String text, @NonNull WebAppInfo webAppInfo) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (webAppInfo == null) {
            throw new NullPointerException("webAppInfo is marked non-null but is null");
        }
        this.text = text;
        this.webAppInfo = webAppInfo;
    }

    @Generated
    public static abstract class MenuButtonWebAppBuilder<C extends MenuButtonWebApp, B extends MenuButtonWebAppBuilder<C, B>>
    extends MenuButton.MenuButtonBuilder<C, B> {
        @Generated
        private String text;
        @Generated
        private WebAppInfo webAppInfo;

        @JsonProperty(value="text")
        @Generated
        public B text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return (B)this.self();
        }

        @JsonProperty(value="web_app")
        @Generated
        public B webAppInfo(@NonNull WebAppInfo webAppInfo) {
            if (webAppInfo == null) {
                throw new NullPointerException("webAppInfo is marked non-null but is null");
            }
            this.webAppInfo = webAppInfo;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "MenuButtonWebApp.MenuButtonWebAppBuilder(super=" + super.toString() + ", text=" + this.text + ", webAppInfo=" + this.webAppInfo + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class MenuButtonWebAppBuilderImpl
    extends MenuButtonWebAppBuilder<MenuButtonWebApp, MenuButtonWebAppBuilderImpl> {
        @Generated
        private MenuButtonWebAppBuilderImpl() {
        }

        @Override
        @Generated
        protected MenuButtonWebAppBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MenuButtonWebApp build() {
            return new MenuButtonWebApp(this);
        }
    }
}

