/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.passport.dataerror;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.passport.dataerror.PassportElementError;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=PassportElementErrorTranslationFilesBuilderImpl.class)
public class PassportElementErrorTranslationFiles
implements PassportElementError {
    private static final String SOURCE_FIELD = "source";
    private static final String TYPE_FIELD = "type";
    private static final String FILEHASHES_FIELD = "file_hashes";
    private static final String MESSAGE_FIELD = "message";
    @JsonProperty(value="source")
    @NonNull
    private final String source;
    @JsonProperty(value="type")
    @NonNull
    private String type;
    @JsonProperty(value="file_hashes")
    @NonNull
    private List<String> fileHashes;
    @JsonProperty(value="message")
    @NonNull
    private String message;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.fileHashes.isEmpty()) {
            throw new TelegramApiValidationException("File hash parameter can't be empty", this);
        }
        if (this.message.isEmpty()) {
            throw new TelegramApiValidationException("Message parameter can't be empty", this);
        }
        if (this.type.isEmpty()) {
            throw new TelegramApiValidationException("Type parameter can't be empty", this);
        }
    }

    @Generated
    private static String $default$source() {
        return "translation_files";
    }

    @Generated
    protected PassportElementErrorTranslationFiles(PassportElementErrorTranslationFilesBuilder<?, ?> b) {
        this.source = b.source$set ? b.source$value : PassportElementErrorTranslationFiles.$default$source();
        if (this.source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        this.type = b.type;
        if (this.type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        List<Object> fileHashes = switch (b.fileHashes == null ? 0 : b.fileHashes.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.fileHashes.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.fileHashes));
        };
        this.fileHashes = fileHashes;
        if (fileHashes == null) {
            throw new NullPointerException("fileHashes is marked non-null but is null");
        }
        this.message = b.message;
        if (this.message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
    }

    @Generated
    public static PassportElementErrorTranslationFilesBuilder<?, ?> builder() {
        return new PassportElementErrorTranslationFilesBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PassportElementErrorTranslationFiles)) {
            return false;
        }
        PassportElementErrorTranslationFiles other = (PassportElementErrorTranslationFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<String> this$fileHashes = this.getFileHashes();
        List<String> other$fileHashes = other.getFileHashes();
        if (this$fileHashes == null ? other$fileHashes != null : !((Object)this$fileHashes).equals(other$fileHashes)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PassportElementErrorTranslationFiles;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<String> $fileHashes = this.getFileHashes();
        result = result * 59 + ($fileHashes == null ? 43 : ((Object)$fileHashes).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getSource() {
        return this.source;
    }

    @NonNull
    @Generated
    public String getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public List<String> getFileHashes() {
        return this.fileHashes;
    }

    @NonNull
    @Generated
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="type")
    @Generated
    public void setType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="file_hashes")
    @Generated
    public void setFileHashes(@NonNull List<String> fileHashes) {
        if (fileHashes == null) {
            throw new NullPointerException("fileHashes is marked non-null but is null");
        }
        this.fileHashes = fileHashes;
    }

    @JsonProperty(value="message")
    @Generated
    public void setMessage(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.message = message;
    }

    @Generated
    public String toString() {
        return "PassportElementErrorTranslationFiles(source=" + this.getSource() + ", type=" + this.getType() + ", fileHashes=" + this.getFileHashes() + ", message=" + this.getMessage() + ")";
    }

    @Generated
    public PassportElementErrorTranslationFiles(@NonNull String source2, @NonNull String type, @NonNull List<String> fileHashes, @NonNull String message) {
        if (source2 == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (fileHashes == null) {
            throw new NullPointerException("fileHashes is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.source = source2;
        this.type = type;
        this.fileHashes = fileHashes;
        this.message = message;
    }

    @Generated
    public static abstract class PassportElementErrorTranslationFilesBuilder<C extends PassportElementErrorTranslationFiles, B extends PassportElementErrorTranslationFilesBuilder<C, B>> {
        @Generated
        private boolean source$set;
        @Generated
        private String source$value;
        @Generated
        private String type;
        @Generated
        private ArrayList<String> fileHashes;
        @Generated
        private String message;

        @JsonProperty(value="source")
        @Generated
        public B source(@NonNull String source2) {
            if (source2 == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.source$value = source2;
            this.source$set = true;
            return this.self();
        }

        @JsonProperty(value="type")
        @Generated
        public B type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this.self();
        }

        @Generated
        public B fileHash(String fileHash) {
            if (this.fileHashes == null) {
                this.fileHashes = new ArrayList();
            }
            this.fileHashes.add(fileHash);
            return this.self();
        }

        @JsonProperty(value="file_hashes")
        @Generated
        public B fileHashes(Collection<? extends String> fileHashes) {
            if (fileHashes == null) {
                throw new NullPointerException("fileHashes cannot be null");
            }
            if (this.fileHashes == null) {
                this.fileHashes = new ArrayList();
            }
            this.fileHashes.addAll(fileHashes);
            return this.self();
        }

        @Generated
        public B clearFileHashes() {
            if (this.fileHashes != null) {
                this.fileHashes.clear();
            }
            return this.self();
        }

        @JsonProperty(value="message")
        @Generated
        public B message(@NonNull String message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "PassportElementErrorTranslationFiles.PassportElementErrorTranslationFilesBuilder(source$value=" + this.source$value + ", type=" + this.type + ", fileHashes=" + this.fileHashes + ", message=" + this.message + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class PassportElementErrorTranslationFilesBuilderImpl
    extends PassportElementErrorTranslationFilesBuilder<PassportElementErrorTranslationFiles, PassportElementErrorTranslationFilesBuilderImpl> {
        @Generated
        private PassportElementErrorTranslationFilesBuilderImpl() {
        }

        @Override
        @Generated
        protected PassportElementErrorTranslationFilesBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PassportElementErrorTranslationFiles build() {
            return new PassportElementErrorTranslationFiles(this);
        }
    }
}

