/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.polls.input;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InputPollOptionBuilderImpl.class)
public class InputPollOption
implements BotApiObject,
Validable {
    private static final String TEXT_FIELD = "text";
    private static final String TEXT_PARSE_MODE_FIELD = "text_parse_mode";
    private static final String TEXT_ENTITIES_FIELD = "text_entities";
    @JsonProperty(value="text")
    @NonNull
    private String text;
    @JsonProperty(value="text_parse_mode")
    private String textParseMode;
    @JsonProperty(value="text_entities")
    private List<MessageEntity> textEntities;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.text.isEmpty() || this.text.length() > 100) {
            throw new TelegramApiValidationException("Text must be between 1 and 100 characters", this);
        }
        if (this.textParseMode != null && this.textEntities != null) {
            throw new TelegramApiValidationException("Parse Mode and Entities can\u00b4t be used together", this);
        }
    }

    @Generated
    protected InputPollOption(InputPollOptionBuilder<?, ?> b) {
        this.text = b.text;
        if (this.text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.textParseMode = b.textParseMode;
        this.textEntities = switch (b.textEntities == null ? 0 : b.textEntities.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.textEntities.get(0));
            default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(b.textEntities));
        };
    }

    @Generated
    public static InputPollOptionBuilder<?, ?> builder() {
        return new InputPollOptionBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputPollOption)) {
            return false;
        }
        InputPollOption other = (InputPollOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$textParseMode = this.getTextParseMode();
        String other$textParseMode = other.getTextParseMode();
        if (this$textParseMode == null ? other$textParseMode != null : !this$textParseMode.equals(other$textParseMode)) {
            return false;
        }
        List<MessageEntity> this$textEntities = this.getTextEntities();
        List<MessageEntity> other$textEntities = other.getTextEntities();
        return !(this$textEntities == null ? other$textEntities != null : !((Object)this$textEntities).equals(other$textEntities));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputPollOption;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $textParseMode = this.getTextParseMode();
        result = result * 59 + ($textParseMode == null ? 43 : $textParseMode.hashCode());
        List<MessageEntity> $textEntities = this.getTextEntities();
        result = result * 59 + ($textEntities == null ? 43 : ((Object)$textEntities).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public String getTextParseMode() {
        return this.textParseMode;
    }

    @Generated
    public List<MessageEntity> getTextEntities() {
        return this.textEntities;
    }

    @JsonProperty(value="text")
    @Generated
    public void setText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @JsonProperty(value="text_parse_mode")
    @Generated
    public void setTextParseMode(String textParseMode) {
        this.textParseMode = textParseMode;
    }

    @JsonProperty(value="text_entities")
    @Generated
    public void setTextEntities(List<MessageEntity> textEntities) {
        this.textEntities = textEntities;
    }

    @Generated
    public String toString() {
        return "InputPollOption(text=" + this.getText() + ", textParseMode=" + this.getTextParseMode() + ", textEntities=" + this.getTextEntities() + ")";
    }

    @Generated
    public InputPollOption(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @Generated
    public InputPollOption(@NonNull String text, String textParseMode, List<MessageEntity> textEntities) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
        this.textParseMode = textParseMode;
        this.textEntities = textEntities;
    }

    @Generated
    public static abstract class InputPollOptionBuilder<C extends InputPollOption, B extends InputPollOptionBuilder<C, B>> {
        @Generated
        private String text;
        @Generated
        private String textParseMode;
        @Generated
        private ArrayList<MessageEntity> textEntities;

        @JsonProperty(value="text")
        @Generated
        public B text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return this.self();
        }

        @JsonProperty(value="text_parse_mode")
        @Generated
        public B textParseMode(String textParseMode) {
            this.textParseMode = textParseMode;
            return this.self();
        }

        @Generated
        public B textEntity(MessageEntity textEntity) {
            if (this.textEntities == null) {
                this.textEntities = new ArrayList();
            }
            this.textEntities.add(textEntity);
            return this.self();
        }

        @JsonProperty(value="text_entities")
        @Generated
        public B textEntities(Collection<? extends MessageEntity> textEntities) {
            if (textEntities == null) {
                throw new NullPointerException("textEntities cannot be null");
            }
            if (this.textEntities == null) {
                this.textEntities = new ArrayList();
            }
            this.textEntities.addAll(textEntities);
            return this.self();
        }

        @Generated
        public B clearTextEntities() {
            if (this.textEntities != null) {
                this.textEntities.clear();
            }
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "InputPollOption.InputPollOptionBuilder(text=" + this.text + ", textParseMode=" + this.textParseMode + ", textEntities=" + this.textEntities + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class InputPollOptionBuilderImpl
    extends InputPollOptionBuilder<InputPollOption, InputPollOptionBuilderImpl> {
        @Generated
        private InputPollOptionBuilderImpl() {
        }

        @Override
        @Generated
        protected InputPollOptionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InputPollOption build() {
            return new InputPollOption(this);
        }
    }
}

