/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.pluginconfig;

import com.google.auto.common.AnnotationMirrors;
import com.google.auto.common.MoreElements;
import com.google.common.collect.ImmutableSet;
import com.ss.android.ugc.bytex.pluginconfig.PropertiesFile;
import com.ss.android.ugc.bytex.pluginconfig.anno.PluginConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class PluginConfigProcessor
extends AbstractProcessor {
    private Map<String, String> plugins = new HashMap<String, String>();

    public ImmutableSet<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)PluginConfig.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            return this.processImpl(annotations, roundEnv);
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.fatalError(writer.toString());
            return true;
        }
    }

    private boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateConfigFiles();
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
        return true;
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(PluginConfig.class);
        for (Element element : elements) {
            TypeElement providerImplementer = (TypeElement)element;
            AnnotationMirror annotationMirror = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)element, PluginConfig.class).get();
            String pluginId = this.getValueFieldOfClasses(annotationMirror);
            if (pluginId == null) {
                this.error("No service interfaces provided for element!", element, annotationMirror);
                continue;
            }
            this.plugins.put(pluginId, this.getBinaryName(providerImplementer));
        }
    }

    private String getBinaryName(TypeElement element) {
        return this.getBinaryNameImpl(element, element.getSimpleName().toString());
    }

    private String getBinaryNameImpl(TypeElement element, String className) {
        Element enclosingElement = element.getEnclosingElement();
        if (enclosingElement instanceof PackageElement) {
            PackageElement pkg = (PackageElement)enclosingElement;
            if (pkg.isUnnamed()) {
                return className;
            }
            return pkg.getQualifiedName() + "." + className;
        }
        TypeElement typeElement = (TypeElement)enclosingElement;
        return this.getBinaryNameImpl(typeElement, typeElement.getSimpleName() + "$" + className);
    }

    private String getValueFieldOfClasses(AnnotationMirror annotationMirror) {
        return this.trim(AnnotationMirrors.getAnnotationValue((AnnotationMirror)annotationMirror, (String)"value").toString());
    }

    private String trim(String source) {
        StringBuilder sb = new StringBuilder();
        if (source.charAt(0) == '\"') {
            for (int i = 0; i < source.length(); ++i) {
                char ch = source.charAt(i);
                if (i == 0 && ch == '\"' || i == source.length() - 1 && ch == '\"') continue;
                sb.append(ch);
            }
        }
        return sb.toString();
    }

    private void generateConfigFiles() {
        Filer filer = this.processingEnv.getFiler();
        for (Map.Entry<String, String> entry : this.plugins.entrySet()) {
            String pluginId = entry.getKey();
            String implement = entry.getValue();
            String resourceFile = PropertiesFile.getPath(pluginId);
            try {
                FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceFile, new Element[0]);
                OutputStream out = fileObject.openOutputStream();
                PropertiesFile.write(implement, out);
                out.close();
            }
            catch (IOException e) {
                this.fatalError("Unable to create " + resourceFile + ", " + e);
                return;
            }
        }
    }

    private void error(String msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element, annotation);
    }

    private void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
    }

    private void log(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }
}

