/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.google.common.reflect.TypeToken;
import com.ss.android.ugc.bytex.common.BaseContext;
import com.ss.android.ugc.bytex.common.BaseExtension;
import com.ss.android.ugc.bytex.common.ByteXExtension;
import com.ss.android.ugc.bytex.common.IPlugin;
import com.ss.android.ugc.bytex.common.SimpleTransform;
import com.ss.android.ugc.bytex.common.builder.internal.GlobalByteXBuildListener;
import com.ss.android.ugc.bytex.common.configuration.BooleanProperty;
import com.ss.android.ugc.bytex.common.configuration.ProjectOptions;
import com.ss.android.ugc.bytex.common.exception.GlobalWhiteListManager;
import com.ss.android.ugc.bytex.common.hook.HookInjector;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import javax.annotation.Nonnull;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.invocation.DefaultGradle;
import org.jetbrains.annotations.NotNull;

public abstract class AbsPlugin<E extends BaseExtension>
implements Plugin<Project>,
IPlugin {
    protected Project project;
    protected AppExtension android;
    protected E extension;
    private boolean isRunningAlone = false;

    protected Transform getTransform() {
        return new SimpleTransform<BaseContext<E>>(new BaseContext<E>(this.project, this.android, this.extension), this);
    }

    @Override
    public String name() {
        return this.extension == null ? this.getClass().getSimpleName() : ((BaseExtension)this.extension).getName();
    }

    @Override
    public BaseExtension getExtension() {
        return this.extension;
    }

    @Override
    public boolean enable(TransformContext transformContext) {
        return ((BaseExtension)this.extension).isEnable() && (((BaseExtension)this.extension).isEnableInDebug() || transformContext.isReleaseBuild());
    }

    @Override
    public boolean alone() {
        boolean alone = false;
        Object aloneProperty = this.project.findProperty("bytex." + ((BaseExtension)this.extension).getName() + ".alone");
        if (aloneProperty != null) {
            alone = Boolean.parseBoolean(aloneProperty.toString());
        }
        if (!alone && !this.transformConfiguration().isIncremental() && BooleanProperty.ENABLE_SEPARATE_PROCESSING_NOTINCREMENTAL.value().booleanValue()) {
            alone = true;
        }
        return alone;
    }

    @Override
    public boolean isRunningAlone() {
        return this.isRunningAlone;
    }

    public final void apply(@NotNull Project project) {
        this.project = project;
        this.android = (AppExtension)project.getExtensions().getByType(AppExtension.class);
        ProjectOptions.INSTANCE.init(project);
        GlobalWhiteListManager.INSTANCE.init(project);
        GlobalByteXBuildListener.INSTANCE.onByteXPluginApply(project, this);
        Class<E> extensionClass = this.getExtensionClass();
        if (extensionClass != null) {
            Instantiator instantiator = (Instantiator)((DefaultGradle)project.getGradle()).getServices().get(Instantiator.class);
            this.extension = this.createExtension(instantiator, extensionClass);
            project.getExtensions().add(((BaseExtension)this.extension).getName(), this.extension);
        }
        this.onApply(project);
        if (this.hookTask()) {
            HookInjector.Companion.obtain(project).inject(this);
        } else if (!this.alone()) {
            try {
                ByteXExtension byteX = (ByteXExtension)project.getExtensions().getByType(ByteXExtension.class);
                byteX.registerPlugin(this);
                this.isRunningAlone = false;
            }
            catch (UnknownDomainObjectException e) {
                this.android.registerTransform(this.getTransform(), new Object[0]);
                this.isRunningAlone = true;
            }
        } else {
            this.android.registerTransform(this.getTransform(), new Object[0]);
            this.isRunningAlone = true;
        }
        GlobalByteXBuildListener.INSTANCE.onByteXPluginApplied(this);
    }

    protected Class<E> getExtensionClass() {
        return new TypeToken<E>(this.getClass()){}.getRawType();
    }

    protected E createExtension(Instantiator instantiator, Class<E> clazz) {
        return (E)((BaseExtension)instantiator.newInstance(clazz, new Object[0]));
    }

    protected void onApply(@Nonnull Project project) {
    }

    @Override
    public void startExecute(TransformContext transformContext) {
        GlobalByteXBuildListener.INSTANCE.onByteXPluginStart(this);
    }

    @Override
    public void afterExecute() throws Throwable {
        GlobalByteXBuildListener.INSTANCE.onByteXPluginFinished(this);
    }
}

