/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.configuration;

import com.google.common.collect.ImmutableMap;
import com.ss.android.ugc.bytex.common.configuration.BooleanProperty;
import com.ss.android.ugc.bytex.common.configuration.Property;
import com.ss.android.ugc.bytex.common.configuration.StringProperty;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.Project;

public enum ProjectOptions {
    INSTANCE;

    private ImmutableMap<BooleanProperty, Boolean> booleanOptions;
    private ImmutableMap<StringProperty, String> stringOptions;

    public void init(Project project) {
        if (this.booleanOptions != null || this.stringOptions != null) {
            return;
        }
        Map properties = project.getExtensions().getExtraProperties().getProperties();
        this.booleanOptions = ProjectOptions.readOptions((Property[])BooleanProperty.values(), (Map)properties);
        this.stringOptions = ProjectOptions.readOptions((Property[])StringProperty.values(), (Map)properties);
        project.getGradle().buildFinished(p -> {
            this.booleanOptions = null;
            this.stringOptions = null;
        });
    }

    private static <OptionT extends Property<ValueT>, ValueT> ImmutableMap<OptionT, ValueT> readOptions(OptionT[] values, Map<String, ?> properties) {
        Map<String, Property> optionLookup = Arrays.stream(values).collect(Collectors.toMap(Property::getPropertyName, v -> v));
        ImmutableMap.Builder valuesBuilder = ImmutableMap.builder();
        for (Map.Entry<String, ?> property : properties.entrySet()) {
            Property option = optionLookup.get(property.getKey());
            if (option == null) continue;
            Object value = option.parse(property.getValue());
            valuesBuilder.put((Object)option, value);
        }
        return valuesBuilder.build();
    }

    boolean getValue(BooleanProperty option) {
        if (this.booleanOptions == null) {
            return option.getDefaultValue();
        }
        return (Boolean)this.booleanOptions.getOrDefault((Object)option, (Object)option.getDefaultValue());
    }

    String getValue(StringProperty option) {
        if (this.stringOptions == null) {
            return option.getDefaultValue();
        }
        return (String)this.stringOptions.getOrDefault((Object)option, (Object)option.getDefaultValue());
    }
}

