/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.exception;

import com.ss.android.ugc.bytex.common.configuration.StringProperty;
import com.ss.android.ugc.bytex.common.white_list.WhiteList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;

public enum GlobalWhiteListManager {
    INSTANCE;

    private WhiteList whiteList = new WhiteList();

    public void init(Project project) {
        if (!this.whiteList.isEmpty()) {
            return;
        }
        this.parseWhiteList(project, StringProperty.EXCEPTION_IGNORE_LIST.value());
        this.parseWhiteList(project, StringProperty.GLOBAL_IGNORE_LIST.value());
        project.getGradle().buildFinished(p -> this.whiteList.clear());
    }

    private void parseWhiteList(Project project, String filePath) {
        File file;
        if (filePath != null && !filePath.isEmpty() && (file = new File(project.getRootDir(), filePath)).isFile()) {
            try {
                List lines = FileUtils.readLines((File)file);
                this.whiteList.initWithWhiteList(lines);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean shouldIgnore(String className) {
        return !this.whiteList.shouldCheck(className);
    }
}

