/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.flow.main;

import com.android.build.api.transform.Status;
import com.ss.android.ugc.bytex.common.flow.AbsTransformFlow;
import com.ss.android.ugc.bytex.common.flow.TransformFlow;
import com.ss.android.ugc.bytex.common.flow.TransformFlowListener;
import com.ss.android.ugc.bytex.common.flow.TransformFlowListenerManager;
import com.ss.android.ugc.bytex.common.flow.main.GlobalMainProcessHandlerListener;
import com.ss.android.ugc.bytex.common.flow.main.IncrementalFileProcessor;
import com.ss.android.ugc.bytex.common.flow.main.MainProcessHandler;
import com.ss.android.ugc.bytex.common.flow.main.MainProcessHandlerContainer;
import com.ss.android.ugc.bytex.common.flow.main.Process;
import com.ss.android.ugc.bytex.common.graph.Graph;
import com.ss.android.ugc.bytex.common.graph.GraphBuilder;
import com.ss.android.ugc.bytex.common.graph.cache.CachedGraphBuilder;
import com.ss.android.ugc.bytex.common.log.Timer;
import com.ss.android.ugc.bytex.common.processor.ClassFileAnalyzer;
import com.ss.android.ugc.bytex.common.processor.ClassFileTransformer;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.ss.android.ugc.bytex.transformer.TransformEngine;
import com.ss.android.ugc.bytex.transformer.concurrent.Schedulers;
import com.ss.android.ugc.bytex.transformer.processor.ClassFileProcessor;
import com.ss.android.ugc.bytex.transformer.processor.FileHandler;
import com.ss.android.ugc.bytex.transformer.processor.FileProcessor;
import com.ss.android.ugc.bytex.transformer.processor.FilterFileProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MainTransformFlow
extends AbsTransformFlow {
    private final MainProcessHandlerContainer handlers = new MainProcessHandlerContainer();
    private Graph mClassGraph;
    private TransformFlowListenerManager listenerManager = new TransformFlowListenerManager();
    private Timer timer = new Timer();

    public MainTransformFlow(TransformEngine transformEngine) {
        super(transformEngine);
    }

    @Override
    public void prepare() throws IOException, InterruptedException {
        try {
            this.listenerManager.startPrepare(this);
            this.prepareInternal();
            this.listenerManager.finishPrepare(this, null);
        }
        catch (Exception e) {
            this.listenerManager.finishPrepare(this, e);
            throw e;
        }
    }

    private void prepareInternal() throws IOException, InterruptedException {
        super.prepare();
        this.markRunningState(TransformContext.State.INITIALIZING);
        this.timer.startRecord("INIT");
        Schedulers.COMPUTATION().submitAndAwait(this.handlers, handler -> handler.init(this.transformEngine));
        this.timer.stopRecord("INIT", "Process init cost time = [%s ms]");
        this.markRunningState(TransformContext.State.INITIALIZED);
        if (!this.isOnePassEnough()) {
            this.markRunningState(TransformContext.State.INCREMENTALTRAVERSING);
            if (this.context.isIncremental()) {
                try {
                    GlobalMainProcessHandlerListener.INSTANCE.startTraverseIncremental(this.handlers);
                    this.timer.startRecord("TRAVERSE_INCREMENTAL");
                    this.traverseArtifactOnly(this.getProcessors(Process.TRAVERSE_INCREMENTAL, new ClassFileAnalyzer(this.context, Process.TRAVERSE_INCREMENTAL, null, new ArrayList<MainProcessHandler>(this.handlers))));
                    this.timer.stopRecord("TRAVERSE_INCREMENTAL", "Process project all .class files cost time = [%s ms]");
                    GlobalMainProcessHandlerListener.INSTANCE.finishTraverseIncremental(this.handlers, null);
                }
                catch (Exception e) {
                    GlobalMainProcessHandlerListener.INSTANCE.finishTraverseIncremental(this.handlers, e);
                    throw e;
                }
            }
            this.markRunningState(TransformContext.State.BEFORETRAVERSE);
            Schedulers.COMPUTATION().submitAndAwait(this.handlers, plugin -> plugin.beforeTraverse(this.transformEngine));
        }
    }

    @Override
    public void run() throws IOException, InterruptedException {
        try {
            this.listenerManager.startRunning(this, this.context.isIncremental());
            this.runTransform();
            this.listenerManager.finishRunning(this, null);
        }
        catch (Exception e) {
            this.listenerManager.finishRunning(this, e);
            throw e;
        }
        finally {
            this.markRunningState(TransformContext.State.STATELESS);
        }
    }

    private void runTransform() throws IOException, InterruptedException {
        this.markRunningState(TransformContext.State.RUNNING);
        if (this.handlers.isEmpty()) {
            return;
        }
        this.timer.startRecord("PRE_PROCESS");
        Schedulers.COMPUTATION().submitAndAwait(this.handlers, plugin -> plugin.startRunning(this.transformEngine));
        if (!this.isOnePassEnough()) {
            this.timer.startRecord("LOADCACHE");
            CachedGraphBuilder graphBuilder = new CachedGraphBuilder(this.getGraphCache(), this.context.isIncremental(), this.context.shouldSaveCache(), !this.context.isDaemonSingleUse());
            if (this.context.isIncremental() && !((GraphBuilder)graphBuilder).isCacheValid()) {
                throw new IllegalStateException("Transform is running as incrementally, but failed to load cache for the transform!");
            }
            this.timer.stopRecord("LOADCACHE", "Process loading cache cost time = [%s ms]");
            this.markRunningState(TransformContext.State.TRANSFORMING);
            try {
                GlobalMainProcessHandlerListener.INSTANCE.startTraverse(this.handlers);
                this.timer.startRecord("PROJECT_CLASS");
                this.traverseArtifactOnly(this.getProcessors(Process.TRAVERSE, new ClassFileAnalyzer(this.context, Process.TRAVERSE, (GraphBuilder)graphBuilder, new ArrayList<MainProcessHandler>(this.handlers))));
                this.timer.stopRecord("PROJECT_CLASS", "Process project all .class files cost time = [%s ms]");
                GlobalMainProcessHandlerListener.INSTANCE.finishTraverse(this.handlers, null);
            }
            catch (Exception e) {
                GlobalMainProcessHandlerListener.INSTANCE.finishTraverse(this.handlers, e);
                throw e;
            }
            try {
                GlobalMainProcessHandlerListener.INSTANCE.startTraverseAndroidJar(this.handlers);
                this.timer.startRecord("ANDROID");
                this.markRunningState(TransformContext.State.TRAVERSINGANDROID);
                this.traverseAndroidJarOnly(this.getProcessors(Process.TRAVERSE_ANDROID, new ClassFileAnalyzer(this.context, Process.TRAVERSE_ANDROID, (GraphBuilder)graphBuilder, new ArrayList<MainProcessHandler>(this.handlers))));
                GlobalMainProcessHandlerListener.INSTANCE.finishTraverseAndroidJar(this.handlers, null);
            }
            catch (Exception e) {
                GlobalMainProcessHandlerListener.INSTANCE.finishTraverseAndroidJar(this.handlers, e);
                throw e;
            }
            this.timer.stopRecord("ANDROID", "Process android jar cost time = [%s ms]");
            this.timer.startRecord("SAVECACHE");
            this.mClassGraph = ((GraphBuilder)graphBuilder).build();
            this.timer.stopRecord("SAVECACHE", "Process saving cache cost time = [%s ms]");
        }
        GlobalMainProcessHandlerListener.INSTANCE.startTransform(this.handlers);
        this.timer.stopRecord("PRE_PROCESS", "Collect info cost time = [%s ms]");
        this.timer.startRecord("PROCESS");
        this.transform(this.getProcessors(Process.TRANSFORM, new ClassFileTransformer(this.context, new ArrayList<MainProcessHandler>(this.handlers), this.needPreVerify(), this.needVerify())));
        this.timer.stopRecord("PROCESS", "Transform cost time = [%s ms]");
    }

    private boolean isOnePassEnough() {
        return this.handlers.stream().allMatch(MainProcessHandler::isOnePassEnough);
    }

    private FileProcessor[] getProcessors(Process process, FileHandler fileHandler) {
        List<FileProcessor> processors = this.handlers.stream().flatMap(handler -> handler.process(process).stream()).collect(Collectors.toList());
        switch (process) {
            case TRAVERSE_INCREMENTAL: {
                processors.add(0, new FilterFileProcessor(fileData -> fileData.getStatus() != Status.NOTCHANGED));
                processors.add(new IncrementalFileProcessor(new ArrayList<MainProcessHandler>(this.handlers), ClassFileProcessor.newInstance(fileHandler)));
                break;
            }
            case TRAVERSE: 
            case TRAVERSE_ANDROID: 
            case TRANSFORM: {
                processors.add(ClassFileProcessor.newInstance(fileHandler));
                processors.add(0, new FilterFileProcessor(fileData -> fileData.getStatus() != Status.NOTCHANGED && fileData.getStatus() != Status.REMOVED));
                break;
            }
            default: {
                throw new RuntimeException("Unknow Process:" + process);
            }
        }
        return processors.toArray(new FileProcessor[0]);
    }

    private boolean needPreVerify() {
        for (MainProcessHandler handler : this.handlers) {
            if (!handler.needPreVerify()) continue;
            return true;
        }
        return false;
    }

    private boolean needVerify() {
        for (MainProcessHandler handler : this.handlers) {
            if (!handler.needVerify()) continue;
            return true;
        }
        return false;
    }

    public final TransformFlow appendHandler(MainProcessHandler handler) {
        this.handlers.add(handler);
        this.listenerManager.onAppendMainProcessHandler(this, handler);
        return this;
    }

    @Override
    protected AbsTransformFlow beforeTransform(TransformEngine transformEngine) throws IOException {
        Schedulers.COMPUTATION().submitAndAwait(this.handlers, plugin -> plugin.beforeTransform(transformEngine));
        return this;
    }

    @Override
    protected AbsTransformFlow transform(TransformEngine transformEngine, boolean isLast, FileProcessor ... processors) throws IOException {
        try {
            GlobalMainProcessHandlerListener.INSTANCE.startTransform(this.handlers);
            AbsTransformFlow result = super.transform(transformEngine, isLast, processors);
            GlobalMainProcessHandlerListener.INSTANCE.finishTransform(this.handlers, null);
            return result;
        }
        catch (Exception e) {
            GlobalMainProcessHandlerListener.INSTANCE.finishTransform(this.handlers, e);
            throw e;
        }
    }

    @Override
    protected AbsTransformFlow afterTransform(TransformEngine transformEngine) throws IOException {
        Schedulers.COMPUTATION().submitAndAwait(this.handlers, plugin -> plugin.afterTransform(transformEngine));
        return this;
    }

    @Override
    @Nullable
    public Graph getClassGraph() {
        return this.mClassGraph;
    }

    @Override
    public void registerTransformFlowListener(TransformFlowListener listener) throws UnsupportedOperationException {
        this.listenerManager.registerTransformFlowListener(listener);
    }

    @Override
    public boolean isLifecycleAware() {
        return true;
    }
}

