/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.graph;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ss.android.ugc.bytex.common.graph.FieldEntity;
import com.ss.android.ugc.bytex.common.graph.Jsonable;
import com.ss.android.ugc.bytex.common.graph.MethodEntity;
import com.ss.android.ugc.bytex.common.graph.cache.GraphTypeAdapterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClassEntity
implements Jsonable {
    public int access;
    public String name;
    public String superName;
    public List<String> interfaces;
    public List<FieldEntity> fields;
    public List<MethodEntity> methods;
    public boolean fromAndroid;

    public ClassEntity(String name, int access) {
        this.name = name;
        this.access = access;
        this.interfaces = Collections.emptyList();
        this.fields = Collections.emptyList();
        this.methods = Collections.emptyList();
    }

    public ClassEntity(int access, String name, String superName, List<String> interfaces) {
        this.access = access;
        this.name = name;
        this.superName = superName;
        this.interfaces = interfaces;
        this.fields = new ArrayList<FieldEntity>();
        this.methods = new ArrayList<MethodEntity>();
    }

    public String toString() {
        return "ClassEntity{access=" + this.access + ", name='" + this.name + "', superName='" + this.superName + "', interfaces=" + this.interfaces + ", fields=" + this.fields + ", methods=" + this.methods + "}";
    }

    @Override
    public void read(JsonReader jsonReader, Gson gson2) throws IOException {
        if (this.getClass() != ClassEntity.class) {
            throw new IllegalStateException("Jsonable Not Supported");
        }
        jsonReader.beginObject();
        block25: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "access": 
                case "a": {
                    this.access = jsonReader.nextInt();
                    continue block25;
                }
                case "name": 
                case "n": {
                    this.name = jsonReader.nextString();
                    continue block25;
                }
                case "superName": 
                case "s": {
                    this.superName = jsonReader.nextString();
                    continue block25;
                }
                case "interfaces": 
                case "i": {
                    this.interfaces = GraphTypeAdapterFactory.readList(jsonReader, gson2, String.class);
                    continue block25;
                }
                case "fields": 
                case "f": {
                    this.fields = GraphTypeAdapterFactory.readList(jsonReader, gson2, FieldEntity.class);
                    continue block25;
                }
                case "methods": 
                case "m": {
                    this.methods = GraphTypeAdapterFactory.readList(jsonReader, gson2, MethodEntity.class);
                    continue block25;
                }
                case "fromAndroid": 
                case "e": {
                    this.fromAndroid = jsonReader.nextBoolean();
                    continue block25;
                }
            }
            throw new RuntimeException("unsupport json name:" + name);
        }
        jsonReader.endObject();
    }

    @Override
    public void write(JsonWriter jsonWriter, Gson gson2) throws IOException {
        if (this.getClass() != ClassEntity.class) {
            throw new IllegalStateException("Jsonable Not Supported");
        }
        jsonWriter.beginObject();
        jsonWriter.name("a").value((long)this.access);
        if (this.name != null) {
            jsonWriter.name("n").value(this.name);
        }
        if (this.superName != null) {
            jsonWriter.name("s").value(this.superName);
        }
        if (this.interfaces != null && !this.interfaces.isEmpty()) {
            jsonWriter.name("i");
            GraphTypeAdapterFactory.writeList(jsonWriter, gson2, this.interfaces);
        }
        if (this.fields != null && !this.fields.isEmpty()) {
            jsonWriter.name("f");
            GraphTypeAdapterFactory.writeList(jsonWriter, gson2, this.fields);
        }
        if (this.methods != null && !this.methods.isEmpty()) {
            jsonWriter.name("m");
            GraphTypeAdapterFactory.writeList(jsonWriter, gson2, this.methods);
        }
        jsonWriter.name("e").value(this.fromAndroid);
        jsonWriter.endObject();
    }
}

