/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.graph;

import com.ss.android.ugc.bytex.common.graph.ClassEntity;
import com.ss.android.ugc.bytex.common.graph.ClassNode;
import com.ss.android.ugc.bytex.common.graph.FieldEntity;
import com.ss.android.ugc.bytex.common.graph.InterfaceNode;
import com.ss.android.ugc.bytex.common.graph.MethodEntity;
import com.ss.android.ugc.bytex.common.graph.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;

public class Graph {
    protected Map<String, Node> nodeMap;

    Graph(Map<String, Node> nodesMap) {
        this.nodeMap = nodesMap;
    }

    public boolean inherit(String child, String parent) {
        Node childNode = this.nodeMap.get(child);
        Node parentNode = this.nodeMap.get(parent);
        return childNode != null && childNode.inheritFrom(parentNode);
    }

    public Node get(String className) {
        return this.nodeMap.get(className);
    }

    public String getCommonSuperClass(String type1, String type2) {
        if (type1.equals(type2)) {
            return type1;
        }
        Node node = this.nodeMap.get(type1);
        if (node == null) {
            throw new TypeNotPresentException(type1, null);
        }
        Node node2 = this.nodeMap.get(type2);
        if (node2 == null) {
            throw new TypeNotPresentException(type2, null);
        }
        if (node.isAssignableFrom(node2)) {
            return type1;
        }
        if (node2.isAssignableFrom(node)) {
            return type2;
        }
        if (node instanceof InterfaceNode || node2 instanceof InterfaceNode) {
            return "java/lang/Object";
        }
        while (!(node = node.parent).isAssignableFrom(node2)) {
        }
        return node.entity.name.replace('.', '/');
    }

    public List<ClassNode> implementsOf(String interfaceName) {
        Node node = this.nodeMap.get(interfaceName);
        if (node == null) {
            return Collections.emptyList();
        }
        if (!(node instanceof InterfaceNode)) {
            throw new IllegalArgumentException(interfaceName + " is not a interface");
        }
        InterfaceNode realNode = (InterfaceNode)node;
        return realNode.implementedClasses;
    }

    public boolean implementOf(String child, String interfaceName) {
        Node node = this.nodeMap.get(interfaceName);
        if (node == null) {
            return false;
        }
        if (!(node instanceof InterfaceNode)) {
            return false;
        }
        InterfaceNode interfaceNode = (InterfaceNode)node;
        boolean[] found = new boolean[]{false};
        this.traverseChildren(interfaceNode, (Node n) -> {
            if (child.equals(n.entity.name)) {
                found[0] = true;
                return true;
            }
            return false;
        });
        return found[0];
    }

    public List<ClassNode> childrenOf(String className) {
        Node node = this.nodeMap.get(className);
        if (node == null) {
            return Collections.emptyList();
        }
        if (!(node instanceof ClassNode)) {
            throw new IllegalArgumentException(className + " is not a interface");
        }
        ClassNode classNode = (ClassNode)node;
        ArrayList<ClassNode> children = new ArrayList<ClassNode>();
        this.traverseAllChild(classNode, children::add);
        return children;
    }

    public boolean instanceofClass(String className, String targetClassName) throws ClassNotFoundException {
        Node child = this.get(className);
        if (child == null) {
            throw new ClassNotFoundException(String.format("class %s not found!", className));
        }
        Node parent = this.get(targetClassName);
        if (parent == null) {
            throw new ClassNotFoundException(String.format("class %s not found!", targetClassName));
        }
        return child.inheritFrom(parent);
    }

    public void traverseAllChild(ClassNode classNode, Consumer<ClassNode> visitor) {
        LinkedList handleQ = new LinkedList();
        classNode.children.forEach(handleQ::offer);
        while (!handleQ.isEmpty()) {
            ClassNode n = (ClassNode)handleQ.poll();
            visitor.accept(n);
            n.children.forEach(handleQ::offer);
        }
    }

    public void traverseChildren(ClassNode classNode, Function<ClassNode, Boolean> visitor) {
        LinkedList handleQ = new LinkedList();
        classNode.children.forEach(handleQ::offer);
        while (!handleQ.isEmpty()) {
            ClassNode n = (ClassNode)handleQ.poll();
            if (visitor != null && visitor.apply(n).booleanValue()) break;
            n.children.forEach(handleQ::offer);
        }
    }

    public void traverseChildren(InterfaceNode interfaceNode, Function<Node, Boolean> visitor) {
        LinkedList handleQ = new LinkedList();
        interfaceNode.children.forEach(handleQ::offer);
        interfaceNode.implementedClasses.forEach(handleQ::offer);
        while (!handleQ.isEmpty()) {
            Node n = (Node)handleQ.poll();
            if (visitor != null && visitor.apply(n).booleanValue()) break;
            if (n instanceof InterfaceNode) {
                ((InterfaceNode)n).children.forEach(handleQ::offer);
                ((InterfaceNode)n).implementedClasses.forEach(handleQ::offer);
                continue;
            }
            if (!(n instanceof ClassNode)) continue;
            ((ClassNode)n).children.forEach(handleQ::offer);
        }
    }

    public void backtrackToParent(ClassNode classNode, Function<ClassNode, Boolean> visitor) {
        while (!(classNode == null || visitor != null && visitor.apply(classNode).booleanValue())) {
            classNode = classNode.parent;
        }
    }

    public boolean overrideFromSuper(String className, String methodName, String desc) {
        Node classNode = this.get(className);
        if (classNode == null) {
            throw new RuntimeException("No such method : " + methodName);
        }
        if (this.isMethodFromInterface(methodName, desc, classNode)) {
            return true;
        }
        while (classNode.parent != null) {
            ClassEntity parent = classNode.parent.entity;
            if (parent.methods.stream().anyMatch(m -> m.name().equals(methodName) && m.desc().equals(desc))) {
                return true;
            }
            if (this.isMethodFromInterface(methodName, desc, classNode)) {
                return true;
            }
            classNode = classNode.parent;
        }
        return false;
    }

    private boolean isMethodFromInterface(String methodName, String desc, Node classNode) {
        LinkedList handleQ = new LinkedList();
        classNode.interfaces.forEach(handleQ::offer);
        while (!handleQ.isEmpty()) {
            InterfaceNode n = (InterfaceNode)handleQ.poll();
            if (n.entity.methods.stream().anyMatch(m -> m.name().equals(methodName) && m.desc().equals(desc))) {
                return true;
            }
            n.interfaces.forEach(handleQ::offer);
        }
        return false;
    }

    public boolean overridedBySubclass(String className, String methodName, String desc) {
        ClassNode classNode = (ClassNode)this.get(className);
        if (classNode == null) {
            throw new RuntimeException("No such method : " + methodName);
        }
        AtomicBoolean found = new AtomicBoolean(false);
        this.traverseChildren(classNode, (ClassNode child) -> {
            ClassEntity childEntity = child.entity;
            for (MethodEntity m : childEntity.methods) {
                if (!m.name().equals(methodName) || !m.desc().equals(desc)) continue;
                found.set(true);
                return true;
            }
            if (this.isMethodFromInterface(methodName, desc, (Node)child)) {
                found.set(true);
                return true;
            }
            return false;
        });
        return found.get();
    }

    public FieldEntity confirmOriginField(String owner, String name, String desc) {
        Node node = this.get(owner);
        if (node == null) {
            return null;
        }
        return node.confirmOriginField(name, desc);
    }

    public MethodEntity confirmOriginMethod(String owner, String name, String desc) {
        Node node = this.get(owner);
        if (node == null) {
            return null;
        }
        return node.confirmOriginMethod(name, desc);
    }

    public Map<String, Node> getNodes() {
        return Collections.unmodifiableMap(this.nodeMap);
    }
}

