/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.graph;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ss.android.ugc.bytex.common.graph.Jsonable;
import com.ss.android.ugc.bytex.common.graph.MemberType;
import java.io.IOException;
import java.util.Objects;

public abstract class MemberEntity
implements Jsonable {
    public static final transient int ACCESS_UNKNOWN = -1;
    protected int access;
    protected String className;
    protected String name;
    protected String desc;
    protected String signature;

    public MemberEntity(int access, String className, String name, String desc, String signature) {
        this.access = access;
        this.className = className;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
    }

    public MemberEntity(int access, String className, String name, String desc) {
        this(access, className, name, desc, null);
    }

    public abstract MemberType type();

    public int access() {
        return this.access;
    }

    public String className() {
        return this.className;
    }

    public String name() {
        return this.name;
    }

    public String desc() {
        return this.desc;
    }

    public String signature() {
        return this.signature;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberEntity that = (MemberEntity)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.name, that.name) && Objects.equals(this.desc, that.desc) && Objects.equals((Object)this.type(), (Object)that.type());
    }

    public int hashCode() {
        return Objects.hash(this.className, this.name, this.desc);
    }

    public String toString() {
        return "MemberEntity{access=" + this.access + ", className='" + this.className + "', name='" + this.name + "', desc='" + this.desc + "'}";
    }

    @Override
    public void read(JsonReader jsonReader, Gson gson2) throws IOException {
        throw new UnsupportedOperationException("Jsonable Not Supported");
    }

    @Override
    public void write(JsonWriter jsonWriter, Gson gson2) throws IOException {
        throw new UnsupportedOperationException("Jsonable Not Supported");
    }
}

