/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.graph;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ss.android.ugc.bytex.common.graph.MemberEntity;
import com.ss.android.ugc.bytex.common.graph.MemberType;
import com.ss.android.ugc.bytex.common.graph.cache.GraphTypeAdapterFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MethodEntity
extends MemberEntity {
    public List<String> exceptions;

    public MethodEntity(int access, String className, String name, String desc) {
        this(access, className, name, desc, (String[])null);
    }

    public MethodEntity(int access, String className, String name, String desc, String[] exceptions) {
        super(access, className, name, desc);
        this.exceptions = exceptions == null ? Collections.emptyList() : Arrays.asList(exceptions);
    }

    @Override
    public MemberType type() {
        return MemberType.METHOD;
    }

    @Override
    public void read(JsonReader jsonReader, Gson gson2) throws IOException {
        if (this.getClass() != MethodEntity.class) {
            throw new IllegalStateException("Jsonable Not Supported");
        }
        jsonReader.beginObject();
        block22: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "access": 
                case "a": {
                    this.access = jsonReader.nextInt();
                    continue block22;
                }
                case "className": 
                case "c": {
                    this.className = jsonReader.nextString();
                    continue block22;
                }
                case "name": 
                case "n": {
                    this.name = jsonReader.nextString();
                    continue block22;
                }
                case "desc": 
                case "d": {
                    this.desc = jsonReader.nextString();
                    continue block22;
                }
                case "signature": 
                case "s": {
                    this.signature = jsonReader.nextString();
                    continue block22;
                }
                case "exceptions": 
                case "e": {
                    this.exceptions = GraphTypeAdapterFactory.readList(jsonReader, gson2, String.class);
                    continue block22;
                }
            }
            throw new RuntimeException("unsupport json name:" + name);
        }
        jsonReader.endObject();
    }

    @Override
    public void write(JsonWriter jsonWriter, Gson gson2) throws IOException {
        if (this.getClass() != MethodEntity.class) {
            throw new IllegalStateException("Jsonable Not Supported");
        }
        jsonWriter.beginObject();
        jsonWriter.name("a").value((long)this.access);
        if (this.className != null) {
            jsonWriter.name("c").value(this.className);
        }
        if (this.name != null) {
            jsonWriter.name("n").value(this.name);
        }
        if (this.desc != null) {
            jsonWriter.name("d").value(this.desc);
        }
        if (this.signature != null) {
            jsonWriter.name("s").value(this.signature);
        }
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            jsonWriter.name("e");
            GraphTypeAdapterFactory.writeList(jsonWriter, gson2, this.exceptions);
        }
        jsonWriter.endObject();
    }
}

