/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.graph;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ss.android.ugc.bytex.common.graph.ClassEntity;
import com.ss.android.ugc.bytex.common.graph.ClassNode;
import com.ss.android.ugc.bytex.common.graph.FieldEntity;
import com.ss.android.ugc.bytex.common.graph.InterfaceNode;
import com.ss.android.ugc.bytex.common.graph.Jsonable;
import com.ss.android.ugc.bytex.common.graph.MethodEntity;
import com.ss.android.ugc.bytex.common.utils.TypeUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Pair;

public abstract class Node
implements Jsonable {
    public ClassNode parent;
    public List<InterfaceNode> interfaces;
    public ClassEntity entity;
    public final transient AtomicBoolean defined = new AtomicBoolean(false);

    public Node(ClassEntity entity, ClassNode parent, List<InterfaceNode> interfaces) {
        this.entity = entity;
        this.parent = parent;
        this.interfaces = interfaces;
    }

    public final boolean isAssignableFrom(Node node) {
        if (node == null) {
            return false;
        }
        if (this.entity.name.equals(node.entity.name)) {
            return true;
        }
        LinkedList<InterfaceNode> interfaces = new LinkedList<InterfaceNode>();
        if (node.interfaces != null) {
            interfaces.addAll(node.interfaces);
        }
        ClassNode parent = node.parent;
        while (parent != null) {
            if (this.entity.name.equals(parent.entity.name)) {
                return true;
            }
            if (parent.interfaces != null) {
                interfaces.addAll(parent.interfaces);
            }
            parent = parent.parent;
        }
        while (!interfaces.isEmpty()) {
            Node aInterface = (Node)interfaces.poll();
            if (this.entity.name.equals(aInterface.entity.name)) {
                return true;
            }
            if (aInterface.interfaces == null) continue;
            interfaces.addAll(aInterface.interfaces);
        }
        return false;
    }

    public final boolean inheritFrom(Node node) {
        if (node == null) {
            return false;
        }
        if (this.entity.name.equals(node.entity.name)) {
            return true;
        }
        boolean isInterfaceNode = node instanceof InterfaceNode;
        LinkedList<InterfaceNode> interfaces = new LinkedList<InterfaceNode>();
        if (isInterfaceNode && this.interfaces != null) {
            interfaces.addAll(this.interfaces);
        }
        ClassNode parent = this.parent;
        while (parent != null) {
            if (isInterfaceNode) {
                interfaces.addAll(parent.interfaces);
            } else if (node.entity.name.equals(parent.entity.name)) {
                return true;
            }
            parent = parent.parent;
        }
        while (!interfaces.isEmpty()) {
            Node aInterface = (Node)interfaces.poll();
            if (node.entity.name.equals(aInterface.entity.name)) {
                return true;
            }
            if (aInterface.interfaces == null) continue;
            interfaces.addAll(aInterface.interfaces);
        }
        return false;
    }

    public MethodEntity confirmOriginMethod(String name, String desc) {
        LinkedList interfaces = new LinkedList();
        Node node = this;
        while (node != null) {
            Optional<MethodEntity> findMethod = node.entity.methods.stream().filter(m -> name.equals(m.name()) && desc.equals(m.desc())).findAny();
            if (findMethod.isPresent()) {
                MethodEntity realMethod = findMethod.get();
                String owner = node.entity.name;
                if (TypeUtil.isPrivate(realMethod.access) && !owner.equals(realMethod.className)) {
                    return null;
                }
                return realMethod;
            }
            node.interfaces.forEach(interfaces::offer);
            node = node.parent;
        }
        MethodEntity candidate = null;
        while (!interfaces.isEmpty()) {
            Node interfaceNode = (Node)interfaces.poll();
            if (interfaceNode == null) continue;
            Optional<MethodEntity> findMethod = interfaceNode.entity.methods.stream().filter(m -> name.equals(m.name()) && desc.equals(m.desc())).findAny();
            if (findMethod.isPresent()) {
                MethodEntity realMethod = findMethod.get();
                if (TypeUtil.isAbstract(realMethod.access)) {
                    candidate = realMethod;
                    continue;
                }
                return realMethod;
            }
            if (interfaceNode.interfaces == null) continue;
            interfaceNode.interfaces.forEach(interfaces::offer);
        }
        return candidate;
    }

    public FieldEntity confirmOriginField(String name, String desc) {
        Node node = this;
        LinkedList interfaces = new LinkedList();
        while (node != null) {
            ClassEntity entity = node.entity;
            String owner = entity.name;
            Optional<FieldEntity> findField = entity.fields.stream().filter(f -> (!TypeUtil.isPrivate(f.access) || f.className().equals(owner)) && f.name().equals(name) && f.desc().equals(desc)).findAny();
            if (findField.isPresent()) {
                return findField.get();
            }
            node.interfaces.forEach(interfaces::offer);
            node = node.parent;
        }
        while (!interfaces.isEmpty()) {
            Node interfaceNode = (Node)interfaces.poll();
            if (interfaceNode == null) continue;
            Optional<FieldEntity> findMethod = interfaceNode.entity.fields.stream().filter(f -> name.equals(f.name()) && desc.equals(f.desc())).findAny();
            if (findMethod.isPresent()) {
                return findMethod.get();
            }
            if (interfaceNode.interfaces == null) continue;
            interfaceNode.interfaces.forEach(interfaces::offer);
        }
        return null;
    }

    public Pair<Set<ClassNode>, Set<InterfaceNode>> getAllChildren(boolean includeSelf) {
        Node node;
        HashSet<ClassNode> classNodes = new HashSet<ClassNode>();
        HashSet<Node> itfNodes = new HashSet<Node>();
        HashSet<Node> handleQ = new HashSet<Node>();
        if (this instanceof ClassNode) {
            node = (ClassNode)this;
            if (includeSelf) {
                classNodes.add((ClassNode)node);
            }
            handleQ.addAll(node.children);
        } else if (this instanceof InterfaceNode) {
            node = (InterfaceNode)this;
            if (includeSelf) {
                itfNodes.add(node);
            }
            handleQ.addAll(((InterfaceNode)node).children);
            handleQ.addAll(((InterfaceNode)node).implementedClasses);
        }
        while (!handleQ.isEmpty()) {
            Iterator iterator = handleQ.iterator();
            Node next = (Node)iterator.next();
            iterator.remove();
            if (next instanceof ClassNode) {
                ClassNode node2 = (ClassNode)next;
                classNodes.add(node2);
                for (ClassNode classNode : node2.children) {
                    if (classNodes.contains(classNode)) continue;
                    handleQ.add(classNode);
                }
                continue;
            }
            if (!(next instanceof InterfaceNode)) continue;
            InterfaceNode node2 = (InterfaceNode)next;
            itfNodes.add(node2);
            for (ClassNode classNode : node2.implementedClasses) {
                if (classNodes.contains(classNode)) continue;
                handleQ.add(classNode);
            }
            for (InterfaceNode interfaceNode : node2.children) {
                if (itfNodes.contains(interfaceNode)) continue;
                handleQ.add(interfaceNode);
            }
        }
        return new Pair(classNodes, itfNodes);
    }

    @Override
    public void read(JsonReader jsonReader, Gson gson2) throws IOException {
        throw new UnsupportedOperationException("Jsonable Not Supported");
    }

    @Override
    public void write(JsonWriter jsonWriter, Gson gson2) throws IOException {
        throw new UnsupportedOperationException("Jsonable Not Supported");
    }
}

