/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.graph.cache;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.ss.android.ugc.bytex.common.graph.ClassEntity;
import com.ss.android.ugc.bytex.common.graph.ClassNode;
import com.ss.android.ugc.bytex.common.graph.FieldEntity;
import com.ss.android.ugc.bytex.common.graph.InterfaceNode;
import com.ss.android.ugc.bytex.common.graph.MethodEntity;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public final class GraphTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson2, TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (rawType == InterfaceNode.class) {
            return new InterfaceNodeTypeAdapter(gson2);
        }
        if (rawType == ClassNode.class) {
            return new ClassNodeTypeAdapter(gson2);
        }
        if (rawType == ClassEntity.class) {
            return new ClassEntityTypeAdapter(gson2);
        }
        if (rawType == FieldEntity.class) {
            return new FieldEntityTypeAdapter(gson2);
        }
        if (rawType == MethodEntity.class) {
            return new MethodEntityTypeAdapter(gson2);
        }
        return null;
    }

    public static <T> List<T> readList(JsonReader jsonReader, Gson gson2, Class<T> t) throws IOException {
        JsonToken peek = jsonReader.peek();
        if (peek == JsonToken.NULL) {
            return null;
        }
        jsonReader.beginArray();
        LinkedList<Object> r = new LinkedList<Object>();
        while (jsonReader.peek() != JsonToken.END_ARRAY) {
            if (t == String.class) {
                r.add(jsonReader.nextString());
                continue;
            }
            r.add(gson2.getAdapter(t).read(jsonReader));
        }
        jsonReader.endArray();
        return r;
    }

    public static <T> void writeList(JsonWriter jsonWriter, Gson gson2, List<T> list) throws IOException {
        jsonWriter.beginArray();
        for (T t : list) {
            if (t instanceof String) {
                jsonWriter.value((String)t);
                continue;
            }
            if (t instanceof FieldEntity) {
                gson2.getAdapter(FieldEntity.class).write(jsonWriter, (Object)((FieldEntity)t));
                continue;
            }
            if (t instanceof MethodEntity) {
                gson2.getAdapter(MethodEntity.class).write(jsonWriter, (Object)((MethodEntity)t));
                continue;
            }
            if (t instanceof InterfaceNode) {
                gson2.getAdapter(InterfaceNode.class).write(jsonWriter, (Object)((InterfaceNode)t));
                continue;
            }
            if (t instanceof ClassNode) {
                gson2.getAdapter(ClassNode.class).write(jsonWriter, (Object)((ClassNode)t));
                continue;
            }
            gson2.getAdapter(new TypeToken<T>(){}).write(jsonWriter, t);
        }
        jsonWriter.endArray();
    }

    public final class MethodEntityTypeAdapter
    extends SynchronizedTypeAdapter<MethodEntity> {
        MethodEntityTypeAdapter(Gson gson2) {
            super(gson2);
        }

        @Override
        protected void writeInSync(JsonWriter out, MethodEntity value) throws IOException {
            value.write(out, this.gson);
        }

        @Override
        protected MethodEntity readInSync(JsonReader in) throws IOException {
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                return null;
            }
            MethodEntity entity = new MethodEntity(0, null, null, null);
            entity.read(in, this.gson);
            return entity;
        }
    }

    public final class FieldEntityTypeAdapter
    extends SynchronizedTypeAdapter<FieldEntity> {
        FieldEntityTypeAdapter(Gson gson2) {
            super(gson2);
        }

        @Override
        protected void writeInSync(JsonWriter out, FieldEntity value) throws IOException {
            value.write(out, this.gson);
        }

        @Override
        protected FieldEntity readInSync(JsonReader in) throws IOException {
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                return null;
            }
            FieldEntity entity = new FieldEntity(0, null, null, null);
            entity.read(in, this.gson);
            return entity;
        }
    }

    public final class ClassEntityTypeAdapter
    extends SynchronizedTypeAdapter<ClassEntity> {
        ClassEntityTypeAdapter(Gson gson2) {
            super(gson2);
        }

        @Override
        protected void writeInSync(JsonWriter out, ClassEntity value) throws IOException {
            value.write(out, this.gson);
        }

        @Override
        protected ClassEntity readInSync(JsonReader in) throws IOException {
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                return null;
            }
            ClassEntity entity = new ClassEntity(null, 0);
            entity.read(in, this.gson);
            return entity;
        }
    }

    public final class ClassNodeTypeAdapter
    extends SynchronizedTypeAdapter<ClassNode> {
        ClassNodeTypeAdapter(Gson gson2) {
            super(gson2);
        }

        @Override
        protected void writeInSync(JsonWriter out, ClassNode value) throws IOException {
            value.write(out, this.gson);
        }

        @Override
        protected ClassNode readInSync(JsonReader in) throws IOException {
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                return null;
            }
            ClassNode node = new ClassNode(null);
            node.read(in, this.gson);
            return node;
        }
    }

    public final class InterfaceNodeTypeAdapter
    extends SynchronizedTypeAdapter<InterfaceNode> {
        InterfaceNodeTypeAdapter(Gson gson2) {
            super(gson2);
        }

        @Override
        protected void writeInSync(JsonWriter out, InterfaceNode value) throws IOException {
            value.write(out, this.gson);
        }

        @Override
        protected InterfaceNode readInSync(JsonReader in) throws IOException {
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                return null;
            }
            InterfaceNode node = new InterfaceNode(null);
            node.read(in, this.gson);
            return node;
        }
    }

    private static abstract class SynchronizedTypeAdapter<T>
    extends TypeAdapter<T> {
        protected final Gson gson;

        SynchronizedTypeAdapter(Gson gson2) {
            this.gson = gson2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void write(JsonWriter out, T value) throws IOException {
            JsonWriter jsonWriter = out;
            synchronized (jsonWriter) {
                this.writeInSync(out, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T read(JsonReader in) throws IOException {
            JsonReader jsonReader = in;
            synchronized (jsonReader) {
                return this.readInSync(in);
            }
        }

        protected abstract void writeInSync(JsonWriter var1, T var2) throws IOException;

        protected abstract T readInSync(JsonReader var1) throws IOException;
    }
}

