/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.internal;

import com.ss.android.ugc.bytex.common.flow.TransformFlow;
import com.ss.android.ugc.bytex.common.flow.main.MainTransformFlow;
import com.ss.android.ugc.bytex.common.graph.EditableGraph;
import com.ss.android.ugc.bytex.common.graph.Graph;
import com.ss.android.ugc.bytex.common.internal.FlowBinder;
import com.ss.android.ugc.bytex.common.internal.ITransformPipeline;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.ss.android.ugc.bytex.transformer.TransformEngine;
import java.io.IOException;

public class TransformFlowerManager
implements ITransformPipeline {
    private final MainTransformFlow commonFlow;
    private final TransformEngine engine;
    private TransformFlow first;

    public TransformFlowerManager(TransformContext context2) {
        this.engine = new TransformEngine(context2);
        this.commonFlow = new MainTransformFlow(this.engine);
    }

    @Override
    public void bind(FlowBinder binder) {
        TransformFlow flow = binder.bind(this);
        if (this.first == null) {
            this.first = flow;
            return;
        }
        if (this.first.getPriority() < flow.getPriority()) {
            this.first.setPreTransformFlow(flow);
            flow.setNextTransformFlow(this.first);
            this.first = flow;
        } else {
            TransformFlow find = this.first;
            for (TransformFlow transformFlow : this.first) {
                if (transformFlow == flow) {
                    return;
                }
                find = transformFlow;
                TransformFlow next = transformFlow.getNextTransformFlow();
                if (next != null && next.getPriority() >= flow.getPriority()) continue;
                break;
            }
            TransformFlow findNext = find.getNextTransformFlow();
            flow.setPreTransformFlow(find);
            flow.setNextTransformFlow(findNext);
            if (findNext != null) {
                findNext.setPreTransformFlow(flow);
            }
            find.setNextTransformFlow(flow);
        }
    }

    public MainTransformFlow getCommonFlow() {
        return this.commonFlow;
    }

    @Override
    public void onPreTransform() throws IOException, InterruptedException {
        for (TransformFlow flow : this.first) {
            flow.prepare();
        }
    }

    @Override
    public void runTransform() throws IOException, InterruptedException {
        for (TransformFlow flow : this.first) {
            flow.run();
            Graph graph = flow.getClassGraph();
            if (!(graph instanceof EditableGraph)) continue;
            ((EditableGraph)graph).clear();
        }
    }

    @Override
    public void onPostTransform() throws IOException {
        this.engine.transformOutput();
    }

    @Override
    public void skipTransform() throws IOException {
        this.engine.skip();
    }
}

