/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.log.Impl;

import com.google.common.io.Files;
import com.ss.android.ugc.bytex.common.log.Impl.BaseLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.gradle.api.logging.LogLevel;

public class FileLoggerImpl
extends BaseLogger {
    private PrintWriter pr;

    public static FileLoggerImpl of(String fileName) throws IOException {
        File logFile = new File(fileName);
        if (!logFile.exists()) {
            Files.createParentDirs((File)logFile);
        }
        PrintWriter pr = new PrintWriter(new FileOutputStream(fileName), true);
        return new FileLoggerImpl(pr);
    }

    private FileLoggerImpl(PrintWriter pr) {
        this.pr = pr;
    }

    @Override
    protected void write(LogLevel level, String prefix, String msg, Throwable t) {
        this.pr.println(String.format("%s [%-10s] %s", level.name(), prefix, msg));
        if (t != null) {
            t.printStackTrace(this.pr);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.pr != null) {
            this.pr.flush();
            this.pr.close();
            this.pr = null;
        }
    }
}

